/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.tableview;

import android.content.Context;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiUIHelper;
import ti.modules.titanium.ui.widget.tableview.TableViewModel;
import ti.modules.titanium.ui.widget.tableview.TiBaseTableViewItem;

public class TiTableViewHeaderItem
extends TiBaseTableViewItem {
    private static final String LCAT = "TitaniamTableViewItem";
    private static final boolean DBG = TiConfig.LOGD;
    private RowView rowView;

    public TiTableViewHeaderItem(TiContext tiContext) {
        super(tiContext);
        this.handler = new Handler((Handler.Callback)this);
        this.rowView = new RowView((Context)tiContext.getActivity());
        this.addView((View)this.rowView, new ViewGroup.LayoutParams(-1, -1));
        this.setMinimumHeight((int)TiUIHelper.getRawDIPSize((float)18.0f, (Context)tiContext.getActivity()));
    }

    @Override
    public void setRowData(TableViewModel.Item item) {
        this.rowView.setRowData(item);
    }

    @Override
    public TableViewModel.Item getRowData() {
        return this.rowView.getRowData();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        int w = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int h = Math.max(View.MeasureSpec.getSize((int)heightMeasureSpec), this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(TiTableViewHeaderItem.resolveSize((int)w, (int)widthMeasureSpec), TiTableViewHeaderItem.resolveSize((int)h, (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.rowView.layout(left, 0, right, bottom - top);
    }

    class RowView
    extends RelativeLayout {
        private TextView textView;
        private TableViewModel.Item item;

        public RowView(Context context) {
            super(context);
            this.setGravity(16);
            this.textView = new TextView(context);
            this.textView.setId(101);
            this.textView.setFocusable(false);
            this.textView.setFocusableInTouchMode(false);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            params.addRule(15);
            params.alignWithParent = true;
            this.addView((View)this.textView, (ViewGroup.LayoutParams)params);
            this.setPadding(0, 0, 0, 0);
            this.setMinimumHeight((int)TiUIHelper.getRawDIPSize((float)18.0f, (Context)context));
            this.setVerticalFadingEdgeEnabled(false);
            TiUIHelper.styleText((TextView)this.textView, (String)"", (String)"10dp", (String)"normal");
            this.textView.setBackgroundColor(-12303292);
            this.textView.setTextColor(-3355444);
            TiUIHelper.setTextViewDIPPadding((TextView)this.textView, (int)4, (int)2);
        }

        public void setRowData(TableViewModel.Item item) {
            this.item = item;
            if (item.headerText != null) {
                this.textView.setText((CharSequence)item.headerText, TextView.BufferType.NORMAL);
            } else if (item.footerText != null) {
                this.textView.setText((CharSequence)item.footerText, TextView.BufferType.NORMAL);
            }
        }

        public TableViewModel.Item getRowData() {
            return this.item;
        }
    }
}

