/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.tableview;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiColorHelper;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiCompositeLayout;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.TableViewProxy;
import ti.modules.titanium.ui.TableViewRowProxy;
import ti.modules.titanium.ui.widget.searchbar.TiUISearchBar;
import ti.modules.titanium.ui.widget.tableview.TableViewModel;
import ti.modules.titanium.ui.widget.tableview.TiBaseTableViewItem;
import ti.modules.titanium.ui.widget.tableview.TiTableViewHeaderItem;
import ti.modules.titanium.ui.widget.tableview.TiTableViewRowProxyItem;
import ti.modules.titanium.ui.widget.tableview.TiTableViewSelector;

public class TiTableView
extends FrameLayout
implements TiUISearchBar.OnSearchChangeListener {
    public static final int TI_TABLE_VIEW_ID = 101;
    private static final String LCAT = "TiTableView";
    private static final boolean DBG = TiConfig.LOGD;
    protected static final int MAX_CLASS_NAMES = 32;
    private TableViewModel viewModel;
    private ListView listView;
    private TTVListAdapter adapter;
    private OnItemClickedListener itemClickListener;
    private HashMap<String, Integer> rowTypes;
    private AtomicInteger rowTypeCounter;
    private String filterAttribute;
    private String filterText;
    private TiContext tiContext;
    private TableViewProxy proxy;
    private boolean filterCaseInsensitive = true;
    private TiTableViewSelector selector;

    public TiTableView(TiContext tiContext, TableViewProxy proxy) {
        super((Context)tiContext.getActivity());
        TiViewProxy view;
        this.tiContext = tiContext;
        this.proxy = proxy;
        this.rowTypes = new HashMap();
        this.rowTypeCounter = new AtomicInteger(-1);
        this.rowTypes.put("__header__", this.rowTypeCounter.incrementAndGet());
        this.rowTypes.put("__normal__", this.rowTypeCounter.incrementAndGet());
        this.rowTypes.put("__default__", this.rowTypeCounter.incrementAndGet());
        this.viewModel = new TableViewModel(tiContext, proxy);
        this.listView = new ListView(this.getContext());
        this.listView.setId(101);
        this.listView.setFocusable(true);
        this.listView.setFocusableInTouchMode(true);
        this.listView.setBackgroundColor(0);
        this.listView.setCacheColorHint(0);
        TableViewProxy fProxy = proxy;
        this.listView.setOnScrollListener(new AbsListView.OnScrollListener((KrollProxy)fProxy){
            final /* synthetic */ KrollProxy val$fProxy;
            {
                this.val$fProxy = krollProxy;
            }

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (scrollState == 0) {
                    KrollDict eventArgs = new KrollDict();
                    KrollDict size = new KrollDict();
                    size.put((Object)"width", (Object)TiTableView.this.getWidth());
                    size.put((Object)"height", (Object)TiTableView.this.getHeight());
                    eventArgs.put((Object)"size", (Object)size);
                    this.val$fProxy.fireEvent("scrollEnd", eventArgs);
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                KrollDict eventArgs = new KrollDict();
                eventArgs.put((Object)"firstVisibleItem", (Object)firstVisibleItem);
                eventArgs.put((Object)"visibleItemCount", (Object)visibleItemCount);
                eventArgs.put((Object)"totalItemCount", (Object)totalItemCount);
                KrollDict size = new KrollDict();
                size.put((Object)"width", (Object)TiTableView.this.getWidth());
                size.put((Object)"height", (Object)TiTableView.this.getHeight());
                eventArgs.put((Object)"size", (Object)size);
                this.val$fProxy.fireEvent("scroll", eventArgs);
            }
        });
        if (proxy.getProperties().containsKey((Object)"separatorColor")) {
            this.setSeparatorColor(TiConvert.toString((Object)proxy.getProperty("separatorColor")));
        }
        this.adapter = new TTVListAdapter(this.viewModel);
        if (proxy.hasProperty("headerView")) {
            view = (TiViewProxy)proxy.getProperty("headerView");
            this.listView.addHeaderView(this.layoutHeaderOrFooter(view), null, false);
        }
        if (proxy.hasProperty("footerView")) {
            view = (TiViewProxy)proxy.getProperty("footerView");
            this.listView.addFooterView(this.layoutHeaderOrFooter(view), null, false);
        }
        this.listView.setAdapter((ListAdapter)this.adapter);
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                if (TiTableView.this.itemClickListener != null) {
                    if (!(view instanceof TiBaseTableViewItem)) {
                        return;
                    }
                    if (TiTableView.this.proxy.hasProperty("headerView")) {
                        --position;
                    }
                    TiTableView.this.rowClicked((TiBaseTableViewItem)view, position);
                }
            }
        });
        this.addView((View)this.listView);
    }

    public void enableCustomSelector() {
        Drawable currentSelector = this.listView.getSelector();
        if (currentSelector != this.selector) {
            this.selector = new TiTableViewSelector(this.listView);
            this.listView.setSelector((Drawable)this.selector);
        }
    }

    protected TableViewModel.Item getItemAtPosition(int position) {
        return this.viewModel.getViewModel().get(this.adapter.index.get(position));
    }

    protected void rowClicked(TiBaseTableViewItem rowView, int position) {
        String viewClicked = rowView.getLastClickedViewName();
        TableViewModel.Item item = this.getItemAtPosition(position);
        KrollDict event = new KrollDict();
        TableViewRowProxy.fillClickEvent(event, this.viewModel, item);
        if (viewClicked != null) {
            event.put((Object)"layoutName", (Object)viewClicked);
        }
        event.put((Object)"searchMode", (Object)this.adapter.isFiltered());
        if (item.proxy != null && item.proxy instanceof TableViewRowProxy) {
            TableViewRowProxy rp = (TableViewRowProxy)item.proxy;
            event.put((Object)"source", (Object)rp);
            if (rp.hasListeners("click")) {
                rp.fireEvent("click", event);
            }
        }
        this.itemClickListener.onClick(event);
    }

    private View layoutHeaderOrFooter(TiViewProxy viewProxy) {
        TiUIView tiView = viewProxy.getView(this.tiContext.getActivity());
        View nativeView = tiView.getNativeView();
        TiCompositeLayout.LayoutParams params = tiView.getLayoutParams();
        int width = -2;
        int height = -2;
        if (params.autoHeight) {
            if (params.autoFillsHeight) {
                height = -1;
            }
        } else {
            height = params.optionHeight.getAsPixels((View)this.listView);
        }
        if (params.autoWidth) {
            if (params.autoFillsWidth) {
                width = -1;
            }
        } else {
            width = params.optionWidth.getAsPixels((View)this.listView);
        }
        AbsListView.LayoutParams p = new AbsListView.LayoutParams(width, height);
        nativeView.setLayoutParams((ViewGroup.LayoutParams)p);
        return nativeView;
    }

    public void dataSetChanged() {
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    public void setOnItemClickListener(OnItemClickedListener listener) {
        this.itemClickListener = listener;
    }

    public void setSeparatorColor(String colorstring) {
        int sepColor = TiColorHelper.parseColor((String)colorstring);
        int dividerHeight = this.listView.getDividerHeight();
        this.listView.setDivider((Drawable)new ColorDrawable(sepColor));
        this.listView.setDividerHeight(dividerHeight);
    }

    public TableViewModel getTableViewModel() {
        return this.viewModel;
    }

    public ListView getListView() {
        return this.listView;
    }

    @Override
    public void filterBy(String text) {
        this.filterText = text;
        if (this.adapter != null) {
            this.tiContext.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    TiTableView.this.dataSetChanged();
                }
            });
        }
    }

    public void setFilterAttribute(String filterAttribute) {
        this.filterAttribute = filterAttribute;
    }

    public void setFilterCaseInsensitive(boolean filterCaseInsensitive) {
        this.filterCaseInsensitive = filterCaseInsensitive;
    }

    public void release() {
        this.adapter = null;
        if (this.listView != null) {
            this.listView.setAdapter(null);
        }
        this.listView = null;
        if (this.viewModel != null) {
            this.viewModel.release();
        }
        this.viewModel = null;
        this.itemClickListener = null;
        this.tiContext = null;
    }

    class TTVListAdapter
    extends BaseAdapter {
        TableViewModel viewModel;
        ArrayList<Integer> index;
        private boolean filtered;

        TTVListAdapter(TableViewModel viewModel) {
            this.viewModel = viewModel;
            this.index = new ArrayList(viewModel.getRowCount());
            this.reIndexItems();
        }

        protected void registerClassName(String className) {
            if (!TiTableView.this.rowTypes.containsKey(className)) {
                if (DBG) {
                    Log.d((String)TiTableView.LCAT, (String)("registering new className " + className));
                }
                TiTableView.this.rowTypes.put(className, TiTableView.this.rowTypeCounter.incrementAndGet());
            }
        }

        public void reIndexItems() {
            ArrayList<TableViewModel.Item> items = this.viewModel.getViewModel();
            int count = items.size();
            this.index.clear();
            this.filtered = false;
            if (TiTableView.this.filterAttribute != null && TiTableView.this.filterText != null && TiTableView.this.filterAttribute.length() > 0 && TiTableView.this.filterText.length() > 0) {
                this.filtered = true;
                String filter = TiTableView.this.filterText;
                if (TiTableView.this.filterCaseInsensitive) {
                    filter = TiTableView.this.filterText.toLowerCase();
                }
                for (int i = 0; i < count; ++i) {
                    boolean keep = true;
                    TableViewModel.Item item = items.get(i);
                    this.registerClassName(item.className);
                    if (item.proxy.hasProperty(TiTableView.this.filterAttribute)) {
                        String t = TiConvert.toString((Object)item.proxy.getProperty(TiTableView.this.filterAttribute));
                        if (TiTableView.this.filterCaseInsensitive) {
                            t = t.toLowerCase();
                        }
                        if (t.indexOf(filter) < 0) {
                            keep = false;
                        }
                    }
                    if (!keep) continue;
                    this.index.add(i);
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    TableViewModel.Item item = items.get(i);
                    this.registerClassName(item.className);
                    this.index.add(i);
                }
            }
        }

        public int getCount() {
            return this.index.size();
        }

        public Object getItem(int position) {
            if (position >= this.index.size()) {
                return null;
            }
            return this.viewModel.getViewModel().get(this.index.get(position));
        }

        public long getItemId(int position) {
            return position;
        }

        public int getViewTypeCount() {
            return 32;
        }

        public int getItemViewType(int position) {
            TableViewModel.Item item = (TableViewModel.Item)this.getItem(position);
            this.registerClassName(item.className);
            return (Integer)TiTableView.this.rowTypes.get(item.className);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            TableViewModel.Item item = (TableViewModel.Item)this.getItem(position);
            TiBaseTableViewItem v = null;
            if (convertView != null) {
                TableViewRowProxy row;
                v = (TiBaseTableViewItem)convertView;
                boolean sameView = false;
                if (item.proxy instanceof TableViewRowProxy && (row = (TableViewRowProxy)item.proxy).getTableViewRowProxyItem() != null) {
                    sameView = ((Object)((Object)row.getTableViewRowProxyItem())).equals(convertView);
                }
                if (!sameView) {
                    if (v.getClassName().equals("__default__")) {
                        if (v.getRowData() != item) {
                            v = null;
                        }
                    } else if (!v.getClassName().equals(item.className)) {
                        Log.w((String)TiTableView.LCAT, (String)("Handed a view to convert with className " + v.getClassName() + " expected " + item.className));
                        v = null;
                    }
                }
            }
            if (v == null) {
                if (item.className.equals("__header__")) {
                    v = new TiTableViewHeaderItem(TiTableView.this.tiContext);
                    v.setClassName("__header__");
                } else if (item.className.equals("__normal__")) {
                    v = new TiTableViewRowProxyItem(TiTableView.this.tiContext);
                    v.setClassName("__normal__");
                } else if (item.className.equals("__default__")) {
                    v = new TiTableViewRowProxyItem(TiTableView.this.tiContext);
                    v.setClassName("__default__");
                } else {
                    v = new TiTableViewRowProxyItem(TiTableView.this.tiContext);
                    v.setClassName(item.className);
                }
                v.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
            }
            v.setRowData(item);
            return v;
        }

        public boolean areAllItemsEnabled() {
            return false;
        }

        public boolean isEnabled(int position) {
            TableViewModel.Item item = (TableViewModel.Item)this.getItem(position);
            boolean enabled = true;
            if (item != null && item.className.equals("__header__")) {
                enabled = false;
            }
            return enabled;
        }

        public boolean hasStableIds() {
            return true;
        }

        public void notifyDataSetChanged() {
            this.reIndexItems();
            super.notifyDataSetChanged();
        }

        public boolean isFiltered() {
            return this.filtered;
        }
    }

    public static interface OnItemClickedListener {
        public void onClick(KrollDict var1);
    }
}

