/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.tableview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Handler;
import android.os.Message;
import android.view.ViewGroup;
import java.io.InputStream;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiFileHelper;
import org.appcelerator.titanium.util.TiPlatformHelper;
import org.appcelerator.titanium.util.TiUIHelper;
import ti.modules.titanium.ui.widget.tableview.TableViewModel;

public abstract class TiBaseTableViewItem
extends ViewGroup
implements Handler.Callback {
    private static final String LCAT = "TiBaseTableViewItem";
    private static final boolean DBG = TiConfig.LOGD;
    private static Bitmap childIndicatorBitmap = null;
    private static Bitmap checkIndicatorBitmap = null;
    protected Handler handler;
    protected TiContext tiContext;
    protected TiFileHelper tfh;
    protected String className;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TiBaseTableViewItem(TiContext tiContext) {
        super((Context)tiContext.getActivity());
        this.tiContext = tiContext;
        this.handler = new Handler((Handler.Callback)this);
        if (childIndicatorBitmap != null && checkIndicatorBitmap != null) return;
        Class<TiBaseTableViewItem> clazz = TiBaseTableViewItem.class;
        synchronized (TiBaseTableViewItem.class) {
            String path;
            if (childIndicatorBitmap == null) {
                path = "/org/appcelerator/titanium/res/drawable/btn_more.png";
                switch (TiPlatformHelper.applicationLogicalDensity) {
                    case 240: {
                        path = "/org/appcelerator/titanium/res/drawable/btn_more_48.png";
                        break;
                    }
                    case 120: {
                        path = "/org/appcelerator/titanium/res/drawable/btn_more_18.png";
                    }
                }
                childIndicatorBitmap = BitmapFactory.decodeStream((InputStream)KrollDict.class.getResourceAsStream(path));
            }
            if (checkIndicatorBitmap != null) return;
            path = "/org/appcelerator/titanium/res/drawable/btn_check_buttonless_on.png";
            switch (TiPlatformHelper.applicationLogicalDensity) {
                case 240: {
                    path = "/org/appcelerator/titanium/res/drawable/btn_check_buttonless_on_48.png";
                    break;
                }
                case 120: {
                    path = "/org/appcelerator/titanium/res/drawable/btn_check_buttonless_on_1ow 8.png";
                }
            }
            checkIndicatorBitmap = BitmapFactory.decodeStream((InputStream)KrollDict.class.getResourceAsStream(path));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public abstract void setRowData(TableViewModel.Item var1);

    public abstract TableViewModel.Item getRowData();

    public boolean handleMessage(Message msg) {
        return false;
    }

    public boolean hasSelector() {
        return false;
    }

    public Drawable getSelectorDrawable() {
        return null;
    }

    public String getLastClickedViewName() {
        return null;
    }

    private BitmapDrawable createDrawable(Bitmap bitmap) {
        try {
            return new BitmapDrawable(bitmap);
        }
        catch (Throwable t) {
            try {
                Log.e((String)LCAT, (String)(t.getClass().getName() + ": " + t.getMessage()), (Throwable)t);
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public BitmapDrawable createHasChildDrawable() {
        return this.createDrawable(childIndicatorBitmap);
    }

    public BitmapDrawable createHasCheckDrawable() {
        return this.createDrawable(checkIndicatorBitmap);
    }

    public Drawable loadDrawable(String url) {
        if (this.tfh == null) {
            this.tfh = new TiFileHelper((Context)this.tiContext.getActivity());
        }
        return this.tfh.loadDrawable(this.tiContext, url, false);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Drawable getBackgroundImageDrawable(KrollDict d, String property) {
        String path = TiConvert.toString((KrollDict)d, (String)property);
        String url = this.tiContext.resolveUrl(null, path);
        return this.loadDrawable(url);
    }

    public void setBackgroundDrawable(KrollDict d, Drawable drawable) {
        if (d.containsKey((Object)"backgroundSelectedImage") || d.containsKey((Object)"backgroundSelectedColor")) {
            StateListDrawable stateDrawable = new StateListDrawable();
            ColorDrawable transparent = new ColorDrawable(0);
            stateDrawable.addState(new int[]{16842909, 16842910, 16842919}, (Drawable)transparent);
            stateDrawable.addState(new int[]{0x10100A1}, (Drawable)transparent);
            stateDrawable.addState(new int[]{16842908, 16842909, 16842910}, drawable);
            stateDrawable.addState(new int[0], drawable);
            this.setBackgroundDrawable((Drawable)stateDrawable);
        } else {
            this.setBackgroundDrawable(drawable);
        }
    }

    public void setBackgroundFromProperties(KrollDict props) {
        Drawable background = null;
        if (props.containsKey((Object)"backgroundImage")) {
            background = this.getBackgroundImageDrawable(props, "backgroundImage");
        } else if (props.containsKey((Object)"backgroundColor")) {
            Integer bgColor = TiConvert.toColor((KrollDict)props, (String)"backgroundColor");
            background = new ColorDrawable(bgColor.intValue());
        }
        if (props.containsKey((Object)"opacity")) {
            TiUIHelper.setDrawableOpacity((Drawable)background, (float)TiConvert.toFloat((KrollDict)props, (String)"opacity"));
        }
        this.setBackgroundDrawable(props, background);
    }

    public void release() {
        this.handler = null;
        this.tiContext = null;
    }
}

