/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.tableview;

import java.util.ArrayList;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.TiConvert;
import ti.modules.titanium.ui.TableViewProxy;
import ti.modules.titanium.ui.TableViewRowProxy;
import ti.modules.titanium.ui.TableViewSectionProxy;

public class TableViewModel {
    private static final String LCAT = "TableViewModel";
    private static final boolean DUMP = false;
    private TiContext tiContext;
    private TableViewProxy proxy;
    private boolean dirty;
    private ArrayList<Item> viewModel;

    public TableViewModel(TiContext tiContext, TableViewProxy proxy) {
        this.tiContext = tiContext;
        this.proxy = proxy;
        this.viewModel = new ArrayList();
        this.dirty = true;
    }

    public void release() {
        if (this.viewModel != null) {
            this.viewModel.clear();
            this.viewModel = null;
        }
        this.tiContext = null;
        this.proxy = null;
    }

    public static String classNameForRow(TableViewRowProxy rowProxy) {
        String className = TiConvert.toString((Object)rowProxy.getProperty("className"));
        if (className == null) {
            className = "__default__";
        }
        return className;
    }

    private Item itemForHeader(int index, TableViewSectionProxy proxy, String headerText, String footerText) {
        Item newItem = new Item(index);
        newItem.className = "__header__";
        if (headerText != null) {
            newItem.headerText = headerText;
        } else if (footerText != null) {
            newItem.footerText = footerText;
        }
        newItem.proxy = proxy;
        return newItem;
    }

    public int getRowCount() {
        if (this.viewModel == null) {
            return 0;
        }
        return this.viewModel.size();
    }

    public TableViewSectionProxy getSection(int index) {
        return this.proxy.getSections().get(index);
    }

    public ArrayList<Item> getViewModel() {
        if (this.dirty) {
            this.viewModel = new ArrayList();
            int sectionIndex = 0;
            int indexInSection = 0;
            int index = 0;
            ArrayList<TableViewSectionProxy> sections = this.proxy.getSections();
            if (sections != null) {
                for (TableViewSectionProxy section : sections) {
                    String headerTitle = TiConvert.toString((Object)section.getProperty("headerTitle"));
                    if (headerTitle != null) {
                        this.viewModel.add(this.itemForHeader(index, section, headerTitle, null));
                    }
                    for (TableViewRowProxy row : section.getRows()) {
                        Item item = new Item(index);
                        item.sectionIndex = sectionIndex;
                        item.indexInSection = indexInSection++;
                        item.proxy = row;
                        item.rowData = row;
                        item.className = TableViewModel.classNameForRow(row);
                        this.viewModel.add(item);
                        ++index;
                    }
                    String footerTitle = TiConvert.toString((Object)section.getProperty("footerTitle"));
                    if (footerTitle != null) {
                        this.viewModel.add(this.itemForHeader(index, section, null, footerTitle));
                    }
                    ++sectionIndex;
                    indexInSection = 0;
                }
                this.dirty = false;
            }
        }
        return this.viewModel;
    }

    public int getViewIndex(int index) {
        int position = -1;
        if (this.viewModel != null && index <= this.viewModel.size()) {
            for (int i = 0; i < this.viewModel.size(); ++i) {
                Item item = this.viewModel.get(i);
                if (index != item.index) continue;
                position = i;
                break;
            }
        }
        return position;
    }

    public int getRowHeight(int position, int defaultHeight) {
        int rowHeight = defaultHeight;
        Item item = this.viewModel.get(position);
        Object rh = item.proxy.getProperty("rowHeight");
        if (rh != null) {
            rowHeight = TiConvert.toInt((Object)rh);
        }
        return rowHeight;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public class Item {
        public int index;
        public int sectionIndex;
        public int indexInSection;
        public String headerText;
        public String footerText;
        public String name;
        public String className;
        public TiViewProxy proxy;
        public Object rowData;

        public Item(int index) {
            this.index = index;
        }

        public boolean hasHeader() {
            return this.headerText != null;
        }
    }
}

