/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.searchbar;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.TiConvert;
import ti.modules.titanium.ui.widget.TiUIText;

public class TiUISearchBar
extends TiUIText {
    protected ImageButton cancelBtn;
    protected OnSearchChangeListener searchChangeListener;

    public TiUISearchBar(final TiViewProxy proxy) {
        super(proxy, true);
        this.cancelBtn = new ImageButton(proxy.getContext());
        this.cancelBtn.isFocusable();
        this.cancelBtn.setId(101);
        this.cancelBtn.setImageResource(17301548);
        float scale = this.cancelBtn.getContext().getResources().getDisplayMetrics().density;
        this.cancelBtn.setMinimumWidth((int)(48.0f * scale));
        this.cancelBtn.setMinimumHeight((int)(20.0f * scale));
        this.cancelBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                try {
                    proxy.set(TiUISearchBar.this.getProxy().getTiContext().getScope(), "value", (Object)"");
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
                proxy.fireEvent("cancel", null);
            }
        });
        RelativeLayout layout = new RelativeLayout(proxy.getContext());
        layout.setGravity(0);
        layout.setPadding(0, 0, 0, 0);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        params.addRule(9);
        params.addRule(15);
        params.addRule(0, 101);
        layout.addView((View)this.tv, (ViewGroup.LayoutParams)params);
        params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(11);
        params.addRule(15);
        layout.addView((View)this.cancelBtn, (ViewGroup.LayoutParams)params);
        this.setNativeView((View)layout);
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.searchChangeListener != null) {
            this.searchChangeListener.filterBy(((Object)s).toString());
        }
        super.onTextChanged(s, start, before, count);
    }

    @Override
    public void processProperties(KrollDict d) {
        super.processProperties(d);
        if (d.containsKey((Object)"showCancel")) {
            boolean showCancel = TiConvert.toBoolean((KrollDict)d, (String)"showCancel");
            this.cancelBtn.setVisibility(showCancel ? 0 : 8);
        } else if (d.containsKey((Object)"barColor")) {
            this.nativeView.setBackgroundColor(TiConvert.toColor((KrollDict)d, (String)"barColor"));
        }
    }

    @Override
    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if (key.equals("showCancel")) {
            boolean showCancel = TiConvert.toBoolean((Object)newValue);
            this.cancelBtn.setVisibility(showCancel ? 0 : 8);
        } else if (key.equals("barColor")) {
            this.nativeView.setBackgroundColor(TiConvert.toColor((String)TiConvert.toString((Object)newValue)));
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
    }

    public void setOnSearchChangeListener(OnSearchChangeListener listener) {
        this.searchChangeListener = listener;
    }

    public static interface OnSearchChangeListener {
        public void filterBy(String var1);
    }
}

