/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.picker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.LinearLayout;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import kankan.wheel.widget.WheelView;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.widget.picker.FormatNumericWheelAdapter;
import ti.modules.titanium.ui.widget.picker.TextWheelAdapter;

public class TiUITimeSpinner
extends TiUIView
implements WheelView.OnItemSelectedListener {
    private WheelView hoursWheel;
    private WheelView minutesWheel;
    private WheelView amPmWheel;
    private boolean suppressChangeEvent = false;
    private boolean ignoreItemSelection = false;
    private static final String LCAT = "TiUITimeSpinner";
    private Calendar calendar = Calendar.getInstance();

    public TiUITimeSpinner(TiViewProxy proxy) {
        super(proxy);
    }

    public TiUITimeSpinner(TiViewProxy proxy, Activity activity) {
        this(proxy);
        this.createNativeView(activity);
    }

    private FormatNumericWheelAdapter makeHoursAdapter(boolean format24) {
        DecimalFormat formatter = new DecimalFormat("00");
        return new FormatNumericWheelAdapter(format24 ? 0 : 1, format24 ? 23 : 12, formatter, 6);
    }

    private WheelView makeAmPmWheel(Context context, int textSize) {
        ArrayList<Object> amPmRows = new ArrayList<Object>();
        amPmRows.add(" am ");
        amPmRows.add(" pm ");
        WheelView view = new WheelView(context);
        view.setAdapter(new TextWheelAdapter(amPmRows));
        view.setTextSize(textSize);
        view.setItemSelectedListener(this);
        return view;
    }

    private void createNativeView(Activity activity) {
        boolean format24 = true;
        if (this.proxy.hasProperty("format24")) {
            format24 = TiConvert.toBoolean((Object)this.proxy.getProperty("format24"));
        }
        int minuteInterval = 1;
        if (this.proxy.hasProperty("minuteInterval")) {
            int dirtyMinuteInterval = TiConvert.toInt((Object)this.proxy.getProperty("minuteInterval"));
            if (dirtyMinuteInterval > 0 && dirtyMinuteInterval <= 30 && 60 % dirtyMinuteInterval == 0) {
                minuteInterval = dirtyMinuteInterval;
            } else {
                Log.w((String)LCAT, (String)("Clearing invalid minuteInterval property value of " + dirtyMinuteInterval));
                this.proxy.setProperty("minuteInterval", null);
            }
        }
        DecimalFormat formatter = new DecimalFormat("00");
        FormatNumericWheelAdapter hours = this.makeHoursAdapter(format24);
        FormatNumericWheelAdapter minutes = new FormatNumericWheelAdapter(0, 59, formatter, 6, minuteInterval);
        this.hoursWheel = new WheelView((Context)activity);
        this.minutesWheel = new WheelView((Context)activity);
        this.hoursWheel.setTextSize(20);
        this.minutesWheel.setTextSize(this.hoursWheel.getTextSize());
        this.hoursWheel.setAdapter(hours);
        this.minutesWheel.setAdapter(minutes);
        this.hoursWheel.setItemSelectedListener(this);
        this.minutesWheel.setItemSelectedListener(this);
        this.amPmWheel = null;
        if (!format24) {
            this.amPmWheel = this.makeAmPmWheel((Context)activity, this.hoursWheel.getTextSize());
        }
        LinearLayout layout = new LinearLayout((Context)activity);
        layout.setOrientation(0);
        layout.addView((View)this.hoursWheel);
        layout.addView((View)this.minutesWheel);
        if (!format24) {
            layout.addView((View)this.amPmWheel);
        }
        this.setNativeView((View)layout);
    }

    public void processProperties(KrollDict d) {
        super.processProperties(d);
        boolean valueExistsInProxy = false;
        if (d.containsKey((Object)"value")) {
            this.calendar.setTime((Date)d.get((Object)"value"));
            valueExistsInProxy = true;
        }
        this.setValue(this.calendar.getTimeInMillis(), true);
        if (!valueExistsInProxy) {
            this.proxy.setProperty("value", (Object)this.calendar.getTime());
        }
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if (key.equals("value")) {
            Date date = (Date)newValue;
            this.setValue(date.getTime());
        } else if (key.equals("format24")) {
            boolean is24HourFormat = TiConvert.toBoolean((Object)newValue);
            this.ignoreItemSelection = true;
            this.suppressChangeEvent = true;
            this.hoursWheel.setAdapter(this.makeHoursAdapter(is24HourFormat));
            LinearLayout vg = (LinearLayout)this.nativeView;
            if (is24HourFormat && vg.indexOfChild((View)this.amPmWheel) >= 0) {
                vg.removeView((View)this.amPmWheel);
            } else if (!is24HourFormat && vg.getChildCount() < 3) {
                this.amPmWheel = this.makeAmPmWheel(this.hoursWheel.getContext(), this.hoursWheel.getTextSize());
                vg.addView((View)this.amPmWheel);
            }
            this.setValue(this.calendar.getTimeInMillis(), true);
            this.ignoreItemSelection = false;
            this.suppressChangeEvent = false;
        } else if (key.equals("minuteInterval")) {
            int interval = TiConvert.toInt((Object)newValue);
            if (interval > 0 && interval <= 30 && 60 % interval == 0) {
                FormatNumericWheelAdapter adapter = (FormatNumericWheelAdapter)this.minutesWheel.getAdapter();
                adapter.setStepValue(interval);
                this.minutesWheel.setAdapter(adapter);
            } else {
                Log.w((String)LCAT, (String)("Ignoring illegal minuteInterval value: " + interval));
                proxy.setProperty("minuteInterval", oldValue, false);
            }
        }
        super.propertyChanged(key, oldValue, newValue, proxy);
    }

    public void setValue(long value) {
        this.setValue(value, false);
    }

    public void setValue(long value, boolean suppressEvent) {
        boolean format24 = true;
        if (this.proxy.hasProperty("format24")) {
            format24 = TiConvert.toBoolean((Object)this.proxy.getProperty("format24"));
        }
        this.calendar.setTimeInMillis(value);
        this.suppressChangeEvent = true;
        this.ignoreItemSelection = true;
        if (!format24) {
            int hour = this.calendar.get(10);
            if (hour == 0) {
                this.hoursWheel.setCurrentItem(11);
            } else {
                this.hoursWheel.setCurrentItem(hour - 1);
            }
            if (this.calendar.get(11) <= 11) {
                this.amPmWheel.setCurrentItem(0);
            } else {
                this.amPmWheel.setCurrentItem(1);
            }
        } else {
            this.hoursWheel.setCurrentItem(this.calendar.get(11));
        }
        this.suppressChangeEvent = suppressEvent;
        this.ignoreItemSelection = false;
        this.minutesWheel.setCurrentItem(((FormatNumericWheelAdapter)this.minutesWheel.getAdapter()).getIndex(this.calendar.get(12)));
        this.suppressChangeEvent = false;
    }

    @Override
    public void onItemSelected(WheelView view, int index) {
        if (this.ignoreItemSelection) {
            return;
        }
        boolean format24 = true;
        if (this.proxy.hasProperty("format24")) {
            format24 = TiConvert.toBoolean((Object)this.proxy.getProperty("format24"));
        }
        this.calendar.set(12, ((FormatNumericWheelAdapter)this.minutesWheel.getAdapter()).getValue(this.minutesWheel.getCurrentItem()));
        if (!format24) {
            int hourOfDay = 0;
            hourOfDay = this.hoursWheel.getCurrentItem() == 11 ? (this.amPmWheel.getCurrentItem() == 0 ? 0 : 12) : 1 + 12 * this.amPmWheel.getCurrentItem() + this.hoursWheel.getCurrentItem();
            this.calendar.set(11, hourOfDay);
        } else {
            this.calendar.set(11, this.hoursWheel.getCurrentItem());
        }
        Date dateval = this.calendar.getTime();
        this.proxy.setProperty("value", (Object)dateval);
        if (!this.suppressChangeEvent) {
            KrollDict data = new KrollDict();
            data.put((Object)"value", (Object)dateval);
            this.proxy.fireEvent("change", data);
        }
    }
}

