/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.picker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.TimePicker;
import java.util.Calendar;
import java.util.Date;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiUIView;

public class TiUITimePicker
extends TiUIView
implements TimePicker.OnTimeChangedListener {
    private static final String LCAT = "TiUITimePicker";
    private static final boolean DBG = TiConfig.LOGD;
    private boolean suppressChangeEvent = false;
    protected Date minDate;
    protected Date maxDate;
    protected int minuteInterval;

    public TiUITimePicker(TiViewProxy proxy) {
        super(proxy);
    }

    public TiUITimePicker(TiViewProxy proxy, Activity activity) {
        this(proxy);
        if (DBG) {
            Log.d((String)LCAT, (String)"Creating a time picker");
        }
        TimePicker picker = new TimePicker((Context)activity);
        picker.setIs24HourView(Boolean.valueOf(false));
        picker.setOnTimeChangedListener((TimePicker.OnTimeChangedListener)this);
        this.setNativeView((View)picker);
    }

    public void processProperties(KrollDict d) {
        int mi;
        super.processProperties(d);
        boolean valueExistsInProxy = false;
        Calendar calendar = Calendar.getInstance();
        TimePicker picker = (TimePicker)this.getNativeView();
        if (d.containsKey((Object)"value")) {
            calendar.setTime((Date)d.get((Object)"value"));
            valueExistsInProxy = true;
        }
        if (d.containsKey((Object)"minDate")) {
            this.minDate = (Date)d.get((Object)"minDate");
        }
        if (d.containsKey((Object)"maxDate")) {
            this.maxDate = (Date)d.get((Object)"maxDate");
        }
        if (d.containsKey((Object)"minuteInterval") && (mi = d.getInt("minuteInterval").intValue()) >= 1 && mi <= 30 && mi % 60 == 0) {
            this.minuteInterval = mi;
        }
        boolean is24HourFormat = false;
        if (d.containsKey((Object)"format24")) {
            is24HourFormat = d.getBoolean("format24");
        }
        picker.setIs24HourView(Boolean.valueOf(is24HourFormat));
        this.setValue(calendar.getTimeInMillis(), true);
        if (!valueExistsInProxy) {
            this.proxy.setProperty("value", (Object)calendar.getTime());
        }
        if (this.minDate != null && this.maxDate != null && this.maxDate.compareTo(this.minDate) <= 0) {
            Log.w((String)LCAT, (String)"maxDate is less or equal minDate, ignoring both settings.");
            this.minDate = null;
            this.maxDate = null;
        }
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if (key.equals("value")) {
            Date date = (Date)newValue;
            this.setValue(date.getTime());
        } else if (key.equals("format24")) {
            ((TimePicker)this.getNativeView()).setIs24HourView(Boolean.valueOf(TiConvert.toBoolean((Object)newValue)));
        }
        super.propertyChanged(key, oldValue, newValue, proxy);
    }

    public void setValue(long value) {
        this.setValue(value, false);
    }

    public void setValue(long value, boolean suppressEvent) {
        TimePicker picker = (TimePicker)this.getNativeView();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(value);
        this.suppressChangeEvent = true;
        picker.setCurrentHour(Integer.valueOf(calendar.get(11)));
        this.suppressChangeEvent = suppressEvent;
        picker.setCurrentMinute(Integer.valueOf(calendar.get(12)));
        this.suppressChangeEvent = false;
    }

    public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, hourOfDay);
        calendar.set(12, minute);
        if (!this.suppressChangeEvent) {
            KrollDict data = new KrollDict();
            data.put((Object)"value", (Object)calendar.getTime());
            this.proxy.fireEvent("change", data);
        }
        this.proxy.setProperty("value", (Object)calendar.getTime());
    }
}

