/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.picker;

import android.content.Context;
import android.graphics.Typeface;
import java.util.ArrayList;
import kankan.wheel.widget.WheelView;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiUIHelper;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.PickerColumnProxy;
import ti.modules.titanium.ui.PickerProxy;
import ti.modules.titanium.ui.PickerRowProxy;
import ti.modules.titanium.ui.widget.picker.TextWheelAdapter;

public class TiUISpinnerColumn
extends TiUIView
implements WheelView.OnItemSelectedListener {
    private static final String LCAT = "TiUISpinnerColumn";
    private boolean suppressItemSelected = false;

    public TiUISpinnerColumn(TiViewProxy proxy) {
        super(proxy);
        this.refreshNativeView();
        this.preselectRow();
        ((WheelView)this.nativeView).setItemSelectedListener(this);
    }

    private void preselectRow() {
        if (this.proxy.getParent() instanceof PickerProxy) {
            Integer rowIndex;
            ArrayList<Integer> preselectedRows = ((PickerProxy)this.proxy.getParent()).getPreselectedRows();
            if (preselectedRows == null || preselectedRows.size() == 0) {
                return;
            }
            int columnIndex = ((PickerColumnProxy)this.proxy).getThisColumnIndex();
            if (columnIndex >= 0 && columnIndex < preselectedRows.size() && (rowIndex = preselectedRows.get(columnIndex)) != null && rowIndex >= 0) {
                this.selectRow(rowIndex);
            }
        }
    }

    public void processProperties(KrollDict d) {
        super.processProperties(d);
        if (d.containsKeyStartingWith("font")) {
            this.setFontProperties();
        }
        if (d.containsKey((Object)"color")) {
            ((WheelView)this.nativeView).setTextColor(new Integer(TiConvert.toColor((KrollDict)d, (String)"color")));
        }
        if (d.containsKey((Object)"visibleItems")) {
            ((WheelView)this.nativeView).setVisibleItems(TiConvert.toInt((KrollDict)d, (String)"visibleItems"));
        } else {
            ((WheelView)this.nativeView).setVisibleItems(5);
        }
        if (d.containsKey((Object)"selectionIndicator")) {
            ((WheelView)this.nativeView).setShowSelectionIndicator(TiConvert.toBoolean((KrollDict)d, (String)"selectionIndicator"));
        }
        this.refreshNativeView();
    }

    private void setFontProperties() {
        WheelView view = (WheelView)this.nativeView;
        String fontFamily = null;
        Float fontSize = null;
        String fontWeight = null;
        Typeface typeface = null;
        KrollDict d = this.proxy.getProperties();
        if (d.containsKey((Object)"font") && d.get((Object)"font") instanceof KrollDict) {
            KrollDict font = d.getKrollDict("font");
            if (font.containsKey((Object)"fontSize")) {
                String sFontSize = TiConvert.toString((KrollDict)font, (String)"fontSize");
                fontSize = new Float(TiUIHelper.getSize((String)sFontSize));
            }
            if (font.containsKey((Object)"fontFamily")) {
                fontFamily = TiConvert.toString((KrollDict)font, (String)"fontFamily");
            }
            if (font.containsKey((Object)"fontWeight")) {
                fontWeight = TiConvert.toString((KrollDict)font, (String)"fontWeight");
            }
        }
        if (d.containsKeyAndNotNull("font-family")) {
            fontFamily = TiConvert.toString((KrollDict)d, (String)"font-family");
        }
        if (d.containsKeyAndNotNull("font-size")) {
            String sFontSize = TiConvert.toString((KrollDict)d, (String)"font-size");
            fontSize = new Float(TiUIHelper.getSize((String)sFontSize));
        }
        if (d.containsKeyAndNotNull("font-weight")) {
            fontWeight = TiConvert.toString((KrollDict)d, (String)"font-weight");
        }
        if (fontFamily != null) {
            typeface = TiUIHelper.toTypeface((String)fontFamily);
        }
        Integer typefaceWeight = null;
        if (fontWeight != null) {
            typefaceWeight = new Integer(TiUIHelper.toTypefaceStyle((String)fontWeight));
        }
        boolean dirty = false;
        if (typeface != null) {
            dirty = dirty || !typeface.equals(view.getTypeface());
            view.setTypeface(typeface);
        }
        if (typefaceWeight != null) {
            dirty = dirty || typefaceWeight.intValue() != view.getTypefaceWeight();
            view.setTypefaceWeight(typefaceWeight);
        }
        if (fontSize != null) {
            int fontSizeInt = fontSize.intValue();
            dirty = dirty || fontSizeInt != view.getTextSize();
            view.setTextSize(fontSize.intValue());
        }
        if (dirty) {
            ((PickerColumnProxy)this.proxy).parentShouldRequestLayout();
        }
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if (key.startsWith("font")) {
            this.setFontProperties();
        } else if (key.equals("color")) {
            ((WheelView)this.nativeView).setTextColor(new Integer(TiConvert.toColor((String)TiConvert.toString((Object)newValue))));
        } else if (key.equals("visibleItems")) {
            ((WheelView)this.nativeView).setVisibleItems(TiConvert.toInt((Object)newValue));
        } else if (key.equals("selectionIndicator")) {
            ((WheelView)this.nativeView).setShowSelectionIndicator(TiConvert.toBoolean((Object)newValue));
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
    }

    public void refreshNativeView() {
        int rowCount;
        WheelView view = null;
        if (this.nativeView instanceof WheelView) {
            view = (WheelView)this.nativeView;
        } else {
            view = new WheelView(this.proxy.getContext());
            Float defaultFontSize = new Float(TiUIHelper.getSize((String)TiUIHelper.getDefaultFontSize((Context)this.proxy.getContext())));
            view.setTextSize(defaultFontSize.intValue());
            this.setNativeView(view);
        }
        int selectedRow = view.getCurrentItem();
        PickerRowProxy[] rows = ((PickerColumnProxy)this.proxy).getRows();
        int n = rowCount = rows == null ? 0 : rows.length;
        if (selectedRow >= rowCount) {
            this.suppressItemSelected = true;
            if (rowCount > 0) {
                view.setCurrentItem(rowCount - 1);
            } else {
                view.setCurrentItem(0);
            }
            this.suppressItemSelected = false;
        }
        TextWheelAdapter adapter = new TextWheelAdapter((Object[])rows);
        view.setAdapter(adapter);
    }

    public void selectRow(int rowIndex) {
        if (this.nativeView instanceof WheelView) {
            WheelView view = (WheelView)this.nativeView;
            if (rowIndex < 0 || rowIndex >= view.getAdapter().getItemsCount()) {
                Log.w((String)LCAT, (String)("Ignoring attempt to select out-of-bound row index " + rowIndex));
                return;
            }
            view.setCurrentItem(rowIndex);
        }
    }

    @Override
    public void onItemSelected(WheelView view, int index) {
        if (this.suppressItemSelected) {
            return;
        }
        ((PickerColumnProxy)this.proxy).onItemSelected(index);
    }

    public int getSelectedRowIndex() {
        int result = -1;
        if (this.nativeView instanceof WheelView) {
            result = ((WheelView)this.nativeView).getCurrentItem();
        }
        return result;
    }

    public void forceRequestLayout() {
        if (this.nativeView instanceof WheelView) {
            ((WheelView)this.nativeView).fullLayoutReset();
        }
    }
}

