/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.picker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiCompositeLayout;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.widget.picker.TiUIPicker;
import ti.modules.titanium.ui.widget.picker.TiUISpinnerColumn;

public class TiUISpinner
extends TiUIPicker {
    private static final String LCAT = "TiUISpinner";

    public TiUISpinner(TiViewProxy proxy) {
        super(proxy);
    }

    public TiUISpinner(TiViewProxy proxy, Activity activity) {
        this(proxy);
        TiCompositeLayout layout = new TiCompositeLayout((Context)activity, TiCompositeLayout.LayoutArrangement.HORIZONTAL);
        layout.setDisableHorizontalWrap(true);
        this.setNativeView((View)layout);
    }

    @Override
    protected void refreshNativeView() {
        if (this.children == null || this.children.size() == 0) {
            return;
        }
        for (TiUIView child : this.children) {
            this.refreshColumn((TiUISpinnerColumn)child);
        }
    }

    private void refreshColumn(int columnIndex) {
        if (columnIndex < 0 || this.children == null || this.children.size() == 0 || columnIndex > this.children.size() + 1) {
            return;
        }
        this.refreshColumn((TiUISpinnerColumn)this.children.get(columnIndex));
    }

    private void refreshColumn(TiUISpinnerColumn column) {
        if (column == null) {
            return;
        }
        column.refreshNativeView();
    }

    @Override
    public int getSelectedRowIndex(int columnIndex) {
        if (columnIndex < 0 || this.children == null || this.children.size() == 0 || columnIndex >= this.children.size()) {
            Log.w((String)LCAT, (String)("Ignoring effort to get selected row index for out-of-bounds columnIndex " + columnIndex));
            return -1;
        }
        TiUIView child = (TiUIView)this.children.get(columnIndex);
        if (child instanceof TiUISpinnerColumn) {
            return ((TiUISpinnerColumn)child).getSelectedRowIndex();
        }
        Log.w((String)LCAT, (String)("Could not locate column " + columnIndex + ".  Ignoring effort to get selected row index in that column."));
        return -1;
    }

    @Override
    public void selectRow(int columnIndex, int rowIndex, boolean animated) {
        if (this.children == null || columnIndex >= this.children.size()) {
            Log.w((String)LCAT, (String)("Column " + columnIndex + " does not exist.  Ignoring effort to select a row in that column."));
            return;
        }
        TiUIView child = (TiUIView)this.children.get(columnIndex);
        if (child instanceof TiUISpinnerColumn) {
            ((TiUISpinnerColumn)child).selectRow(rowIndex);
        } else {
            Log.w((String)LCAT, (String)("Could not locate column " + columnIndex + ".  Ignoring effort to select a row in that column."));
        }
    }

    @Override
    public void onColumnModelChanged(int columnIndex) {
        this.refreshColumn(columnIndex);
    }

    @Override
    public void onRowChanged(int columnIndex, int rowIndex) {
        this.refreshColumn(columnIndex);
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if ("visibleItems".equals(key) || "selectionIndicator".equals(key)) {
            this.propagateProperty(key, newValue);
            if ("visibleItems".equals(key)) {
                this.forceRequestLayout();
            }
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
    }

    private void propagateProperty(String key, Object value) {
        if (this.children != null && this.children.size() > 0) {
            for (TiUIView child : this.children) {
                if (!(child instanceof TiUISpinnerColumn)) continue;
                child.getProxy().setProperty(key, value, true);
            }
        }
    }

    public void processProperties(KrollDict d) {
        super.processProperties(d);
        if (d.containsKey((Object)"visibleItems")) {
            this.propagateProperty("visibleItems", TiConvert.toInt((KrollDict)d, (String)"visibleItems"));
        }
        if (d.containsKey((Object)"selectionIndicator")) {
            this.propagateProperty("selectionIndicator", TiConvert.toBoolean((KrollDict)d, (String)"selectionIndicator"));
        }
    }

    public void add(TiUIView child) {
        if (this.proxy.hasProperty("visibleItems")) {
            child.getProxy().setProperty("visibleItems", (Object)TiConvert.toInt((Object)this.proxy.getProperty("visibleItems")), true);
        }
        if (this.proxy.hasProperty("selectionIndicator")) {
            child.getProxy().setProperty("selectionIndicator", (Object)TiConvert.toBoolean((Object)this.proxy.getProperty("selectionIndicator")), true);
        }
        super.add(child);
    }

    public void forceRequestLayout() {
        if (this.children != null && this.children.size() > 0) {
            for (TiUIView child : this.children) {
                if (!(child instanceof TiUISpinnerColumn)) continue;
                ((TiUISpinnerColumn)child).forceRequestLayout();
            }
        }
        this.layoutNativeView();
    }
}

