/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.picker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.PickerColumnProxy;
import ti.modules.titanium.ui.PickerProxy;
import ti.modules.titanium.ui.widget.picker.TiUIPicker;

public class TiUINativePicker
extends TiUIPicker
implements AdapterView.OnItemSelectedListener {
    private static final String LCAT = "TiUINativePicker";
    private boolean firstSelectedFired = false;

    public TiUINativePicker(TiViewProxy proxy) {
        super(proxy);
    }

    public TiUINativePicker(TiViewProxy proxy, Activity activity) {
        this(proxy);
        Spinner spinner = new Spinner((Context)activity);
        this.setNativeView((View)spinner);
        this.refreshNativeView();
        this.preselectRows();
        spinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preselectRows() {
        ArrayList<Integer> preselectedRows = this.getPickerProxy().getPreselectedRows();
        if (preselectedRows == null || preselectedRows.size() == 0) {
            return;
        }
        Spinner spinner = (Spinner)this.nativeView;
        if (spinner == null) {
            return;
        }
        try {
            spinner.setOnItemSelectedListener(null);
            for (int i = 0; i < preselectedRows.size(); ++i) {
                Integer rowIndex = preselectedRows.get(i);
                if (rowIndex == 0 || rowIndex < 0) continue;
                this.selectRow(i, rowIndex, false);
            }
        }
        finally {
            spinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
            this.firstSelectedFired = true;
        }
    }

    @Override
    public void selectRow(int columnIndex, int rowIndex, boolean animated) {
        if (columnIndex != 0) {
            Log.w((String)LCAT, (String)("Only one column is supported. Ignoring request to set selected row of column " + columnIndex));
            return;
        }
        Spinner view = (Spinner)this.nativeView;
        int rowCount = view.getAdapter().getCount();
        if (rowIndex < 0 || rowIndex >= rowCount) {
            Log.w((String)LCAT, (String)("Ignoring request to select out-of-bounds row index " + rowIndex));
            return;
        }
        view.setSelection(rowIndex, animated);
    }

    @Override
    public int getSelectedRowIndex(int columnIndex) {
        if (columnIndex != 0) {
            Log.w((String)LCAT, (String)("Ignoring request to get selected row from out-of-bounds columnIndex " + columnIndex));
            return -1;
        }
        return ((Spinner)this.getNativeView()).getSelectedItemPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refreshNativeView() {
        this.suppressChangeEvent = true;
        Spinner spinner = (Spinner)this.nativeView;
        if (spinner == null) {
            return;
        }
        try {
            spinner.setOnItemSelectedListener(null);
            int rememberSelectedRow = this.getSelectedRowIndex(0);
            spinner.setAdapter((SpinnerAdapter)new ArrayAdapter(spinner.getContext(), 17367048, new ArrayList()));
            PickerColumnProxy column = this.getPickerProxy().getFirstColumn(false);
            if (column == null) {
                return;
            }
            TiViewProxy[] rowArray = column.getChildren();
            if (rowArray == null || rowArray.length == 0) {
                return;
            }
            ArrayList<TiViewProxy> rows = new ArrayList<TiViewProxy>(Arrays.asList(rowArray));
            ArrayAdapter adapter = new ArrayAdapter(spinner.getContext(), 17367048, rows);
            adapter.setDropDownViewResource(0x1090009);
            spinner.setAdapter((SpinnerAdapter)adapter);
            if (rememberSelectedRow >= 0) {
                this.selectRow(0, rememberSelectedRow, false);
            }
        }
        catch (Throwable t) {
            Log.e((String)LCAT, (String)("Unable to refresh native spinner control: " + t.getMessage()), (Throwable)t);
        }
        finally {
            this.suppressChangeEvent = false;
            spinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        }
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long itemId) {
        if (!this.firstSelectedFired) {
            this.firstSelectedFired = true;
            return;
        }
        this.fireSelectionChange(0, position);
    }

    public void onNothingSelected(AdapterView<?> arg0) {
    }

    public void add(TiUIView child) {
    }

    public void remove(TiUIView child) {
    }

    @Override
    public void onColumnAdded(int columnIndex) {
        if (!this.batchModelChange) {
            this.refreshNativeView();
        }
    }

    @Override
    public void onColumnRemoved(int oldColumnIndex) {
        if (!this.batchModelChange) {
            this.refreshNativeView();
        }
    }

    @Override
    public void onColumnModelChanged(int columnIndex) {
        if (!this.batchModelChange) {
            this.refreshNativeView();
        }
    }

    @Override
    public void onRowChanged(int columnIndex, int rowIndex) {
        if (!this.batchModelChange) {
            this.refreshNativeView();
        }
    }

    protected void fireSelectionChange(int columnIndex, int rowIndex) {
        ((PickerProxy)this.proxy).fireSelectionChange(columnIndex, rowIndex);
    }
}

