/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.picker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.LinearLayout;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kankan.wheel.widget.WheelView;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.widget.picker.FormatNumericWheelAdapter;

public class TiUIDateSpinner
extends TiUIView
implements WheelView.OnItemSelectedListener {
    private static final String LCAT = "TiUIDateSpinner";
    private WheelView monthWheel;
    private WheelView dayWheel;
    private WheelView yearWheel;
    private FormatNumericWheelAdapter monthAdapter;
    private FormatNumericWheelAdapter dayAdapter;
    private FormatNumericWheelAdapter yearAdapter;
    private boolean suppressChangeEvent = false;
    private boolean ignoreItemSelection = false;
    private Calendar maxDate = Calendar.getInstance();
    private Calendar minDate = Calendar.getInstance();
    private Locale locale = Locale.getDefault();
    private boolean dayBeforeMonth = false;
    private boolean numericMonths = false;
    private Calendar calendar = Calendar.getInstance();

    public TiUIDateSpinner(TiViewProxy proxy) {
        super(proxy);
    }

    public TiUIDateSpinner(TiViewProxy proxy, Activity activity) {
        this(proxy);
        this.createNativeView(activity);
    }

    private void createNativeView(Activity activity) {
        this.maxDate.set(this.calendar.get(1) + 100, 11, 31);
        this.minDate.set(this.calendar.get(1) - 100, 0, 1);
        this.monthWheel = new WheelView((Context)activity);
        this.dayWheel = new WheelView((Context)activity);
        this.yearWheel = new WheelView((Context)activity);
        this.monthWheel.setTextSize(20);
        this.dayWheel.setTextSize(this.monthWheel.getTextSize());
        this.yearWheel.setTextSize(this.monthWheel.getTextSize());
        this.monthWheel.setItemSelectedListener(this);
        this.dayWheel.setItemSelectedListener(this);
        this.yearWheel.setItemSelectedListener(this);
        LinearLayout layout = new LinearLayout((Context)activity);
        layout.setOrientation(0);
        if (this.proxy.hasProperty("dayBeforeMonth")) {
            this.dayBeforeMonth = TiConvert.toBoolean((KrollDict)this.proxy.getProperties(), (String)"dayBeforeMonth");
        }
        if (this.dayBeforeMonth) {
            layout.addView((View)this.dayWheel);
            layout.addView((View)this.monthWheel);
        } else {
            layout.addView((View)this.monthWheel);
            layout.addView((View)this.dayWheel);
        }
        layout.addView((View)this.yearWheel);
        this.setNativeView((View)layout);
    }

    public void processProperties(KrollDict d) {
        Calendar c;
        super.processProperties(d);
        boolean valueExistsInProxy = false;
        if (d.containsKey((Object)"value")) {
            this.calendar.setTime((Date)d.get((Object)"value"));
            valueExistsInProxy = true;
        }
        if (d.containsKey((Object)"minDate")) {
            c = Calendar.getInstance();
            this.minDate.setTime(TiConvert.toDate((KrollDict)d, (String)"minDate"));
            c.setTime(this.minDate.getTime());
        }
        if (d.containsKey((Object)"maxDate")) {
            c = Calendar.getInstance();
            this.maxDate.setTime(TiConvert.toDate((KrollDict)d, (String)"maxDate"));
            c.setTime(this.maxDate.getTime());
        }
        if (d.containsKey((Object)"locale")) {
            this.setLocale(TiConvert.toString((KrollDict)d, (String)"locale"));
        }
        if (d.containsKey((Object)"dayBeforeMonth")) {
            this.dayBeforeMonth = TiConvert.toBoolean((KrollDict)d, (String)"dayBeforeMonth");
        }
        if (d.containsKey((Object)"numericMonths")) {
            this.numericMonths = TiConvert.toBoolean((KrollDict)d, (String)"numericMonths");
        }
        if (this.maxDate.before(this.minDate)) {
            this.maxDate.setTime(this.minDate.getTime());
        }
        if (this.calendar.after(this.maxDate)) {
            this.calendar.setTime(this.maxDate.getTime());
        } else if (this.calendar.before(this.minDate)) {
            this.calendar.setTime(this.minDate.getTime());
        }
        this.setValue(this.calendar.getTimeInMillis(), true);
        if (!valueExistsInProxy) {
            this.proxy.setProperty("value", (Object)this.calendar.getTime());
        }
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if ("value".equals(key)) {
            Date date = (Date)newValue;
            this.setValue(date.getTime());
        } else if ("locale".equals(key)) {
            this.setLocale(TiConvert.toString((Object)newValue));
        }
        super.propertyChanged(key, oldValue, newValue, proxy);
    }

    private void setAdapters() {
        this.setYearAdapter();
        this.setMonthAdapter();
        this.setDayAdapter();
    }

    private void setYearAdapter() {
        int minYear = this.minDate.get(1);
        int maxYear = this.maxDate.get(1);
        if (this.yearAdapter != null && this.yearAdapter.getMinValue() == minYear && this.yearAdapter.getMaxValue() == maxYear) {
            return;
        }
        this.yearAdapter = new FormatNumericWheelAdapter(minYear, maxYear, new DecimalFormat("0000"), 4);
        this.ignoreItemSelection = true;
        this.yearWheel.setAdapter(this.yearAdapter);
        this.ignoreItemSelection = false;
    }

    private void setMonthAdapter() {
        this.setMonthAdapter(false);
    }

    private void setMonthAdapter(boolean forceUpdate) {
        int setMinMonth = 1;
        int setMaxMonth = 12;
        int currentMin = -1;
        int currentMax = -1;
        if (this.monthAdapter != null) {
            currentMin = this.monthAdapter.getMinValue();
            currentMax = this.monthAdapter.getMaxValue();
        }
        int maxYear = this.maxDate.get(1);
        int minYear = this.minDate.get(1);
        int selYear = this.getSelectedYear();
        if (selYear == maxYear) {
            setMaxMonth = this.maxDate.get(2) + 1;
        }
        if (selYear == minYear) {
            setMinMonth = this.minDate.get(2) + 1;
        }
        if (currentMin != setMinMonth || currentMax != setMaxMonth || forceUpdate) {
            NumberFormat format;
            int width = 4;
            if (this.numericMonths) {
                format = new DecimalFormat("00");
            } else {
                format = new MonthFormat(this.locale);
                width = ((MonthFormat)format).getLongestMonthName();
            }
            this.monthAdapter = new FormatNumericWheelAdapter(setMinMonth, setMaxMonth, format, width);
            this.ignoreItemSelection = true;
            this.monthWheel.setAdapter(this.monthAdapter);
            this.ignoreItemSelection = false;
        }
    }

    private void setDayAdapter() {
        int setMinDay = 1;
        int setMaxDay = this.calendar.getActualMaximum(5);
        int currentMin = -1;
        int currentMax = -1;
        if (this.dayAdapter != null) {
            currentMin = this.dayAdapter.getMinValue();
            currentMax = this.dayAdapter.getMaxValue();
        }
        int maxYear = this.maxDate.get(1);
        int minYear = this.minDate.get(1);
        int selYear = this.getSelectedYear();
        int maxMonth = this.maxDate.get(2) + 1;
        int minMonth = this.minDate.get(2) + 1;
        int selMonth = this.getSelectedMonth();
        if (selYear == maxYear && selMonth == maxMonth) {
            setMaxDay = this.maxDate.get(5);
        }
        if (selYear == minYear && selMonth == minMonth) {
            setMinDay = this.minDate.get(5);
        }
        if (currentMin != setMinDay || currentMax != setMaxDay) {
            this.dayAdapter = new FormatNumericWheelAdapter(setMinDay, setMaxDay, new DecimalFormat("00"), 4);
            this.ignoreItemSelection = true;
            this.dayWheel.setAdapter(this.dayAdapter);
            this.ignoreItemSelection = false;
        }
    }

    private void syncWheels() {
        this.ignoreItemSelection = true;
        this.yearWheel.setCurrentItem(this.yearAdapter.getIndex(this.calendar.get(1)));
        this.monthWheel.setCurrentItem(this.monthAdapter.getIndex(this.calendar.get(2) + 1));
        this.dayWheel.setCurrentItem(this.dayAdapter.getIndex(this.calendar.get(5)));
        this.ignoreItemSelection = false;
    }

    public void setValue(long value) {
        this.setValue(value, false);
    }

    public void setValue(long value, boolean suppressEvent) {
        Date oldVal = this.calendar.getTime();
        this.setCalendar(value);
        Date newVal = this.calendar.getTime();
        if (newVal.after(this.maxDate.getTime())) {
            newVal = this.maxDate.getTime();
            this.setCalendar(newVal);
        } else if (newVal.before(this.minDate.getTime())) {
            newVal = this.minDate.getTime();
            this.setCalendar(newVal);
        }
        boolean isChanged = !newVal.equals(oldVal);
        this.setAdapters();
        this.syncWheels();
        this.proxy.setProperty("value", (Object)newVal);
        if (isChanged && !suppressEvent && !this.suppressChangeEvent) {
            KrollDict data = new KrollDict();
            data.put((Object)"value", (Object)newVal);
            this.proxy.fireEvent("change", data);
        }
    }

    public void setValue(Date value, boolean suppressEvent) {
        long millis = value.getTime();
        this.setValue(millis, suppressEvent);
    }

    public void setValue(Date value) {
        this.setValue(value, false);
    }

    public void setValue() {
        this.setValue(this.getSelectedDate());
    }

    private void setLocale(String localeString) {
        Locale locale = Locale.getDefault();
        if (localeString != null && localeString.length() > 1) {
            String stripped = localeString.replaceAll("-", "").replaceAll("_", "");
            if (stripped.length() == 2) {
                locale = new Locale(stripped);
            } else if (stripped.length() >= 4) {
                String language = stripped.substring(0, 2);
                String country = stripped.substring(2, 4);
                locale = stripped.length() > 4 ? new Locale(language, country, stripped.substring(4)) : new Locale(language, country);
            } else {
                Log.w((String)LCAT, (String)("Locale string '" + localeString + "' not understood.  Using default locale."));
            }
        }
        if (!this.locale.equals(locale)) {
            this.locale = locale;
            this.setMonthAdapter(true);
            this.syncWheels();
        }
    }

    private void setCalendar(long millis) {
        this.calendar.setTimeInMillis(millis);
    }

    private void setCalendar(Date date) {
        this.calendar.setTime(date);
    }

    private int getSelectedYear() {
        return this.yearAdapter.getValue(this.yearWheel.getCurrentItem());
    }

    private int getSelectedMonth() {
        return this.monthAdapter.getValue(this.monthWheel.getCurrentItem());
    }

    private int getSelectedDay() {
        return this.dayAdapter.getValue(this.dayWheel.getCurrentItem());
    }

    private Date getSelectedDate() {
        int year = this.getSelectedYear();
        int month = this.getSelectedMonth() - 1;
        int day = this.getSelectedDay();
        Calendar c = Calendar.getInstance();
        c.set(year, month, day);
        return c.getTime();
    }

    @Override
    public void onItemSelected(WheelView view, int index) {
        if (this.ignoreItemSelection) {
            return;
        }
        this.setValue();
    }

    class MonthFormat
    extends NumberFormat {
        private static final long serialVersionUID = 1L;
        private DateFormatSymbols symbols = new DateFormatSymbols(Locale.getDefault());

        public MonthFormat(Locale locale) {
            this.setLocale(locale);
        }

        @Override
        public StringBuffer format(double value, StringBuffer buffer, FieldPosition position) {
            return this.format((long)value, buffer, position);
        }

        @Override
        public StringBuffer format(long value, StringBuffer buffer, FieldPosition position) {
            buffer.append(this.symbols.getMonths()[(int)value - 1]);
            return buffer;
        }

        @Override
        public Number parse(String value, ParsePosition position) {
            String[] months = this.symbols.getMonths();
            for (int i = 0; i < months.length; ++i) {
                if (!months[i].equals(value)) continue;
                return new Long(i + 1);
            }
            return null;
        }

        public void setLocale(Locale locale) {
            this.symbols = new DateFormatSymbols(locale);
        }

        public int getLongestMonthName() {
            int max = 0;
            for (String month : this.symbols.getMonths()) {
                max = month.length() > max ? month.length() : max;
            }
            return max;
        }
    }
}

