/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget.picker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.DatePicker;
import java.util.Calendar;
import java.util.Date;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.view.TiUIView;

public class TiUIDatePicker
extends TiUIView
implements DatePicker.OnDateChangedListener {
    private boolean suppressChangeEvent = false;
    private static final String LCAT = "TiUIDatePicker";
    private static final boolean DBG = TiConfig.LOGD;
    protected Date minDate;
    protected Date maxDate;
    protected int minuteInterval;

    public TiUIDatePicker(TiViewProxy proxy) {
        super(proxy);
    }

    public TiUIDatePicker(TiViewProxy proxy, Activity activity) {
        this(proxy);
        if (DBG) {
            Log.d((String)LCAT, (String)"Creating a date picker");
        }
        DatePicker picker = new DatePicker((Context)activity);
        this.setNativeView((View)picker);
    }

    public void processProperties(KrollDict d) {
        int mi;
        super.processProperties(d);
        boolean valueExistsInProxy = false;
        Calendar calendar = Calendar.getInstance();
        DatePicker picker = (DatePicker)this.getNativeView();
        if (d.containsKey((Object)"value")) {
            calendar.setTime((Date)d.get((Object)"value"));
            valueExistsInProxy = true;
        }
        if (d.containsKey((Object)"minDate")) {
            Calendar minDateCalendar = Calendar.getInstance();
            minDateCalendar.setTime((Date)d.get((Object)"minDate"));
            minDateCalendar.set(11, 0);
            minDateCalendar.set(12, 0);
            minDateCalendar.set(13, 0);
            minDateCalendar.set(14, 0);
            this.minDate = minDateCalendar.getTime();
        }
        if (d.containsKey((Object)"maxDate")) {
            Calendar maxDateCalendar = Calendar.getInstance();
            maxDateCalendar.setTime((Date)d.get((Object)"maxDate"));
            maxDateCalendar.set(11, 0);
            maxDateCalendar.set(12, 0);
            maxDateCalendar.set(13, 0);
            maxDateCalendar.set(14, 0);
            this.maxDate = maxDateCalendar.getTime();
        }
        if (d.containsKey((Object)"minuteInterval") && (mi = d.getInt("minuteInterval").intValue()) >= 1 && mi <= 30 && mi % 60 == 0) {
            this.minuteInterval = mi;
        }
        this.suppressChangeEvent = true;
        picker.init(calendar.get(1), calendar.get(2), calendar.get(5), (DatePicker.OnDateChangedListener)this);
        this.suppressChangeEvent = false;
        if (!valueExistsInProxy) {
            this.proxy.setProperty("value", (Object)calendar.getTime());
        }
        if (this.minDate != null && this.maxDate != null && this.maxDate.compareTo(this.minDate) <= 0) {
            Log.w((String)LCAT, (String)"maxDate is less or equal minDate, ignoring both settings.");
            this.minDate = null;
            this.maxDate = null;
        }
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if (key.equals("value")) {
            Date date = (Date)newValue;
            this.setValue(date.getTime());
        }
        super.propertyChanged(key, oldValue, newValue, proxy);
    }

    public void onDateChanged(DatePicker picker, int year, int monthOfYear, int dayOfMonth) {
        Calendar targetCalendar = Calendar.getInstance();
        targetCalendar.set(1, year);
        targetCalendar.set(2, monthOfYear);
        targetCalendar.set(5, dayOfMonth);
        targetCalendar.set(11, 0);
        targetCalendar.set(12, 0);
        targetCalendar.set(13, 0);
        targetCalendar.set(14, 0);
        if (null != this.minDate && targetCalendar.getTime().before(this.minDate)) {
            targetCalendar.setTime(this.minDate);
            this.setValue(this.minDate.getTime(), true);
        }
        if (null != this.maxDate && targetCalendar.getTime().after(this.maxDate)) {
            targetCalendar.setTime(this.maxDate);
            this.setValue(this.maxDate.getTime(), true);
        }
        if (!this.suppressChangeEvent) {
            KrollDict data = new KrollDict();
            data.put((Object)"value", (Object)targetCalendar.getTime());
            this.proxy.fireEvent("change", data);
        }
        this.proxy.setProperty("value", (Object)targetCalendar.getTime());
    }

    public void setValue(long value) {
        this.setValue(value, false);
    }

    public void setValue(long value, boolean suppressEvent) {
        DatePicker picker = (DatePicker)this.getNativeView();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(value);
        this.suppressChangeEvent = suppressEvent;
        picker.updateDate(calendar.get(1), calendar.get(2), calendar.get(5));
        this.suppressChangeEvent = false;
    }
}

