/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.graphics.Rect;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.DialerKeyListener;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.text.method.NumberKeyListener;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiUIHelper;
import org.appcelerator.titanium.view.TiUIView;

public class TiUIText
extends TiUIView
implements TextWatcher,
TextView.OnEditorActionListener,
View.OnFocusChangeListener {
    private static final String LCAT = "TiUIText";
    private static final boolean DBG = TiConfig.LOGD;
    public static final int RETURNKEY_GO = 0;
    public static final int RETURNKEY_GOOGLE = 1;
    public static final int RETURNKEY_JOIN = 2;
    public static final int RETURNKEY_NEXT = 3;
    public static final int RETURNKEY_ROUTE = 4;
    public static final int RETURNKEY_SEARCH = 5;
    public static final int RETURNKEY_YAHOO = 6;
    public static final int RETURNKEY_DONE = 7;
    public static final int RETURNKEY_EMERGENCY_CALL = 8;
    public static final int RETURNKEY_DEFAULT = 9;
    public static final int RETURNKEY_SEND = 10;
    private static final int KEYBOARD_ASCII = 0;
    private static final int KEYBOARD_NUMBERS_PUNCTUATION = 1;
    private static final int KEYBOARD_URL = 2;
    private static final int KEYBOARD_NUMBER_PAD = 3;
    private static final int KEYBOARD_PHONE_PAD = 4;
    private static final int KEYBOARD_EMAIL_ADDRESS = 5;
    private static final int KEYBOARD_NAMEPHONE_PAD = 6;
    private static final int KEYBOARD_DEFAULT = 7;
    private static final int KEYBOARD_DECIMAL_PAD = 8;
    private static final int TEXT_AUTOCAPITALIZATION_NONE = 0;
    private static final int TEXT_AUTOCAPITALIZATION_SENTENCES = 1;
    private static final int TEXT_AUTOCAPITALIZATION_WORDS = 2;
    private static final int TEXT_AUTOCAPITALIZATION_ALL = 3;
    private boolean field;
    protected EditText tv;

    public TiUIText(TiViewProxy proxy, boolean field) {
        super(proxy);
        if (DBG) {
            Log.d((String)LCAT, (String)"Creating a text field");
        }
        this.field = field;
        this.tv = new EditText(this.getProxy().getContext());
        if (field) {
            this.tv.setSingleLine();
            this.tv.setMaxLines(1);
        }
        this.tv.addTextChangedListener((TextWatcher)this);
        this.tv.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.tv.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.tv.setIncludeFontPadding(true);
        if (field) {
            this.tv.setGravity(19);
        } else {
            this.tv.setGravity(51);
        }
        this.setNativeView((View)this.tv);
    }

    public void processProperties(KrollDict d) {
        super.processProperties(d);
        if (d.containsKey((Object)"enabled")) {
            this.tv.setEnabled(d.getBoolean("enabled"));
        }
        if (d.containsKey((Object)"value")) {
            this.tv.setText((CharSequence)d.getString("value"));
        }
        if (d.containsKey((Object)"color")) {
            this.tv.setTextColor(TiConvert.toColor((KrollDict)d, (String)"color"));
        }
        if (d.containsKey((Object)"hintText")) {
            this.tv.setHint((CharSequence)d.getString("hintText"));
        }
        if (d.containsKey((Object)"ellipsize")) {
            if (TiConvert.toBoolean((KrollDict)d, (String)"ellipsize")) {
                this.tv.setEllipsize(TextUtils.TruncateAt.END);
            } else {
                this.tv.setEllipsize(null);
            }
        }
        if (d.containsKey((Object)"font")) {
            TiUIHelper.styleText((TextView)this.tv, (KrollDict)d.getKrollDict("font"));
        }
        if (d.containsKey((Object)"textAlign") || d.containsKey((Object)"verticalAlign")) {
            String textAlign = null;
            String verticalAlign = null;
            if (d.containsKey((Object)"textAlign")) {
                textAlign = d.getString("textAlign");
            }
            if (d.containsKey((Object)"verticalAlign")) {
                verticalAlign = d.getString("verticalAlign");
            }
            this.handleTextAlign(textAlign, verticalAlign);
        }
        if (d.containsKey((Object)"returnKeyType")) {
            this.handleReturnKeyType(d.getInt("returnKeyType"));
        }
        if (d.containsKey((Object)"keyboardType") || d.containsKey((Object)"autocorrect") || d.containsKey((Object)"passwordMask") || d.containsKey((Object)"autocapitalization") || d.containsKey((Object)"editable")) {
            this.handleKeyboard(d);
        }
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if (DBG) {
            Log.d((String)LCAT, (String)("Property: " + key + " old: " + oldValue + " new: " + newValue));
        }
        if (key.equals("enabled")) {
            this.tv.setEnabled(TiConvert.toBoolean((Object)newValue));
        } else if (key.equals("value")) {
            this.tv.setText((CharSequence)((String)newValue));
        } else if (key.equals("color")) {
            this.tv.setTextColor(TiConvert.toColor((String)((String)newValue)));
        } else if (key.equals("hintText")) {
            this.tv.setHint((CharSequence)((String)newValue));
        } else if (key.equals("ellipsize")) {
            if (TiConvert.toBoolean((Object)newValue)) {
                this.tv.setEllipsize(TextUtils.TruncateAt.END);
            } else {
                this.tv.setEllipsize(null);
            }
        } else if (key.equals("textAlign") || key.equals("verticalAlign")) {
            String textAlign = null;
            String verticalAlign = null;
            if (key.equals("textAlign")) {
                textAlign = TiConvert.toString((Object)newValue);
            } else if (proxy.hasProperty("textAlign")) {
                textAlign = TiConvert.toString((Object)proxy.getProperty("textAlign"));
            }
            if (key.equals("verticalAlign")) {
                verticalAlign = TiConvert.toString((Object)newValue);
            } else if (proxy.hasProperty("verticalAlign")) {
                verticalAlign = TiConvert.toString((Object)proxy.getProperty("verticalAlign"));
            }
            this.handleTextAlign(textAlign, verticalAlign);
        } else if (key.equals("keyboardType") || key.equals("autocorrect") || key.equals("autocapitalization") || key.equals("passwordMask") || key.equals("editable")) {
            KrollDict d = proxy.getProperties();
            this.handleKeyboard(d);
        } else if (key.equals("returnKeyType")) {
            this.handleReturnKeyType(TiConvert.toInt((Object)newValue));
        } else if (key.equals("font")) {
            TiUIHelper.styleText((TextView)this.tv, (KrollDict)((KrollDict)newValue));
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
    }

    public void afterTextChanged(Editable tv) {
    }

    public void beforeTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        String value = this.tv.getText().toString();
        KrollDict data = new KrollDict();
        data.put((Object)"value", (Object)value);
        this.proxy.setProperty("value", (Object)value);
        this.proxy.fireEvent("change", data);
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (hasFocus) {
            Boolean clearOnEdit = (Boolean)this.proxy.getProperty("clearOnEdit");
            if (clearOnEdit != null && clearOnEdit.booleanValue()) {
                ((EditText)this.nativeView).setText((CharSequence)"");
            }
            Rect r = new Rect();
            this.nativeView.getFocusedRect(r);
            this.nativeView.requestRectangleOnScreen(r);
        }
        super.onFocusChange(v, hasFocus);
    }

    protected KrollDict getFocusEventObject(boolean hasFocus) {
        KrollDict event = new KrollDict();
        event.put((Object)"value", (Object)this.tv.getText().toString());
        return event;
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent keyEvent) {
        Boolean enableReturnKey;
        String value = this.tv.getText().toString();
        KrollDict data = new KrollDict();
        data.put((Object)"value", (Object)value);
        this.proxy.setProperty("value", (Object)value);
        if (DBG) {
            Log.d((String)LCAT, (String)("ActionID: " + actionId + " KeyEvent: " + (keyEvent != null ? Integer.valueOf(keyEvent.getKeyCode()) : null)));
        }
        if (actionId != 2 && actionId != 4) {
            this.proxy.fireEvent("return", data);
        }
        return (enableReturnKey = (Boolean)this.proxy.getProperty("enableReturnKey")) != null && enableReturnKey != false && v.getText().length() == 0;
    }

    public void handleTextAlign(String textAlign, String verticalAlign) {
        if (verticalAlign == null) {
            String string = verticalAlign = this.field ? "middle" : "top";
        }
        if (textAlign == null) {
            textAlign = "left";
        }
        TiUIHelper.setAlignment((TextView)this.tv, (String)textAlign, (String)verticalAlign);
    }

    public void handleKeyboard(KrollDict d) {
        int typeModifiers;
        int type = 0;
        boolean passwordMask = false;
        boolean editable = true;
        int autocorrect = 32768;
        int autoCapValue = 0;
        if (d.containsKey((Object)"autocorrect")) {
            autocorrect = TiConvert.toBoolean((KrollDict)d, (String)"autocorrect") ? 32768 : 524288;
        }
        if (d.containsKey((Object)"editable")) {
            editable = TiConvert.toBoolean((KrollDict)d, (String)"editable");
        }
        if (d.containsKey((Object)"autocapitalization")) {
            switch (TiConvert.toInt((KrollDict)d, (String)"autocapitalization")) {
                case 0: {
                    autoCapValue = 0;
                    break;
                }
                case 3: {
                    autoCapValue = 28672;
                    break;
                }
                case 1: {
                    autoCapValue = 16384;
                    break;
                }
                case 2: {
                    autoCapValue = 8192;
                    break;
                }
                default: {
                    Log.w((String)LCAT, (String)("Unknown AutoCapitalization Value [" + d.getString("autocapitalization") + "]"));
                }
            }
        }
        if (d.containsKey((Object)"passwordMask")) {
            passwordMask = TiConvert.toBoolean((KrollDict)d, (String)"passwordMask");
        }
        if (d.containsKey((Object)"keyboardType")) {
            type = TiConvert.toInt((KrollDict)d, (String)"keyboardType");
        }
        int textTypeAndClass = typeModifiers = autocorrect | autoCapValue;
        if (autocorrect != 524288) {
            textTypeAndClass |= 1;
        }
        this.tv.setCursorVisible(true);
        switch (type) {
            case 0: 
            case 7: {
                break;
            }
            case 1: {
                textTypeAndClass |= 2;
                this.tv.setKeyListener((KeyListener)new NumberKeyListener(){

                    public int getInputType() {
                        return 2;
                    }

                    protected char[] getAcceptedChars() {
                        return new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', '-', '+', '_', '*', '-', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '=', '{', '}', '[', ']', '|', '\\', '<', '>', ',', '?', '/', ':', ';', '\'', '\"', '~'};
                    }
                });
                break;
            }
            case 2: {
                if (DBG) {
                    Log.d((String)LCAT, (String)"Setting keyboard type URL-3");
                }
                this.tv.setImeOptions(2);
                textTypeAndClass |= 0x10;
                break;
            }
            case 3: 
            case 8: {
                this.tv.setKeyListener((KeyListener)DigitsKeyListener.getInstance((boolean)true, (boolean)true));
                textTypeAndClass |= 2;
                break;
            }
            case 4: {
                this.tv.setKeyListener((KeyListener)DialerKeyListener.getInstance());
                textTypeAndClass |= 3;
                break;
            }
            case 5: {
                textTypeAndClass |= 0x20;
            }
        }
        if (passwordMask) {
            this.tv.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
            textTypeAndClass |= 0x80;
        } else if (this.tv.getTransformationMethod() instanceof PasswordTransformationMethod) {
            this.tv.setTransformationMethod(null);
        }
        this.tv.setInputType(textTypeAndClass);
        if (!editable) {
            this.tv.setKeyListener(null);
            this.tv.setCursorVisible(false);
        }
        if (!this.field) {
            this.tv.setSingleLine(false);
        }
    }

    public void handleReturnKeyType(int type) {
        switch (type) {
            case 0: {
                this.tv.setImeOptions(2);
                break;
            }
            case 1: {
                this.tv.setImeOptions(2);
                break;
            }
            case 2: {
                this.tv.setImeOptions(6);
                break;
            }
            case 3: {
                this.tv.setImeOptions(5);
                break;
            }
            case 4: {
                this.tv.setImeOptions(6);
                break;
            }
            case 5: {
                this.tv.setImeOptions(3);
                break;
            }
            case 6: {
                this.tv.setImeOptions(2);
                break;
            }
            case 7: {
                this.tv.setImeOptions(6);
                break;
            }
            case 8: {
                this.tv.setImeOptions(2);
                break;
            }
            case 9: {
                this.tv.setImeOptions(0);
                break;
            }
            case 10: {
                this.tv.setImeOptions(4);
            }
        }
    }
}

