/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;
import android.widget.RelativeLayout;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiDimension;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.TableViewProxy;
import ti.modules.titanium.ui.widget.searchbar.TiUISearchBar;
import ti.modules.titanium.ui.widget.tableview.TableViewModel;
import ti.modules.titanium.ui.widget.tableview.TiTableView;

public class TiUITableView
extends TiUIView
implements TiTableView.OnItemClickedListener,
TiContext.OnLifecycleEvent {
    private static final String LCAT = "TitaniumTableView";
    private static final boolean DBG = TiConfig.LOGD;
    protected TiTableView tableView;

    public TiUITableView(TiViewProxy proxy) {
        super(proxy);
        this.getLayoutParams().autoFillsHeight = true;
        this.getLayoutParams().autoFillsWidth = true;
    }

    @Override
    public void onClick(KrollDict data) {
        this.proxy.fireEvent("click", data);
    }

    public void setModelDirty() {
        this.tableView.getTableViewModel().setDirty();
    }

    public TableViewModel getModel() {
        return this.tableView.getTableViewModel();
    }

    public void updateView() {
        this.tableView.dataSetChanged();
    }

    public void scrollToIndex(int index) {
        this.tableView.getListView().setSelection(index);
    }

    public void scrollToTop(int index) {
        this.tableView.getListView().setSelectionFromTop(index, 0);
    }

    public TiTableView getTableView() {
        return this.tableView;
    }

    public ListView getListView() {
        return this.tableView.getListView();
    }

    public void processProperties(KrollDict d) {
        this.tableView = new TiTableView(this.proxy.getTiContext(), (TableViewProxy)this.proxy);
        this.proxy.getTiContext().addOnLifecycleEventListener((TiContext.OnLifecycleEvent)this);
        this.tableView.setOnItemClickListener(this);
        if (d.containsKey((Object)"search")) {
            RelativeLayout layout = new RelativeLayout((Context)this.proxy.getTiContext().getActivity());
            layout.setGravity(0);
            layout.setPadding(0, 0, 0, 0);
            TiViewProxy searchView = (TiViewProxy)d.get((Object)"search");
            TiUISearchBar searchBar = (TiUISearchBar)searchView.getView(this.proxy.getTiContext().getActivity());
            searchBar.setOnSearchChangeListener(this.tableView);
            searchBar.getNativeView().setId(102);
            RelativeLayout.LayoutParams p = new RelativeLayout.LayoutParams(-1, -1);
            p.addRule(10);
            p.addRule(9);
            p.addRule(11);
            TiDimension rawHeight = searchView.hasProperty("height") ? TiConvert.toTiDimension((Object)searchView.getProperty("height"), (int)0) : TiConvert.toTiDimension((String)"52dp", (int)0);
            p.height = rawHeight.getAsPixels((View)layout);
            layout.addView(searchBar.getNativeView(), (ViewGroup.LayoutParams)p);
            p = new RelativeLayout.LayoutParams(-1, -1);
            p.addRule(9);
            p.addRule(12);
            p.addRule(11);
            p.addRule(3, 102);
            layout.addView((View)this.tableView, (ViewGroup.LayoutParams)p);
            this.setNativeView((View)layout);
        } else {
            this.setNativeView((View)this.tableView);
        }
        if (d.containsKey((Object)"filterAttribute")) {
            this.tableView.setFilterAttribute(TiConvert.toString((KrollDict)d, (String)"filterAttribute"));
        } else {
            this.proxy.setProperty("filterAttribute", (Object)"title", false);
            this.tableView.setFilterAttribute("title");
        }
        boolean filterCaseInsensitive = true;
        if (d.containsKey((Object)"filterCaseInsensitive")) {
            filterCaseInsensitive = TiConvert.toBoolean((KrollDict)d, (String)"filterCaseInsensitive");
        }
        this.tableView.setFilterCaseInsensitive(filterCaseInsensitive);
        super.processProperties(d);
    }

    public void onResume(Activity activity) {
        if (this.tableView != null) {
            this.tableView.dataSetChanged();
        }
    }

    public void onStop(Activity activity) {
    }

    public void onStart(Activity activity) {
    }

    public void onPause(Activity activity) {
    }

    public void onDestroy(Activity activity) {
    }

    public void release() {
        if (this.tableView != null) {
            this.tableView.release();
            this.tableView = null;
        }
        if (this.proxy != null && this.proxy.getTiContext() != null) {
            this.proxy.getTiContext().removeOnLifecycleEventListener((TiContext.OnLifecycleEvent)this);
        }
        this.nativeView = null;
        super.release();
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if (DBG) {
            Log.d((String)LCAT, (String)("Property: " + key + " old: " + oldValue + " new: " + newValue));
        }
        if (key.equals("separatorColor")) {
            this.tableView.setSeparatorColor(TiConvert.toString((Object)newValue));
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
    }
}

