/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.TabHost;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.TabGroupProxy;
import ti.modules.titanium.ui.TabProxy;
import ti.modules.titanium.ui.TiTabActivity;

public class TiUITabGroup
extends TiUIView
implements TabHost.OnTabChangeListener {
    private static final String LCAT = "TiUITabGroup";
    private static final boolean DBG = TiConfig.LOGD;
    private TabHost tabHost;
    private boolean addingTab;
    private String lastTabId;
    private KrollDict tabChangeEventData;

    public TiUITabGroup(TiViewProxy proxy, TiTabActivity activity) {
        super(proxy);
        this.tabHost = activity.getTabHost();
        this.tabHost.setVisibility(8);
        this.tabHost.clearAllTabs();
        this.tabHost.setOnTabChangedListener((TabHost.OnTabChangeListener)this);
        this.tabHost.setup(activity.getLocalActivityManager());
        if (proxy.hasProperty("backgroundColor")) {
            this.tabHost.setBackgroundColor(TiConvert.toColor((KrollDict)proxy.getProperties(), (String)"backgroundColor"));
        } else {
            this.tabHost.setBackgroundDrawable((Drawable)new ColorDrawable(TiConvert.toColor((String)"#ff1a1a1a")));
        }
        this.setNativeView((View)this.tabHost);
        this.lastTabId = null;
    }

    public TabHost.TabSpec newTab(String id) {
        return this.tabHost.newTabSpec(id);
    }

    public void addTab(TabHost.TabSpec tab) {
        this.addingTab = true;
        this.tabHost.addTab(tab);
        this.addingTab = false;
        if (this.tabHost.getVisibility() == 8) {
            boolean visibilityPerProxy = true;
            if (this.proxy.hasProperty("visible")) {
                visibilityPerProxy = TiConvert.toBoolean((Object)this.proxy.getProperty("visible"));
            }
            if (visibilityPerProxy) {
                this.tabHost.setVisibility(0);
            } else {
                this.tabHost.setVisibility(4);
            }
        }
    }

    public void setActiveTab(int index) {
        if (this.tabHost != null) {
            this.tabHost.setCurrentTab(index);
        }
    }

    protected KrollDict getFocusEventObject(boolean hasFocus) {
        if (this.tabChangeEventData == null) {
            TabHost th = (TabHost)this.getNativeView();
            return ((TabGroupProxy)this.proxy).buildFocusEvent(th.getCurrentTabTag(), this.lastTabId);
        }
        return this.tabChangeEventData;
    }

    public void onFocusChange(View v, boolean hasFocus) {
    }

    public void onTabChanged(String id) {
        TabGroupProxy tabGroupProxy = (TabGroupProxy)this.proxy;
        if (DBG) {
            Log.d((String)LCAT, (String)("Tab change from " + this.lastTabId + " to " + id));
        }
        this.proxy.setProperty("activeTab", (Object)tabGroupProxy.getTabList().get(this.tabHost.getCurrentTab()));
        if (!this.addingTab) {
            if (this.tabChangeEventData != null) {
                this.proxy.fireEvent("blur", this.tabChangeEventData);
            }
            this.tabChangeEventData = tabGroupProxy.buildFocusEvent(id, this.lastTabId);
            this.proxy.fireEvent("focus", this.tabChangeEventData);
        }
        this.lastTabId = id;
    }

    public void changeActiveTab(Object t) {
        if (t != null) {
            Integer index = null;
            if (t instanceof Number) {
                index = TiConvert.toInt((Object)t);
                int len = this.tabHost.getTabWidget().getTabCount();
                if (index >= len) {
                    Log.w((String)LCAT, (String)("Index out of bounds. Attempt to set active tab to " + index + ". There are " + len + " tabs."));
                    index = null;
                } else {
                    this.tabHost.setCurrentTab(index.intValue());
                }
            } else if (t instanceof TabProxy) {
                TabProxy tab = (TabProxy)((Object)t);
                String tag = TiConvert.toString((Object)tab.getProperty("tag"));
                if (tag != null) {
                    this.tabHost.setCurrentTabByTag(tag);
                }
            } else {
                Log.w((String)LCAT, (String)"Attempt to set active tab using a non-supported argument. Ignoring");
            }
        }
    }

    public int getActiveTab() {
        if (this.tabHost != null) {
            return this.tabHost.getCurrentTab();
        }
        return -1;
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if ("activeTab".equals(key)) {
            this.changeActiveTab(newValue);
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
    }
}

