/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;
import android.widget.ToggleButton;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiUIHelper;
import org.appcelerator.titanium.view.TiUIView;

public class TiUISwitch
extends TiUIView
implements CompoundButton.OnCheckedChangeListener {
    private static final String LCAT = "TiUISwitch";
    private static final boolean DBG = TiConfig.LOGD;

    public TiUISwitch(TiViewProxy proxy) {
        super(proxy);
        if (DBG) {
            Log.d((String)LCAT, (String)"Creating a switch");
        }
        this.propertyChanged("style", null, proxy.getProperty("style"), (KrollProxy)proxy);
    }

    public void processProperties(KrollDict d) {
        super.processProperties(d);
        if (d.containsKey((Object)"style")) {
            this.setStyle(TiConvert.toInt((KrollDict)d, (String)"style"));
        }
    }

    protected void updateButton(CompoundButton cb, KrollDict d) {
        if (d.containsKey((Object)"title") && cb.getClass().equals(CheckBox.class)) {
            cb.setText((CharSequence)TiConvert.toString((KrollDict)d, (String)"title"));
        }
        if (d.containsKey((Object)"titleOff") && cb.getClass().equals(ToggleButton.class)) {
            ((ToggleButton)cb).setTextOff((CharSequence)TiConvert.toString((KrollDict)d, (String)"titleOff"));
        }
        if (d.containsKey((Object)"titleOn") && cb.getClass().equals(ToggleButton.class)) {
            ((ToggleButton)cb).setTextOn((CharSequence)TiConvert.toString((KrollDict)d, (String)"titleOn"));
        }
        if (d.containsKey((Object)"value")) {
            cb.setChecked(TiConvert.toBoolean((KrollDict)d, (String)"value"));
        }
        if (d.containsKey((Object)"color")) {
            cb.setTextColor(TiConvert.toColor((KrollDict)d, (String)"color"));
        }
        if (d.containsKey((Object)"font")) {
            TiUIHelper.styleText((TextView)cb, (KrollDict)d.getKrollDict("font"));
        }
        if (d.containsKey((Object)"textAlign")) {
            String textAlign = d.getString("textAlign");
            TiUIHelper.setAlignment((TextView)cb, (String)textAlign, null);
        }
        if (d.containsKey((Object)"verticalAlign")) {
            String verticalAlign = d.getString("verticalAlign");
            TiUIHelper.setAlignment((TextView)cb, null, (String)verticalAlign);
        }
        cb.invalidate();
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if (DBG) {
            Log.d((String)LCAT, (String)("Property: " + key + " old: " + oldValue + " new: " + newValue));
        }
        CompoundButton cb = (CompoundButton)this.getNativeView();
        if (key.equals("style") && newValue != null) {
            this.setStyle(TiConvert.toInt((Object)newValue));
        } else if (key.equals("title") && cb.getClass().equals(CheckBox.class)) {
            cb.setText((CharSequence)((String)newValue));
        } else if (key.equals("titleOff") && cb.getClass().equals(ToggleButton.class)) {
            ((ToggleButton)cb).setTextOff((CharSequence)((String)newValue));
        } else if (key.equals("titleOn") && cb.getClass().equals(ToggleButton.class)) {
            ((ToggleButton)cb).setTextOff((CharSequence)((String)newValue));
        } else if (key.equals("value")) {
            cb.setChecked(TiConvert.toBoolean((Object)newValue));
        } else if (key.equals("color")) {
            cb.setTextColor(TiConvert.toColor((String)TiConvert.toString((Object)newValue)));
        } else if (key.equals("font")) {
            TiUIHelper.styleText((TextView)cb, (KrollDict)((KrollDict)newValue));
        } else if (key.equals("textAlign")) {
            TiUIHelper.setAlignment((TextView)cb, (String)TiConvert.toString((Object)newValue), null);
            cb.requestLayout();
        } else if (key.equals("verticalAlign")) {
            TiUIHelper.setAlignment((TextView)cb, null, (String)TiConvert.toString((Object)newValue));
            cb.requestLayout();
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
    }

    public void onCheckedChanged(CompoundButton btn, boolean value) {
        KrollDict data = new KrollDict();
        data.put((Object)"value", (Object)value);
        this.proxy.setProperty("value", (Object)value);
        this.proxy.fireEvent("change", data);
    }

    protected void setStyle(int style) {
        CompoundButton currentButton = (CompoundButton)this.getNativeView();
        CheckBox button = null;
        switch (style) {
            case 0: {
                if (currentButton instanceof CheckBox) break;
                button = new CheckBox(this.proxy.getContext());
                break;
            }
            case 1: {
                if (currentButton instanceof ToggleButton) break;
                button = new ToggleButton(this.proxy.getContext());
                break;
            }
            default: {
                return;
            }
        }
        if (button != null) {
            this.setNativeView((View)button);
            this.updateButton((CompoundButton)button, this.proxy.getProperties());
            button.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        }
    }
}

