/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.graphics.Rect;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.view.View;
import android.widget.SeekBar;
import java.lang.ref.SoftReference;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiFileHelper;
import org.appcelerator.titanium.view.TiUIView;

public class TiUISlider
extends TiUIView
implements SeekBar.OnSeekBarChangeListener {
    private static final String LCAT = "TiUISlider";
    private static final boolean DBG = TiConfig.LOGD;
    private int min;
    private int max;
    private int pos;
    private int offset;
    private int minRange;
    private int maxRange;
    private SoftReference<Drawable> thumbDrawable;

    public TiUISlider(TiViewProxy proxy) {
        super(proxy);
        if (DBG) {
            Log.d((String)LCAT, (String)"Creating a seekBar");
        }
        this.layoutParams.autoFillsWidth = true;
        this.min = 0;
        this.max = 0;
        this.pos = 0;
        SeekBar seekBar = new SeekBar(proxy.getContext());
        seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.setNativeView((View)seekBar);
    }

    public void processProperties(KrollDict d) {
        super.processProperties(d);
        SeekBar seekBar = (SeekBar)this.getNativeView();
        if (d.containsKey((Object)"value")) {
            this.pos = TiConvert.toInt((KrollDict)d, (String)"value");
        }
        if (d.containsKey((Object)"min")) {
            this.min = TiConvert.toInt((KrollDict)d, (String)"min");
        }
        if (d.containsKey((Object)"max")) {
            this.max = TiConvert.toInt((KrollDict)d, (String)"max");
        }
        this.minRange = d.containsKey((Object)"minRange") ? TiConvert.toInt((KrollDict)d, (String)"minRange") : this.min;
        this.maxRange = d.containsKey((Object)"maxRange") ? TiConvert.toInt((KrollDict)d, (String)"maxRange") : this.max;
        if (d.containsKey((Object)"thumbImage")) {
            this.updateThumb(seekBar, d);
        }
        if (d.containsKey((Object)"leftTrackImage") && d.containsKey((Object)"rightTrackImage")) {
            this.updateTrackingImages(seekBar, d);
        }
        this.updateRange();
        this.updateControl();
    }

    private void updateRange() {
        this.minRange = Math.max(this.minRange, this.min);
        this.minRange = Math.min(this.minRange, this.max);
        this.proxy.setProperty("minRange", (Object)this.minRange, false);
        this.maxRange = Math.min(this.maxRange, this.max);
        this.maxRange = Math.max(this.maxRange, this.min);
        this.proxy.setProperty("maxRange", (Object)this.maxRange, false);
    }

    private void updateControl() {
        this.offset = -this.min;
        int length = (int)Math.floor(Math.sqrt(Math.pow(this.max - this.min, 2.0)));
        SeekBar seekBar = (SeekBar)this.getNativeView();
        seekBar.setMax(length);
        seekBar.setProgress(this.pos + this.offset);
    }

    private void updateThumb(SeekBar seekBar, KrollDict d) {
        TiFileHelper tfh = null;
        String thumbImage = TiConvert.toString((KrollDict)d, (String)"thumbImage");
        if (thumbImage != null) {
            if (tfh == null) {
                tfh = new TiFileHelper(seekBar.getContext());
            }
            String url = this.proxy.getTiContext().resolveUrl(null, thumbImage);
            Drawable thumb = tfh.loadDrawable(this.proxy.getTiContext(), url, false);
            if (thumb != null) {
                this.thumbDrawable = new SoftReference<Drawable>(thumb);
                seekBar.setThumb(thumb);
            } else {
                Log.e((String)LCAT, (String)("Unable to locate thumb image for progress bar: " + url));
            }
        } else {
            seekBar.setThumb(null);
        }
    }

    private void updateTrackingImages(SeekBar seekBar, KrollDict d) {
        TiFileHelper tfh = null;
        String leftImage = TiConvert.toString((KrollDict)d, (String)"leftTrackImage");
        String rightImage = TiConvert.toString((KrollDict)d, (String)"rightTrackImage");
        if (leftImage != null && rightImage != null) {
            if (tfh == null) {
                tfh = new TiFileHelper(seekBar.getContext());
            }
            String leftUrl = this.proxy.getTiContext().resolveUrl(null, leftImage);
            String rightUrl = this.proxy.getTiContext().resolveUrl(null, rightImage);
            Drawable rightDrawable = tfh.loadDrawable(this.proxy.getTiContext(), rightUrl, false, true);
            Drawable leftDrawable = tfh.loadDrawable(this.proxy.getTiContext(), leftUrl, false, true);
            if (rightDrawable != null && leftDrawable != null) {
                Drawable[] lda = new Drawable[]{rightDrawable, new ClipDrawable(leftDrawable, 3, 1)};
                LayerDrawable ld = new LayerDrawable(lda);
                ld.setId(0, 0x1020000);
                ld.setId(1, 16908301);
                seekBar.setProgressDrawable((Drawable)ld);
            } else {
                if (leftDrawable == null) {
                    Log.e((String)LCAT, (String)("Unable to locate left image for progress bar: " + leftUrl));
                }
                if (rightDrawable == null) {
                    Log.e((String)LCAT, (String)("Unable to locate right image for progress bar: " + rightUrl));
                }
                leftDrawable = null;
                rightDrawable = null;
            }
        } else if (leftImage == null && rightImage == null) {
            seekBar.setProgressDrawable(null);
        } else {
            Log.w((String)LCAT, (String)"Custom tracking images must both be set before they'll be drawn.");
        }
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if (DBG) {
            Log.d((String)LCAT, (String)("Property: " + key + " old: " + oldValue + " new: " + newValue));
        }
        SeekBar seekBar = (SeekBar)this.getNativeView();
        if (key.equals("value")) {
            this.pos = TiConvert.toInt((Object)newValue);
            seekBar.setProgress(this.pos + this.offset);
            this.onProgressChanged(seekBar, this.pos, true);
        } else if (key.equals("min")) {
            this.minRange = this.min = TiConvert.toInt((Object)newValue);
            this.updateRange();
            if (this.pos < this.minRange) {
                this.pos = this.minRange;
            }
            this.updateControl();
            this.onProgressChanged(seekBar, this.pos, true);
        } else if (key.equals("minRange")) {
            this.minRange = TiConvert.toInt((Object)newValue);
            this.updateRange();
            if (this.pos < this.minRange) {
                this.pos = this.minRange;
            }
            this.updateControl();
            this.onProgressChanged(seekBar, this.pos, true);
        } else if (key.equals("max")) {
            this.maxRange = this.max = TiConvert.toInt((Object)newValue);
            this.updateRange();
            if (this.pos > this.maxRange) {
                this.pos = this.maxRange;
            }
            this.updateControl();
            this.onProgressChanged(seekBar, this.pos, true);
        } else if (key.equals("maxRange")) {
            this.maxRange = TiConvert.toInt((Object)newValue);
            this.updateRange();
            if (this.pos > this.maxRange) {
                this.pos = this.maxRange;
            }
            this.updateControl();
            this.onProgressChanged(seekBar, this.pos, true);
        } else if (key.equals("thumbImage")) {
            Log.i((String)LCAT, (String)"Dynamically changing thumbImage is not yet supported. Native control doesn't draw");
        } else if (key.equals("leftTrackImage") || key.equals("rightTrackImage")) {
            Log.i((String)LCAT, (String)"Dynamically changing leftTrackImage or rightTrackImage is not yet supported. Native control doesn't draw");
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        Rect thumbBounds;
        this.pos = seekBar.getProgress();
        int actualMinRange = this.minRange + this.offset;
        int actualMaxRange = this.maxRange + this.offset;
        if (this.pos < actualMinRange) {
            seekBar.setProgress(actualMinRange);
            this.pos = this.minRange;
        } else if (this.pos > actualMaxRange) {
            seekBar.setProgress(actualMaxRange);
            this.pos = this.maxRange;
        }
        Drawable thumb = this.thumbDrawable != null ? this.thumbDrawable.get() : null;
        KrollDict offset = new KrollDict();
        offset.put((Object)"x", (Object)0);
        offset.put((Object)"y", (Object)0);
        KrollDict size = new KrollDict();
        size.put((Object)"width", (Object)0);
        size.put((Object)"height", (Object)0);
        if (thumb != null && (thumbBounds = thumb.getBounds()) != null) {
            offset.put((Object)"x", (Object)(thumbBounds.left - seekBar.getThumbOffset()));
            offset.put((Object)"y", (Object)thumbBounds.top);
            size.put((Object)"width", (Object)thumbBounds.width());
            size.put((Object)"height", (Object)thumbBounds.height());
        }
        KrollDict data = new KrollDict();
        data.put((Object)"value", (Object)this.scaledValue());
        data.put((Object)"thumbOffset", (Object)offset);
        data.put((Object)"thumbSize", (Object)size);
        this.proxy.setProperty("value", (Object)this.scaledValue(), false);
        this.proxy.fireEvent("change", data);
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        KrollDict data = new KrollDict();
        data.put((Object)"value", (Object)this.scaledValue());
        this.proxy.fireEvent("stop", data);
    }

    private int scaledValue() {
        return this.pos + this.min;
    }
}

