/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.os.Handler;
import android.view.View;
import java.util.ArrayList;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiCompositeLayout;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.ScrollableViewProxy;
import ti.modules.titanium.ui.widget.TiScrollableView;

public class TiUIScrollableView
extends TiUIView {
    public TiUIScrollableView(ScrollableViewProxy proxy, Handler handler) {
        super((TiViewProxy)proxy);
        TiScrollableView view = new TiScrollableView(proxy, handler);
        TiCompositeLayout.LayoutParams params = this.getLayoutParams();
        params.autoFillsHeight = true;
        params.autoFillsWidth = true;
        this.setNativeView((View)view);
    }

    private TiScrollableView getView() {
        return (TiScrollableView)this.getNativeView();
    }

    public void processProperties(KrollDict d) {
        if (d.containsKey((Object)"views")) {
            this.getView().setViews(d.get((Object)"views"));
        }
        if (d.containsKey((Object)"showPagingControl")) {
            boolean showPager = TiConvert.toBoolean((KrollDict)d, (String)"showPagingControl");
            this.getView().setShowPagingControl(showPager);
            if (showPager) {
                this.showPager();
            }
        }
        if (d.containsKey((Object)"currentPage")) {
            this.setCurrentPage(TiConvert.toInt((KrollDict)d, (String)"currentPage"));
        }
        super.processProperties(d);
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if ("currentPage".equals(key)) {
            this.setCurrentPage(TiConvert.toInt((Object)newValue));
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
    }

    public ArrayList<TiViewProxy> getViews() {
        return this.getView().getViews();
    }

    public void setViews(Object viewsObject) {
        this.getView().setViews(viewsObject);
        if (this.proxy.hasProperty("currentPage")) {
            this.setCurrentPage(TiConvert.toInt((Object)this.proxy.getProperty("currentPage")));
        }
    }

    public void addView(TiViewProxy proxy) {
        this.getView().addView(proxy);
    }

    public void removeView(TiViewProxy proxy) {
        this.getView().removeView(proxy);
    }

    public void showPager() {
        boolean showPagingControl;
        Object showPagingControlProperty = this.proxy.getProperty("showPagingControl");
        if (showPagingControlProperty != null && (showPagingControl = TiConvert.toBoolean((Object)showPagingControlProperty))) {
            this.getView().showPager();
        }
    }

    public void hidePager() {
        this.getView().hidePager();
    }

    public void doMoveNext() {
        this.getView().doMoveNext();
    }

    public void doMovePrevious() {
        this.getView().doMovePrevious();
    }

    public void doScrollToView(Object view) {
        if (view instanceof Number) {
            this.getView().doScrollToView(((Number)view).intValue());
        } else if (view instanceof TiViewProxy) {
            this.getView().doScrollToView((TiViewProxy)view);
        }
    }

    public void setShowPagingControl(boolean showPagingControl) {
        this.getView().setShowPagingControl(showPagingControl);
    }

    public int getCurrentPage() {
        return this.getView().getSelectedItemPosition();
    }

    public void setCurrentPage(int page) {
        this.getView().doSetCurrentPage(page);
    }

    public void doSetCurrentPage(Object view) {
        if (view instanceof Number) {
            this.getView().doSetCurrentPage(((Number)view).intValue());
        } else if (view instanceof TiViewProxy) {
            this.getView().doSetCurrentPage((TiViewProxy)view);
        }
    }
}

