/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ScrollView;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiCompositeLayout;
import org.appcelerator.titanium.view.TiUIView;

public class TiUIScrollView
extends TiUIView {
    public static final int TYPE_VERTICAL = 0;
    public static final int TYPE_HORIZONTAL = 1;
    private static final String SHOW_VERTICAL_SCROLL_INDICATOR = "showVerticalScrollIndicator";
    private static final String SHOW_HORIZONTAL_SCROLL_INDICATOR = "showHorizontalScrollIndicator";
    private static final String LCAT = "TiUIScrollView";

    public TiUIScrollView(TiViewProxy proxy) {
        super(proxy);
        this.getLayoutParams().autoFillsHeight = true;
        this.getLayoutParams().autoFillsWidth = true;
    }

    public void processProperties(KrollDict d) {
        Object contentHeight;
        Object height;
        Object contentWidth;
        Object width;
        boolean showHorizontalScrollBar = false;
        boolean showVerticalScrollBar = false;
        if (d.containsKey((Object)SHOW_HORIZONTAL_SCROLL_INDICATOR)) {
            showHorizontalScrollBar = TiConvert.toBoolean((KrollDict)d, (String)SHOW_HORIZONTAL_SCROLL_INDICATOR);
        }
        if (d.containsKey((Object)SHOW_VERTICAL_SCROLL_INDICATOR)) {
            showVerticalScrollBar = TiConvert.toBoolean((KrollDict)d, (String)SHOW_VERTICAL_SCROLL_INDICATOR);
        }
        if (showHorizontalScrollBar && showVerticalScrollBar) {
            Log.w((String)LCAT, (String)"Both scroll bars cannot be shown. Defaulting to vertical shown");
            showHorizontalScrollBar = false;
        }
        int type = 0;
        if (d.containsKey((Object)"width") && d.containsKey((Object)"contentWidth") && ((width = d.get((Object)"width")).equals(contentWidth = d.get((Object)"contentWidth")) || showVerticalScrollBar)) {
            type = 0;
        }
        if (d.containsKey((Object)"height") && d.containsKey((Object)"contentHeight") && ((height = d.get((Object)"height")).equals(contentHeight = d.get((Object)"contentHeight")) || showHorizontalScrollBar)) {
            type = 1;
        }
        if (d.containsKey((Object)"scrollType")) {
            Object scrollType = d.get((Object)"scrollType");
            if (scrollType.equals("vertical")) {
                type = 0;
            } else if (scrollType.equals("horizontal")) {
                type = 1;
            }
        }
        Object view = null;
        TiCompositeLayout.LayoutArrangement arrangement = TiCompositeLayout.LayoutArrangement.DEFAULT;
        if (d.containsKey((Object)"layout") && d.getString("layout").equals("vertical")) {
            arrangement = TiCompositeLayout.LayoutArrangement.VERTICAL;
        } else if (d.containsKey((Object)"layout") && d.getString("layout").equals("horizontal")) {
            arrangement = TiCompositeLayout.LayoutArrangement.HORIZONTAL;
        }
        switch (type) {
            case 1: {
                Log.d((String)LCAT, (String)"creating horizontal scroll view");
                view = new TiHorizontalScrollView(this.getProxy().getContext(), arrangement);
                break;
            }
            default: {
                Log.d((String)LCAT, (String)"creating vertical scroll view");
                view = new TiVerticalScrollView(this.getProxy().getContext(), arrangement);
            }
        }
        this.setNativeView((View)view);
        this.nativeView.setHorizontalScrollBarEnabled(showHorizontalScrollBar);
        this.nativeView.setVerticalScrollBarEnabled(showVerticalScrollBar);
        super.processProperties(d);
    }

    public TiScrollViewLayout getLayout() {
        View nativeView = this.getNativeView();
        if (nativeView instanceof TiVerticalScrollView) {
            return ((TiVerticalScrollView)nativeView).layout;
        }
        return ((TiHorizontalScrollView)nativeView).layout;
    }

    public void scrollTo(int x, int y) {
        this.getNativeView().scrollTo(x, y);
        this.getNativeView().computeScroll();
    }

    public void scrollToBottom() {
        View view = this.getNativeView();
        if (view instanceof TiHorizontalScrollView) {
            TiHorizontalScrollView scrollView = (TiHorizontalScrollView)view;
            scrollView.fullScroll(66);
        } else if (view instanceof TiVerticalScrollView) {
            TiVerticalScrollView scrollView = (TiVerticalScrollView)view;
            scrollView.fullScroll(130);
        }
    }

    public void add(TiUIView child) {
        super.add(child);
        if (this.getNativeView() != null) {
            this.getLayout().requestLayout();
            if (child.getNativeView() != null) {
                child.getNativeView().requestLayout();
            }
        }
    }

    private class TiHorizontalScrollView
    extends HorizontalScrollView {
        private TiScrollViewLayout layout;

        public TiHorizontalScrollView(Context context, TiCompositeLayout.LayoutArrangement arrangement) {
            super(context);
            this.setScrollBarStyle(0);
            this.setFillViewport(true);
            this.setScrollContainer(true);
            this.layout = new TiScrollViewLayout(context, arrangement);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            this.layout.setLayoutParams((ViewGroup.LayoutParams)params);
            super.addView((View)this.layout, (ViewGroup.LayoutParams)params);
        }

        public void addView(View child, ViewGroup.LayoutParams params) {
            this.layout.addView(child, params);
        }

        protected void onScrollChanged(int l, int t, int oldl, int oldt) {
            super.onScrollChanged(l, t, oldl, oldt);
            KrollDict data = new KrollDict();
            data.put((Object)"x", (Object)l);
            data.put((Object)"y", (Object)t);
            TiUIScrollView.this.getProxy().fireEvent("scroll", data);
        }
    }

    private class TiVerticalScrollView
    extends ScrollView {
        private TiScrollViewLayout layout;

        public TiVerticalScrollView(Context context, TiCompositeLayout.LayoutArrangement arrangement) {
            super(context);
            this.setScrollBarStyle(0);
            this.layout = new TiScrollViewLayout(context, arrangement);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            this.layout.setLayoutParams((ViewGroup.LayoutParams)params);
            super.addView((View)this.layout, (ViewGroup.LayoutParams)params);
        }

        public void addView(View child, ViewGroup.LayoutParams params) {
            this.layout.addView(child, params);
        }

        protected void onScrollChanged(int l, int t, int oldl, int oldt) {
            super.onScrollChanged(l, t, oldl, oldt);
            KrollDict data = new KrollDict();
            data.put((Object)"x", (Object)l);
            data.put((Object)"y", (Object)t);
            TiUIScrollView.this.getProxy().fireEvent("scroll", data);
        }
    }

    private class TiScrollViewLayout
    extends TiCompositeLayout {
        private static final int AUTO = Integer.MAX_VALUE;
        protected int measuredWidth;
        protected int measuredHeight;

        public TiScrollViewLayout(Context context, TiCompositeLayout.LayoutArrangement arrangement) {
            super(context, arrangement);
            this.measuredWidth = 0;
            this.measuredHeight = 0;
        }

        private TiCompositeLayout.LayoutParams getParams(View child) {
            return (TiCompositeLayout.LayoutParams)child.getLayoutParams();
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            super.onLayout(changed, l, t, r, b);
            this.measuredWidth = 0;
            this.measuredHeight = 0;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.setMeasuredDimension(Math.max(this.measuredWidth, this.getMeasuredWidth()), Math.max(this.measuredHeight, this.getMeasuredHeight()));
        }

        private int getContentProperty(String property) {
            Object value = TiUIScrollView.this.getProxy().getProperty(property);
            if (value != null) {
                if (value.equals("auto")) {
                    return Integer.MAX_VALUE;
                }
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
            }
            return Integer.MAX_VALUE;
        }

        private int calculateAbsoluteRight(View child) {
            TiCompositeLayout.LayoutParams p = this.getParams(child);
            int contentWidth = this.getContentProperty("contentWidth");
            if (contentWidth == Integer.MAX_VALUE) {
                int childMeasuredWidth = child.getMeasuredWidth();
                if (!p.autoWidth) {
                    childMeasuredWidth = p.optionWidth.getAsPixels((View)this);
                }
                if (p.optionLeft != null) {
                    childMeasuredWidth += p.optionLeft.getAsPixels((View)this);
                }
                if (p.optionRight != null) {
                    childMeasuredWidth += p.optionRight.getAsPixels((View)this);
                }
                this.measuredWidth = Math.max(childMeasuredWidth, this.measuredWidth);
            } else {
                this.measuredWidth = contentWidth;
            }
            return this.measuredWidth;
        }

        private int calculateAbsoluteBottom(View child) {
            TiCompositeLayout.LayoutParams p = (TiCompositeLayout.LayoutParams)child.getLayoutParams();
            int contentHeight = this.getContentProperty("contentHeight");
            if (contentHeight == Integer.MAX_VALUE) {
                int childMeasuredHeight = child.getMeasuredHeight();
                if (!p.autoHeight) {
                    childMeasuredHeight = p.optionHeight.getAsPixels((View)this);
                }
                if (p.optionTop != null) {
                    childMeasuredHeight += p.optionTop.getAsPixels((View)this);
                }
                if (p.optionBottom != null) {
                    childMeasuredHeight += p.optionBottom.getAsPixels((View)this);
                }
                this.measuredHeight = Math.max(childMeasuredHeight, this.measuredHeight);
            } else {
                this.measuredHeight = contentHeight;
            }
            return this.measuredHeight;
        }

        protected void constrainChild(View child, int width, int wMode, int height, int hMode) {
            super.constrainChild(child, width, wMode, height, hMode);
            int absWidth = this.calculateAbsoluteRight(child);
            int absHeight = this.calculateAbsoluteBottom(child);
        }

        protected int getWidthMeasureSpec(View child) {
            int contentWidth = this.getContentProperty("contentWidth");
            if (contentWidth == Integer.MAX_VALUE) {
                return 0;
            }
            return super.getWidthMeasureSpec(child);
        }

        protected int getHeightMeasureSpec(View child) {
            int contentHeight = this.getContentProperty("contentHeight");
            if (contentHeight == Integer.MAX_VALUE) {
                return 0;
            }
            return super.getHeightMeasureSpec(child);
        }

        protected int getMeasuredWidth(int maxWidth, int widthSpec) {
            int contentWidth = this.getContentProperty("contentWidth");
            if (contentWidth == Integer.MAX_VALUE) {
                return maxWidth;
            }
            return contentWidth;
        }

        protected int getMeasuredHeight(int maxHeight, int heightSpec) {
            int contentHeight = this.getContentProperty("contentHeight");
            if (contentHeight == Integer.MAX_VALUE) {
                return maxHeight;
            }
            return contentHeight;
        }
    }
}

