/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.view.View;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiUIView;

public class TiUIProgressBar
extends TiUIView {
    private TextView label;
    private ProgressBar progress;
    private LinearLayout view;

    public TiUIProgressBar(TiViewProxy proxy) {
        super(proxy);
        this.view = new LinearLayout(proxy.getContext());
        this.view.setOrientation(1);
        this.label = new TextView(proxy.getContext());
        this.label.setGravity(51);
        this.label.setPadding(0, 0, 0, 0);
        this.label.setSingleLine(false);
        this.progress = new ProgressBar(proxy.getContext(), null, 16842872);
        this.progress.setIndeterminate(false);
        this.progress.setMax(1000);
        this.view.addView((View)this.label);
        this.view.addView((View)this.progress);
        this.setNativeView((View)this.view);
    }

    public void processProperties(KrollDict d) {
        super.processProperties(d);
        if (d.containsKey((Object)"message")) {
            this.handleSetMessage(TiConvert.toString((KrollDict)d, (String)"message"));
        }
        this.updateProgress();
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        super.propertyChanged(key, oldValue, newValue, proxy);
        if (key.equals("value") || key.equals("min") || key.equals("max")) {
            this.updateProgress();
        }
    }

    private double getMin() {
        Object value = this.proxy.getProperty("min");
        if (value == null) {
            return 0.0;
        }
        return TiConvert.toDouble((Object)value);
    }

    private double getMax() {
        Object value = this.proxy.getProperty("max");
        if (value == null) {
            return 0.0;
        }
        return TiConvert.toDouble((Object)value);
    }

    private double getValue() {
        Object value = this.proxy.getProperty("value");
        if (value == null) {
            return 0.0;
        }
        return TiConvert.toDouble((Object)value);
    }

    private int convertRange(double min, double max, double value, int base) {
        return (int)Math.floor(value / (max - min) * (double)base);
    }

    public void updateProgress() {
        this.progress.setProgress(this.convertRange(this.getMin(), this.getMax(), this.getValue(), 1000));
    }

    public void handleSetMessage(String message) {
        this.label.setText((CharSequence)message);
        this.label.requestLayout();
    }
}

