/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.content.Context;
import android.widget.Toast;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiUIView;

public class TiUINotification
extends TiUIView {
    private static final String LCAT = "TiUINotifier";
    private static final boolean DBG = TiConfig.LOGD;
    private Toast toast;

    public TiUINotification(TiViewProxy proxy) {
        super(proxy);
        if (DBG) {
            Log.d((String)LCAT, (String)"Creating a notifier");
        }
        this.toast = Toast.makeText((Context)proxy.getTiContext().getActivity(), (CharSequence)"", (int)0);
    }

    public void processProperties(KrollDict d) {
        float horizontalMargin = this.toast.getHorizontalMargin();
        float verticalMargin = this.toast.getVerticalMargin();
        int offsetX = this.toast.getXOffset();
        int offsetY = this.toast.getYOffset();
        int gravity = this.toast.getGravity();
        if (this.proxy.hasProperty("duration")) {
            int duration = TiConvert.toInt((Object)this.proxy.getProperty("duration"));
            this.toast.setDuration(duration);
        }
        if (this.proxy.hasProperty("horizontalMargin")) {
            horizontalMargin = TiConvert.toFloat((Object)this.proxy.getProperty("horizontalMargin"));
        }
        if (this.proxy.hasProperty("verticalMargin")) {
            verticalMargin = TiConvert.toFloat((Object)this.proxy.getProperty("verticalMargin"));
        }
        this.toast.setMargin(horizontalMargin, verticalMargin);
        if (this.proxy.hasProperty("offsetX")) {
            offsetX = TiConvert.toInt((Object)this.proxy.getProperty("offsetX"));
        }
        if (this.proxy.hasProperty("offsetY")) {
            offsetY = TiConvert.toInt((Object)this.proxy.getProperty("offsetY"));
        }
        if (this.proxy.hasProperty("gravity")) {
            gravity = TiConvert.toInt((Object)this.proxy.getProperty("gravity"));
        }
        this.toast.setGravity(gravity, offsetX, offsetY);
        super.processProperties(d);
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        KrollDict d = new KrollDict();
        d.put((Object)key, newValue);
        this.processProperties(d);
        if (DBG) {
            Log.d((String)LCAT, (String)("PropertyChanged - Property '" + key + "' changed to '" + newValue + "' from '" + oldValue + "'"));
        }
    }

    public void show(KrollDict options) {
        this.toast.setText((CharSequence)((String)this.proxy.getProperty("message")));
        this.toast.show();
    }

    public void hide(KrollDict options) {
        this.toast.cancel();
    }
}

