/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.text.Html;
import android.text.TextUtils;
import android.text.util.Linkify;
import android.view.View;
import android.widget.TextView;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiUIHelper;
import org.appcelerator.titanium.view.TiUIView;

public class TiUILabel
extends TiUIView {
    private static final String LCAT = "TiUILabel";
    private static final boolean DBG = TiConfig.LOGD;

    public TiUILabel(TiViewProxy proxy) {
        super(proxy);
        if (DBG) {
            Log.d((String)LCAT, (String)"Creating a text label");
        }
        TextView tv = new TextView(this.getProxy().getContext());
        tv.setGravity(19);
        tv.setPadding(0, 0, 0, 0);
        tv.setInputType(131073);
        tv.setKeyListener(null);
        tv.setFocusable(false);
        this.setNativeView((View)tv);
    }

    public void processProperties(KrollDict d) {
        super.processProperties(d);
        TextView tv = (TextView)this.getNativeView();
        if (d.containsKey((Object)"html")) {
            tv.setText((CharSequence)Html.fromHtml((String)TiConvert.toString((KrollDict)d, (String)"html")), TextView.BufferType.SPANNABLE);
        } else if (d.containsKey((Object)"text")) {
            tv.setText((CharSequence)TiConvert.toString((KrollDict)d, (String)"text"));
        } else if (d.containsKey((Object)"title")) {
            tv.setText((CharSequence)TiConvert.toString((KrollDict)d, (String)"title"));
        }
        if (d.containsKey((Object)"color")) {
            tv.setTextColor(TiConvert.toColor((KrollDict)d, (String)"color"));
        }
        if (d.containsKey((Object)"highlightedColor")) {
            tv.setHighlightColor(TiConvert.toColor((KrollDict)d, (String)"highlightedColor"));
        }
        if (d.containsKey((Object)"font")) {
            TiUIHelper.styleText((TextView)tv, (KrollDict)d.getKrollDict("font"));
        }
        if (d.containsKey((Object)"textAlign")) {
            String textAlign = d.getString("textAlign");
            TiUIHelper.setAlignment((TextView)tv, (String)textAlign, null);
        }
        if (d.containsKey((Object)"verticalAlign")) {
            String verticalAlign = d.getString("verticalAlign");
            TiUIHelper.setAlignment((TextView)tv, null, (String)verticalAlign);
        }
        if (d.containsKey((Object)"ellipsize")) {
            if (TiConvert.toBoolean((KrollDict)d, (String)"ellipsize")) {
                tv.setEllipsize(TextUtils.TruncateAt.END);
            } else {
                tv.setEllipsize(null);
            }
        }
        if (d.containsKey((Object)"wordWrap")) {
            tv.setSingleLine(!TiConvert.toBoolean((KrollDict)d, (String)"wordWrap"));
        }
        this.linkifyIfEnabled(tv, d);
        tv.invalidate();
    }

    private void linkifyIfEnabled(TextView tv, KrollDict d) {
        if (d.containsKey((Object)"autoLink")) {
            Linkify.addLinks((TextView)tv, (int)TiConvert.toInt((KrollDict)d, (String)"autoLink"));
        }
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if (DBG) {
            Log.d((String)LCAT, (String)("Property: " + key + " old: " + oldValue + " new: " + newValue));
        }
        TextView tv = (TextView)this.getNativeView();
        if (key.equals("html")) {
            tv.setText((CharSequence)Html.fromHtml((String)TiConvert.toString((Object)newValue)), TextView.BufferType.SPANNABLE);
            this.linkifyIfEnabled(tv, proxy.getProperties());
            tv.requestLayout();
        } else if (key.equals("text") || key.equals("title")) {
            tv.setText((CharSequence)TiConvert.toString((Object)newValue));
            this.linkifyIfEnabled(tv, proxy.getProperties());
            tv.requestLayout();
        } else if (key.equals("color")) {
            tv.setTextColor(TiConvert.toColor((String)((String)newValue)));
        } else if (key.equals("highlightedColor")) {
            tv.setHighlightColor(TiConvert.toColor((String)((String)newValue)));
        } else if (key.equals("textAlign")) {
            TiUIHelper.setAlignment((TextView)tv, (String)TiConvert.toString((Object)newValue), null);
            tv.requestLayout();
        } else if (key.equals("verticalAlign")) {
            TiUIHelper.setAlignment((TextView)tv, null, (String)TiConvert.toString((Object)newValue));
            tv.requestLayout();
        } else if (key.equals("font")) {
            TiUIHelper.styleText((TextView)tv, (KrollDict)((KrollDict)newValue));
            tv.requestLayout();
        } else if (key.equals("ellipsize")) {
            if (TiConvert.toBoolean((Object)newValue)) {
                tv.setEllipsize(TextUtils.TruncateAt.END);
            } else {
                tv.setEllipsize(null);
            }
        } else if (key.equals("wordWrap")) {
            tv.setSingleLine(!TiConvert.toBoolean((Object)newValue));
        } else if (key.equals("autoLink")) {
            Linkify.addLinks((TextView)tv, (int)TiConvert.toInt((Object)newValue));
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
    }

    public void setClickable(boolean clickable) {
        ((TextView)this.getNativeView()).setClickable(clickable);
    }
}

