/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.View;
import android.view.ViewParent;
import android.webkit.URLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiDimension;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.AsyncResult;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiBackgroundImageLoadTask;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiDownloadListener;
import org.appcelerator.titanium.util.TiResponseCache;
import org.appcelerator.titanium.util.TiUIHelper;
import org.appcelerator.titanium.view.TiDrawableReference;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.filesystem.FileProxy;
import ti.modules.titanium.ui.ImageViewProxy;
import ti.modules.titanium.ui.widget.TiImageView;

public class TiUIImageView
extends TiUIView
implements TiContext.OnLifecycleEvent,
Handler.Callback {
    private static final String LCAT = "TiUIImageView";
    private static final boolean DBG = TiConfig.LOGD;
    private static final AtomicInteger imageTokenGenerator = new AtomicInteger(0);
    private static final int FRAME_QUEUE_SIZE = 5;
    public static final int INFINITE = 0;
    private static final String PROPERTY_DECODE_RETRIES = "decodeRetries";
    private static final int DEFAULT_DECODE_RETRIES = 5;
    private Timer timer;
    private Animator animator;
    private Object[] images;
    private Loader loader;
    private Thread loaderThread;
    private AtomicBoolean animating = new AtomicBoolean(false);
    private boolean reverse = false;
    private boolean paused = false;
    private int token;
    private boolean firedLoad;
    private ImageViewProxy imageViewProxy;
    private TiDimension requestedWidth;
    private TiDimension requestedHeight;
    private ArrayList<TiDrawableReference> imageSources;
    private TiDrawableReference defaultImageSource;
    private TiDownloadListener downloadListener;
    private int decodeRetries = 0;
    private Handler handler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    private static final int SET_IMAGE = 10001;

    public TiUIImageView(TiViewProxy proxy) {
        super(proxy);
        this.imageViewProxy = (ImageViewProxy)proxy;
        if (DBG) {
            Log.d((String)LCAT, (String)"Creating an ImageView");
        }
        TiImageView view = new TiImageView(proxy.getContext());
        view.setOnSizeChangeListener(new TiImageView.OnSizeChangeListener(){

            @Override
            public void sizeChanged(int w, int h, int oldWidth, int oldHeight) {
                TiUIImageView.this.setImage(true);
            }
        });
        this.downloadListener = new TiDownloadListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void downloadFinished(URI uri) {
                if (!TiResponseCache.peek((URI)uri)) {
                    AtomicInteger atomicInteger = imageTokenGenerator;
                    synchronized (atomicInteger) {
                        TiUIImageView.this.token = imageTokenGenerator.incrementAndGet();
                        ((TiDrawableReference)TiUIImageView.this.imageSources.get(0)).getBitmapAsync((TiBackgroundImageLoadTask)new BgImageLoader(TiUIImageView.this.getProxy().getTiContext(), TiUIImageView.this.requestedWidth, TiUIImageView.this.requestedHeight, TiUIImageView.this.token));
                    }
                } else {
                    TiUIImageView.this.setImage(true);
                }
            }
        };
        this.setNativeView((View)view);
        proxy.getTiContext().addOnLifecycleEventListener((TiContext.OnLifecycleEvent)this);
    }

    public void setProxy(TiViewProxy proxy) {
        super.setProxy(proxy);
        this.imageViewProxy = (ImageViewProxy)proxy;
    }

    private TiImageView getView() {
        return (TiImageView)this.nativeView;
    }

    protected View getParentView() {
        TiUIView parentTiUi;
        TiViewProxy parentProxy;
        if (this.nativeView == null) {
            return null;
        }
        ViewParent parent = this.nativeView.getParent();
        if (parent instanceof View) {
            return (View)parent;
        }
        if (parent == null && (parentProxy = this.proxy.getParent()) != null && (parentTiUi = parentProxy.peekView()) != null) {
            return parentTiUi.getNativeView();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setImageDrawable(Drawable d, int token) {
        TiImageView view = this.getView();
        if (view != null) {
            AtomicInteger atomicInteger = imageTokenGenerator;
            synchronized (atomicInteger) {
                if (this.token == token) {
                    view.setImageDrawable(d, false);
                    this.token = -1;
                }
            }
        }
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 10001) {
            AsyncResult result = (AsyncResult)msg.obj;
            TiImageView view = this.getView();
            if (view != null) {
                view.setImageBitmap((Bitmap)result.getArg());
                result.setResult(null);
            }
        }
        return false;
    }

    private void setImage(Bitmap bitmap) {
        if (bitmap != null) {
            if (!this.proxy.getTiContext().isUIThread()) {
                AsyncResult result = new AsyncResult((Object)bitmap);
                this.proxy.sendBlockingUiMessage(this.handler.obtainMessage(10001, (Object)result), result);
            } else {
                TiImageView view = this.getView();
                if (view != null) {
                    view.setImageBitmap(bitmap);
                }
            }
            this.imageViewProxy.onBitmapChanged(this, bitmap);
        }
    }

    private void setImages() {
        if (this.imageSources == null || this.imageSources.size() == 0) {
            return;
        }
        if (this.loader == null) {
            this.paused = false;
            this.firedLoad = false;
            this.loader = new Loader();
            Thread loaderThread = new Thread(this.loader);
            if (DBG) {
                Log.d((String)LCAT, (String)("STARTING LOADER THREAD " + loaderThread + " for " + (Object)((Object)this)));
            }
            loaderThread.start();
        }
    }

    public double getDuration() {
        if (this.proxy.getProperty("duration") != null) {
            return TiConvert.toDouble((Object)this.proxy.getProperty("duration"));
        }
        if (this.images != null) {
            return this.images.length * 33;
        }
        return 100.0;
    }

    public int getRepeatCount() {
        if (this.proxy.hasProperty("repeatCount")) {
            return TiConvert.toInt((Object)this.proxy.getProperty("repeatCount"));
        }
        return 0;
    }

    private void fireLoad(String state) {
        KrollDict data = new KrollDict();
        data.put((Object)"state", (Object)state);
        this.proxy.fireEvent("load", data);
    }

    private void fireStart() {
        KrollDict data = new KrollDict();
        this.proxy.fireEvent("start", data);
    }

    private void fireChange(int index) {
        KrollDict data = new KrollDict();
        data.put((Object)"index", (Object)index);
        this.proxy.fireEvent("change", data);
    }

    private void fireStop() {
        KrollDict data = new KrollDict();
        this.proxy.fireEvent("stop", data);
    }

    public void start() {
        if (!this.proxy.getTiContext().isUIThread()) {
            this.proxy.getTiContext().getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    TiUIImageView.this.handleStart();
                }
            });
        } else {
            this.handleStart();
        }
    }

    public void handleStart() {
        if (this.animator == null) {
            this.timer = new Timer();
            if (this.loader == null) {
                this.loader = new Loader();
                this.loaderThread = new Thread(this.loader);
                if (DBG) {
                    Log.d((String)LCAT, (String)("STARTING LOADER THREAD " + this.loaderThread + " for " + (Object)((Object)this)));
                }
            }
            this.animator = new Animator(this.loader);
            if (!this.animating.get()) {
                new Thread(this.loader).start();
            }
            int duration = (int)this.getDuration();
            this.fireStart();
            this.timer.schedule((TimerTask)this.animator, duration, (long)duration);
        } else {
            this.resume();
        }
    }

    public void pause() {
        this.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.paused = false;
        if (this.loader != null) {
            Loader loader = this.loader;
            synchronized (loader) {
                this.loader.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.animating.set(false);
        if (this.loaderThread != null) {
            this.loaderThread.interrupt();
            this.loaderThread = null;
        }
        if (this.loader != null) {
            Loader loader = this.loader;
            synchronized (loader) {
                this.loader.notify();
            }
        }
        this.loader = null;
        this.timer = null;
        this.animator = null;
        this.paused = false;
        this.fireStop();
    }

    private void setImageSource(Object object) {
        ArrayList<TiDrawableReference> currentSources;
        if (this.imageViewProxy.inTableView() && (currentSources = this.imageViewProxy.getImageSources()) != null) {
            this.imageSources = currentSources;
            return;
        }
        this.imageSources = new ArrayList();
        if (object instanceof Object[]) {
            for (Object o : (Object[])object) {
                this.imageSources.add(this.makeImageSource(o));
            }
        } else {
            this.imageSources.add(this.makeImageSource(object));
        }
        this.imageViewProxy.onImageSourcesChanged(this, this.imageSources);
    }

    private void setImageSource(TiDrawableReference source) {
        this.imageSources = new ArrayList();
        this.imageSources.add(source);
    }

    private TiDrawableReference makeImageSource(Object object) {
        if (object instanceof FileProxy) {
            return TiDrawableReference.fromFile((TiContext)this.getProxy().getTiContext(), (TiBaseFile)((FileProxy)object).getBaseFile());
        }
        return TiDrawableReference.fromObject((TiContext)this.getProxy().getTiContext(), (Object)object);
    }

    private void setDefaultImageSource(Object object) {
        this.defaultImageSource = object instanceof FileProxy ? TiDrawableReference.fromFile((TiContext)this.getProxy().getTiContext(), (TiBaseFile)((FileProxy)object).getBaseFile()) : TiDrawableReference.fromObject((TiContext)this.getProxy().getTiContext(), (Object)object);
    }

    private void setImage(boolean recycle) {
        if (this.imageSources == null || this.imageSources.size() == 0) {
            this.setImage(null);
            return;
        }
        if (this.imageSources.size() == 1) {
            ArrayList<TiDrawableReference> proxySources;
            Bitmap currentBitmap;
            if (this.imageViewProxy.inTableView() && (currentBitmap = this.imageViewProxy.getBitmap()) != null && (proxySources = this.imageViewProxy.getImageSources()) != null && !proxySources.contains(this.defaultImageSource)) {
                this.setImage(currentBitmap);
                return;
            }
            TiDrawableReference imageref = this.imageSources.get(0);
            if (imageref.isNetworkUrl()) {
                if (this.defaultImageSource != null) {
                    this.setDefaultImage();
                } else {
                    TiImageView view = this.getView();
                    if (view != null) {
                        view.setImageDrawable(null, recycle);
                    }
                }
                boolean getAsync = true;
                try {
                    URI uri = new URI(imageref.getUrl());
                    getAsync = !TiResponseCache.peek((URI)uri);
                }
                catch (URISyntaxException e) {
                    Log.e((String)LCAT, (String)("URISyntaxException for url " + imageref.getUrl()), (Throwable)e);
                    getAsync = false;
                }
                if (getAsync) {
                    imageref.getBitmapAsync(this.downloadListener);
                } else {
                    Bitmap bitmap = imageref.getBitmap(this.getParentView(), this.requestedWidth, this.requestedHeight);
                    if (bitmap != null) {
                        this.setImage(bitmap);
                    } else {
                        this.retryDecode(recycle);
                    }
                }
            } else {
                this.setImage(imageref.getBitmap(this.getParentView(), this.requestedWidth, this.requestedHeight));
            }
        } else {
            this.setImages();
        }
    }

    private void setDefaultImage() {
        if (this.defaultImageSource == null) {
            this.setImage(null);
            return;
        }
        this.setImage(this.defaultImageSource.getBitmap(this.getParentView(), this.requestedWidth, this.requestedHeight));
    }

    private void retryDecode(final boolean recycle) {
        final int maxRetries = this.proxy.getProperties().optInt(PROPERTY_DECODE_RETRIES, Integer.valueOf(5));
        if (this.decodeRetries < maxRetries) {
            ++this.decodeRetries;
            this.proxy.getUIHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    Log.d((String)TiUIImageView.LCAT, (String)("Retrying bitmap decode: " + TiUIImageView.this.decodeRetries + "/" + maxRetries));
                    TiUIImageView.this.setImage(recycle);
                }
            }, 250L);
        } else {
            String url = null;
            if (this.imageSources != null && this.imageSources.size() == 1) {
                url = this.imageSources.get(0).getUrl();
            }
            Log.e((String)LCAT, (String)("Max retries reached, giving up decoding image source: " + url));
        }
    }

    public void processProperties(KrollDict d) {
        TiImageView view = this.getView();
        if (view == null) {
            return;
        }
        if (d.containsKey((Object)"width")) {
            this.requestedWidth = TiConvert.toTiDimension((KrollDict)d, (String)"width", (int)6);
        }
        if (d.containsKey((Object)"height")) {
            this.requestedHeight = TiConvert.toTiDimension((KrollDict)d, (String)"height", (int)7);
        }
        if (d.containsKey((Object)"images")) {
            this.setImageSource(d.get((Object)"images"));
            this.setImages();
        } else if (d.containsKey((Object)"url")) {
            Log.w((String)LCAT, (String)"The url property of ImageView is deprecated, use image instead.");
            if (!d.containsKey((Object)"image")) {
                d.put((Object)"image", d.get((Object)"url"));
            }
        }
        if (d.containsKey((Object)"canScale")) {
            view.setCanScaleImage(TiConvert.toBoolean((KrollDict)d, (String)"canScale"));
        }
        if (d.containsKey((Object)"enableZoomControls")) {
            view.setEnableZoomControls(TiConvert.toBoolean((KrollDict)d, (String)"enableZoomControls"));
        }
        if (d.containsKey((Object)"defaultImage")) {
            try {
                if (!d.containsKey((Object)"image") || URLUtil.isNetworkUrl((String)d.getString("image")) && !TiResponseCache.peek((URI)new URI(d.getString("image")))) {
                    this.setDefaultImageSource(d.get((Object)"defaultImage"));
                }
            }
            catch (URISyntaxException e) {
                this.setDefaultImageSource(d.get((Object)"defaultImage"));
            }
        }
        if (d.containsKey((Object)"image")) {
            boolean changeImage = true;
            Object newImage = d.get((Object)"image");
            TiDrawableReference source = this.makeImageSource(newImage);
            if (this.imageSources != null && this.imageSources.size() == 1 && this.imageSources.get(0).equals((Object)source)) {
                changeImage = false;
            }
            if (changeImage) {
                this.setImageSource(source);
                this.setImage(false);
            }
        } else if (!d.containsKey((Object)"images")) {
            this.getProxy().setProperty("image", null);
            if (this.defaultImageSource != null) {
                this.setDefaultImage();
            }
        }
        super.processProperties(d);
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        TiImageView view = this.getView();
        if (view == null) {
            return;
        }
        if (key.equals("canScale")) {
            view.setCanScaleImage(TiConvert.toBoolean((Object)newValue));
        } else if (key.equals("enableZoomControls")) {
            view.setEnableZoomControls(TiConvert.toBoolean((Object)newValue));
        } else if (key.equals("url")) {
            this.setImageSource(newValue);
            this.setImage(true);
        } else if (key.equals("image")) {
            this.setImageSource(newValue);
            this.setImage(true);
        } else if (key.equals("images")) {
            if (newValue instanceof Object[]) {
                this.setImageSource(newValue);
                this.setImages();
            }
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
    }

    public void onDestroy(Activity activity) {
    }

    public void onPause(Activity activity) {
        this.pause();
    }

    public void onResume(Activity activity) {
        this.resume();
    }

    public void onStart(Activity activity) {
    }

    public void onStop(Activity activity) {
        this.stop();
    }

    public boolean isAnimating() {
        return this.animating.get() && !this.paused;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public TiBlob toBlob() {
        Drawable drawable;
        TiImageView view = this.getView();
        if (view != null && (drawable = view.getImageDrawable()) != null && drawable instanceof BitmapDrawable) {
            Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
            return TiBlob.blobFromImage((TiContext)this.proxy.getTiContext(), (Bitmap)bitmap);
        }
        return null;
    }

    public void setOpacity(float opacity) {
        TiImageView view = this.getView();
        if (view != null) {
            view.setColorFilter(TiUIHelper.createColorFilterForOpacity((float)opacity));
            super.setOpacity(opacity);
        }
    }

    public void clearOpacity(View view) {
        super.clearOpacity(view);
        TiImageView iview = this.getView();
        if (iview != null) {
            iview.setColorFilter(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        super.release();
        if (this.loader != null) {
            Loader loader = this.loader;
            synchronized (loader) {
                this.loader.notify();
            }
            this.loader = null;
        }
        if (this.imageSources != null) {
            this.imageSources.clear();
        }
        this.imageSources = null;
        this.defaultImageSource = null;
    }

    private class Animator
    extends TimerTask {
        private Loader loader;

        public Animator(Loader loader) {
            this.loader = loader;
        }

        @Override
        public void run() {
            try {
                BitmapWithIndex b = this.loader.getBitmapQueue().take();
                if (DBG) {
                    Log.d((String)TiUIImageView.LCAT, (String)("set image: " + b.index));
                }
                TiUIImageView.this.setImage(b.bitmap);
                TiUIImageView.this.fireChange(b.index);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private class Loader
    implements Runnable {
        private ArrayBlockingQueue<BitmapWithIndex> bitmapQueue = new ArrayBlockingQueue(5);
        private int repeatIndex = 0;

        private boolean isRepeating() {
            int repeatCount = TiUIImageView.this.getRepeatCount();
            if (repeatCount <= 0) {
                return true;
            }
            return this.repeatIndex < repeatCount;
        }

        private int getStart() {
            if (TiUIImageView.this.imageSources == null) {
                return 0;
            }
            if (TiUIImageView.this.reverse) {
                return TiUIImageView.this.imageSources.size() - 1;
            }
            return 0;
        }

        private boolean isNotFinalFrame(int frame) {
            if (TiUIImageView.this.imageSources == null) {
                return false;
            }
            if (TiUIImageView.this.reverse) {
                return frame >= 0;
            }
            return frame < TiUIImageView.this.imageSources.size();
        }

        private int getCounter() {
            if (TiUIImageView.this.reverse) {
                return -1;
            }
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TiUIImageView.this.getProxy() == null) {
                Log.d((String)TiUIImageView.LCAT, (String)"Multi-image loader exiting early because proxy has been gc'd");
                return;
            }
            TiContext context = TiUIImageView.this.getProxy().getTiContext();
            if (context == null) {
                Log.d((String)TiUIImageView.LCAT, (String)"Multi-image loader exiting early because context has been gc'd");
                return;
            }
            this.repeatIndex = 0;
            TiUIImageView.this.animating.set(true);
            TiUIImageView.this.firedLoad = false;
            block7: while (this.isRepeating() && TiUIImageView.this.imageSources != null) {
                long time = System.currentTimeMillis();
                int j = this.getStart();
                while (TiUIImageView.this.imageSources != null && this.isNotFinalFrame(j)) {
                    if (this.bitmapQueue.size() == 5 && !TiUIImageView.this.firedLoad) {
                        TiUIImageView.this.fireLoad("images");
                        TiUIImageView.this.firedLoad = true;
                    }
                    if (TiUIImageView.this.paused && !Thread.currentThread().isInterrupted()) {
                        try {
                            Log.i((String)TiUIImageView.LCAT, (String)"Pausing");
                            if (TiUIImageView.this.loader == null) break;
                            Loader loader = TiUIImageView.this.loader;
                            synchronized (loader) {
                                TiUIImageView.this.loader.wait();
                            }
                            Log.i((String)TiUIImageView.LCAT, (String)"Waking from pause.");
                        }
                        catch (InterruptedException e) {
                            Log.w((String)TiUIImageView.LCAT, (String)"Interrupted from paused state.");
                        }
                    }
                    if (!TiUIImageView.this.animating.get()) break block7;
                    Bitmap b = ((TiDrawableReference)TiUIImageView.this.imageSources.get(j)).getBitmap();
                    try {
                        this.bitmapQueue.offer(new BitmapWithIndex(b, j), (int)TiUIImageView.this.getDuration() * TiUIImageView.this.imageSources.size(), TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++this.repeatIndex;
                    j += this.getCounter();
                }
                if (!DBG) continue;
                Log.d((String)TiUIImageView.LCAT, (String)("TIME TO LOAD FRAMES: " + (System.currentTimeMillis() - time) + "ms"));
            }
            TiUIImageView.this.animating.set(false);
        }

        public ArrayBlockingQueue<BitmapWithIndex> getBitmapQueue() {
            return this.bitmapQueue;
        }
    }

    private class BitmapWithIndex {
        public Bitmap bitmap;
        public int index;

        public BitmapWithIndex(Bitmap b, int i) {
            this.bitmap = b;
            this.index = i;
        }
    }

    private class BgImageLoader
    extends TiBackgroundImageLoadTask {
        private int token;

        public BgImageLoader(TiContext tiContext, TiDimension imageWidth, TiDimension imageHeight, int token) {
            super(tiContext, TiUIImageView.this.getParentView(), imageWidth, imageHeight);
            this.token = token;
        }

        protected void onPostExecute(Drawable d) {
            super.onPostExecute((Object)d);
            if (d != null) {
                TiUIImageView.this.setImageDrawable(d, this.token);
            } else if (DBG) {
                Object image;
                String traceMsg = "Background image load returned null";
                if (TiUIImageView.this.proxy.hasProperty("image") && (image = TiUIImageView.this.proxy.getProperty("image")) instanceof String) {
                    traceMsg = traceMsg + " (" + TiConvert.toString((Object)image) + ")";
                }
                Log.d((String)TiUIImageView.LCAT, (String)traceMsg);
            }
        }
    }
}

