/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiUIView;

public class TiUIDialog
extends TiUIView {
    private static final String LCAT = "TiUIDialog";
    private static final boolean DBG = TiConfig.LOGD;
    private static final int BUTTON_MASK = 0x10000000;
    protected AlertDialog.Builder builder;
    protected AlertDialog dialog;
    protected TiUIView view;

    public TiUIDialog(TiViewProxy proxy) {
        super(proxy);
        if (DBG) {
            Log.d((String)LCAT, (String)"Creating a dialog");
        }
        this.createBuilder();
    }

    private Activity getCurrentActivity() {
        Activity currentActivity = this.proxy.getTiContext().getTiApp().getCurrentActivity();
        if (currentActivity == null) {
            currentActivity = this.proxy.getTiContext().getActivity();
        }
        return currentActivity;
    }

    private AlertDialog.Builder getBuilder() {
        if (this.builder == null) {
            this.createBuilder();
        }
        return this.builder;
    }

    public void processProperties(KrollDict d) {
        if (d.containsKey((Object)"title")) {
            this.getBuilder().setTitle((CharSequence)d.getString("title"));
        }
        if (d.containsKey((Object)"message")) {
            this.getBuilder().setMessage((CharSequence)d.getString("message"));
        }
        if (d.containsKey((Object)"buttonNames")) {
            String[] buttonText = d.getStringArray("buttonNames");
            this.processButtons(buttonText);
        }
        if (d.containsKeyAndNotNull("androidView")) {
            this.processView((TiViewProxy)this.proxy.getProperty("androidView"));
        } else if (d.containsKey((Object)"options")) {
            int selectedIndex;
            String[] optionText = d.getStringArray("options");
            int n = selectedIndex = d.containsKey((Object)"selectedIndex") ? d.getInt("selectedIndex") : -1;
            if (selectedIndex >= optionText.length) {
                if (DBG) {
                    Log.d((String)LCAT, (String)("Ooops invalid selected index specified: " + selectedIndex));
                }
                selectedIndex = -1;
            }
            this.processOptions(optionText, selectedIndex);
        }
        super.processProperties(d);
    }

    private void processOptions(String[] optionText, int selectedIndex) {
        this.getBuilder().setSingleChoiceItems((CharSequence[])optionText, selectedIndex, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                TiUIDialog.this.handleEvent(which);
                TiUIDialog.this.hide(null);
            }
        });
    }

    private void processButtons(String[] buttonText) {
        this.getBuilder().setPositiveButton(null, null);
        this.getBuilder().setNegativeButton(null, null);
        this.getBuilder().setNeutralButton(null, null);
        this.getBuilder().setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                dialog = null;
                if (TiUIDialog.this.view != null) {
                    TiUIDialog.this.view.getProxy().releaseViews();
                    TiUIDialog.this.view = null;
                }
            }
        });
        block5: for (int id = 0; id < buttonText.length; ++id) {
            String text = buttonText[id];
            ClickHandler clicker = new ClickHandler(id | 0x10000000);
            switch (id) {
                case 0: {
                    this.getBuilder().setPositiveButton((CharSequence)text, (DialogInterface.OnClickListener)clicker);
                    continue block5;
                }
                case 1: {
                    this.getBuilder().setNeutralButton((CharSequence)text, (DialogInterface.OnClickListener)clicker);
                    continue block5;
                }
                case 2: {
                    this.getBuilder().setNegativeButton((CharSequence)text, (DialogInterface.OnClickListener)clicker);
                    continue block5;
                }
                default: {
                    Log.e((String)LCAT, (String)"Only 3 buttons are supported");
                }
            }
        }
    }

    private void processView(TiViewProxy proxy) {
        if (proxy != null) {
            this.view = proxy.getView(this.getCurrentActivity());
            this.getBuilder().setView(this.view.getNativeView());
        }
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if (DBG) {
            Log.d((String)LCAT, (String)("Property: " + key + " old: " + oldValue + " new: " + newValue));
        }
        if (key.equals("title")) {
            if (this.dialog != null) {
                this.dialog.setTitle((CharSequence)((String)newValue));
            }
        } else if (key.equals("message")) {
            if (this.dialog != null) {
                this.dialog.setMessage((CharSequence)((String)newValue));
            }
        } else if (key.equals("buttonNames")) {
            if (this.dialog != null) {
                this.dialog.dismiss();
                this.dialog = null;
            }
            this.processButtons(TiConvert.toStringArray((Object[])((Object[])newValue)));
        } else if (key.equals("options")) {
            if (this.dialog != null) {
                this.dialog.dismiss();
                this.dialog = null;
            }
            this.getBuilder().setView(null);
            int selectedIndex = -1;
            if (proxy.hasProperty("selectedIndex")) {
                selectedIndex = TiConvert.toInt((Object)proxy.getProperty("selectedIndex"));
            }
            this.processOptions(TiConvert.toStringArray((Object[])((Object[])newValue)), selectedIndex);
        } else if (key.equals("selectedIndex")) {
            if (this.dialog != null) {
                this.dialog.dismiss();
                this.dialog = null;
            }
            this.getBuilder().setView(null);
            if (proxy.hasProperty("options")) {
                this.processOptions(TiConvert.toStringArray((Object[])((Object[])proxy.getProperty("options"))), TiConvert.toInt((Object)newValue));
            }
        } else if (key.equals("androidView")) {
            if (this.dialog != null) {
                this.dialog.dismiss();
                this.dialog = null;
            }
            if (newValue != null) {
                this.processView((TiViewProxy)newValue);
            } else {
                proxy.setProperty("androidView", null, false);
            }
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
    }

    public void show(KrollDict options) {
        if (this.dialog == null) {
            this.processProperties(this.proxy.getProperties());
            this.getBuilder().setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dlg) {
                    int cancelIndex;
                    int n = cancelIndex = TiUIDialog.this.proxy.hasProperty("cancel") ? TiConvert.toInt((Object)TiUIDialog.this.proxy.getProperty("cancel")) : -1;
                    if (DBG) {
                        Log.d((String)TiUIDialog.LCAT, (String)("onCancelListener called. Sending index: " + cancelIndex));
                    }
                    TiUIDialog.this.handleEvent(cancelIndex);
                    TiUIDialog.this.hide(null);
                }
            });
            this.dialog = this.getBuilder().create();
            this.builder = null;
        }
        try {
            this.dialog.show();
        }
        catch (Throwable t) {
            Log.w((String)LCAT, (String)("Context must have gone away: " + t.getMessage()), (Throwable)t);
        }
    }

    public void hide(KrollDict options) {
        if (this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
        if (this.view != null) {
            this.view.getProxy().releaseViews();
            this.view = null;
        }
    }

    private void createBuilder() {
        Activity currentActivity = this.getCurrentActivity();
        this.builder = new AlertDialog.Builder((Context)currentActivity);
        this.builder.setCancelable(true);
    }

    public void handleEvent(int id) {
        int cancelIndex = this.proxy.hasProperty("cancel") ? TiConvert.toInt((Object)this.proxy.getProperty("cancel")) : -1;
        KrollDict data = new KrollDict();
        if ((id & 0x10000000) != 0) {
            data.put((Object)"button", (Object)true);
            id &= 0xEFFFFFFF;
        } else {
            data.put((Object)"button", (Object)false);
            if (this.proxy.hasProperty("options")) {
                this.proxy.setProperty("selectedIndex", (Object)id, false);
            }
        }
        data.put((Object)"index", (Object)id);
        data.put((Object)"cancel", (Object)(id == cancelIndex ? 1 : 0));
        this.proxy.fireEvent("click", data);
    }

    protected class ClickHandler
    implements DialogInterface.OnClickListener {
        private int result;

        public ClickHandler(int id) {
            this.result = id;
        }

        public void onClick(DialogInterface dialog, int which) {
            TiUIDialog.this.handleEvent(this.result);
            TiUIDialog.this.hide(null);
        }
    }
}

