/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.graphics.Bitmap;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import java.io.IOException;
import java.io.InputStream;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.io.TiFileFactory;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiUIHelper;
import org.appcelerator.titanium.view.TiUIView;

public class TiUIButton
extends TiUIView {
    private static final String LCAT = "TiUIButton";
    private static final boolean DBG = TiConfig.LOGD;

    public TiUIButton(TiViewProxy proxy) {
        super(proxy);
        if (DBG) {
            Log.d((String)LCAT, (String)"Creating a button");
        }
        Button btn = new Button(proxy.getContext());
        btn.setPadding(8, 0, 8, 0);
        btn.setGravity(17);
        this.setNativeView((View)btn);
    }

    public void processProperties(KrollDict d) {
        Object value;
        super.processProperties(d);
        Button btn = (Button)this.getNativeView();
        if (d.containsKey((Object)"image") && (value = d.get((Object)"image")) instanceof String) {
            try {
                String url = this.getProxy().getTiContext().resolveUrl(null, (String)value);
                TiBaseFile file = TiFileFactory.createTitaniumFile((TiContext)this.getProxy().getTiContext(), (String[])new String[]{url}, (boolean)false);
                Bitmap bitmap = TiUIHelper.createBitmap((InputStream)file.getInputStream());
                btn.setBackgroundDrawable((Drawable)new BitmapDrawable(bitmap));
            }
            catch (IOException e) {
                Log.e((String)LCAT, (String)"Error setting button image", (Throwable)e);
            }
        }
        if (d.containsKey((Object)"title")) {
            btn.setText((CharSequence)d.getString("title"));
        }
        if (d.containsKey((Object)"color")) {
            btn.setTextColor(TiConvert.toColor((KrollDict)d, (String)"color"));
        }
        if (d.containsKey((Object)"font")) {
            TiUIHelper.styleText((TextView)btn, (KrollDict)d.getKrollDict("font"));
        }
        if (d.containsKey((Object)"textAlign")) {
            String textAlign = d.getString("textAlign");
            TiUIHelper.setAlignment((TextView)btn, (String)textAlign, null);
        }
        if (d.containsKey((Object)"verticalAlign")) {
            String verticalAlign = d.getString("verticalAlign");
            TiUIHelper.setAlignment((TextView)btn, null, (String)verticalAlign);
        }
        btn.invalidate();
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if (DBG) {
            Log.d((String)LCAT, (String)("Property: " + key + " old: " + oldValue + " new: " + newValue));
        }
        Button btn = (Button)this.getNativeView();
        if (key.equals("title")) {
            btn.setText((CharSequence)((String)newValue));
        } else if (key.equals("color")) {
            btn.setTextColor(TiConvert.toColor((String)TiConvert.toString((Object)newValue)));
        } else if (key.equals("font")) {
            TiUIHelper.styleText((TextView)btn, (KrollDict)((KrollDict)newValue));
        } else if (key.equals("textAlign")) {
            TiUIHelper.setAlignment((TextView)btn, (String)TiConvert.toString((Object)newValue), null);
            btn.requestLayout();
        } else if (key.equals("verticalAlign")) {
            TiUIHelper.setAlignment((TextView)btn, null, (String)TiConvert.toString((Object)newValue));
            btn.requestLayout();
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
    }

    public void setOpacity(float opacity) {
        TiUIHelper.setPaintOpacity((Paint)((Button)this.getNativeView()).getPaint(), (float)opacity);
        super.setOpacity(opacity);
    }

    public void clearOpacity(View view) {
        super.clearOpacity(view);
        ((Button)this.getNativeView()).getPaint().setColorFilter(null);
    }
}

