/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiUIView;

public class TiUIActivityIndicator
extends TiUIView
implements Handler.Callback {
    private static final String LCAT = "TiUIActivityIndicator";
    private static final boolean DBG = TiConfig.LOGD;
    private static final int MSG_SHOW = 100;
    private static final int MSG_PROGRESS = 101;
    private static final int MSG_HIDE = 102;
    public static final int INDETERMINANT = 0;
    public static final int DETERMINANT = 1;
    public static final int STATUS_BAR = 0;
    public static final int DIALOG = 1;
    protected Handler handler;
    protected boolean visible;
    protected ProgressDialog progressDialog;
    protected String statusBarTitle;
    protected int incrementFactor;
    protected int location;
    protected int min;
    protected int max;
    protected int type;

    public TiUIActivityIndicator(TiViewProxy proxy) {
        super(proxy);
        if (DBG) {
            Log.d((String)LCAT, (String)"Creating an activity indicator");
        }
        this.handler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                this.handleShow();
                return true;
            }
            case 101: {
                if (this.progressDialog != null) {
                    this.progressDialog.setProgress(msg.arg1);
                } else {
                    Activity parent = (Activity)this.proxy.getContext();
                    parent.setProgress(msg.arg1);
                }
                return true;
            }
            case 102: {
                this.handleHide();
                return true;
            }
        }
        return false;
    }

    public void processProperties(KrollDict d) {
        super.processProperties(d);
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if (DBG) {
            Log.d((String)LCAT, (String)("Property: " + key + " old: " + oldValue + " new: " + newValue));
        }
        if (key.equals("message")) {
            if (this.visible) {
                if (this.progressDialog != null) {
                    this.progressDialog.setMessage((CharSequence)((String)newValue));
                } else {
                    Activity parent = (Activity)this.proxy.getContext();
                    parent.setTitle((CharSequence)((String)newValue));
                }
            }
        } else if (key.equals("value")) {
            if (this.visible) {
                int value = TiConvert.toInt((Object)newValue);
                int thePos = (value - this.min) * this.incrementFactor;
                this.handler.obtainMessage(101, thePos, -1).sendToTarget();
            }
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
    }

    public void show(KrollDict options) {
        if (this.visible) {
            return;
        }
        this.handleShow();
    }

    protected void handleShow() {
        KrollDict d = this.proxy.getProperties();
        String message = "";
        if (d.containsKey((Object)"message")) {
            message = d.getString("message");
        }
        this.location = 1;
        if (d.containsKey((Object)"location")) {
            this.location = TiConvert.toInt((KrollDict)d, (String)"location");
        }
        this.min = 0;
        if (d.containsKey((Object)"min")) {
            this.min = TiConvert.toInt((KrollDict)d, (String)"min");
        }
        this.max = 100;
        if (d.containsKey((Object)"max")) {
            this.max = TiConvert.toInt((KrollDict)d, (String)"max");
        }
        this.type = 0;
        if (d.containsKey((Object)"type")) {
            this.type = TiConvert.toInt((KrollDict)d, (String)"type");
        }
        if (this.location == 0) {
            this.incrementFactor = 10000 / (this.max - this.min);
            Activity parent = (Activity)this.proxy.getContext();
            if (this.type == 0) {
                parent.setProgressBarIndeterminate(true);
                parent.setProgressBarIndeterminateVisibility(true);
                this.statusBarTitle = ((Object)parent.getTitle()).toString();
                parent.setTitle((CharSequence)message);
            } else if (this.type == 1) {
                parent.setProgressBarIndeterminate(false);
                parent.setProgressBarIndeterminateVisibility(false);
                parent.setProgressBarVisibility(true);
                this.statusBarTitle = ((Object)parent.getTitle()).toString();
                parent.setTitle((CharSequence)message);
            } else {
                Log.w((String)LCAT, (String)("Unknown type: " + this.type));
            }
        } else if (this.location == 1) {
            this.incrementFactor = 1;
            if (this.progressDialog == null) {
                Activity a = this.proxy.getTiContext().getTiApp().getCurrentActivity();
                if (a == null) {
                    a = this.proxy.getTiContext().getRootActivity();
                }
                this.progressDialog = new ProgressDialog((Context)a);
            }
            this.progressDialog.setMessage((CharSequence)message);
            this.progressDialog.setCancelable(false);
            if (this.type == 0) {
                this.progressDialog.setIndeterminate(true);
            } else if (this.type == 1) {
                this.progressDialog.setIndeterminate(false);
                this.progressDialog.setProgressStyle(1);
                if (this.min != 0) {
                    this.progressDialog.setMax(this.max - this.min);
                } else {
                    this.progressDialog.setMax(this.max);
                }
                this.progressDialog.setProgress(0);
            } else {
                Log.w((String)LCAT, (String)("Unknown type: " + this.type));
            }
            this.progressDialog.show();
        } else {
            Log.w((String)LCAT, (String)("Unknown location: " + this.location));
        }
        this.visible = true;
    }

    public void hide(KrollDict options) {
        if (!this.visible) {
            return;
        }
        this.handler.sendEmptyMessage(102);
    }

    protected void handleHide() {
        if (this.progressDialog != null) {
            this.progressDialog.dismiss();
            this.progressDialog = null;
        } else {
            Activity parent = (Activity)this.proxy.getContext();
            parent.setProgressBarIndeterminate(false);
            parent.setProgressBarIndeterminateVisibility(false);
            parent.setProgressBarVisibility(false);
            parent.setTitle((CharSequence)this.statusBarTitle);
            this.statusBarTitle = null;
        }
        this.visible = false;
    }
}

