/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.content.Context;
import android.os.Handler;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.ViewAnimator;
import java.util.ArrayList;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiAnimationFactory;
import org.appcelerator.titanium.util.TiAnimationPair;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiEventHelper;
import org.appcelerator.titanium.view.TiCompositeLayout;
import ti.modules.titanium.ui.ScrollableViewProxy;
import ti.modules.titanium.ui.widget.TiArrowView;

public class TiScrollableView
extends TiCompositeLayout {
    private static final String LCAT = "TiUIScrollableView";
    private static final boolean DBG = TiConfig.LOGD;
    private static final int ANIM_DURATION = 250;
    private static final int PAGE_LEFT = 200;
    private static final int PAGE_RIGHT = 201;
    protected RelativeLayout pager;
    protected GestureDetector detector;
    protected boolean showPagingControl;
    protected ViewAnimator gallery;
    protected TiAnimationPair animPrev;
    protected TiAnimationPair animNext;
    protected final TiScrollableView me;
    protected ArrayList<TiViewProxy> views;
    protected ScrollableViewProxy proxy;
    protected Handler handler;

    public TiScrollableView(ScrollableViewProxy proxy, Handler handler) {
        super(proxy.getContext());
        this.proxy = proxy;
        this.handler = handler;
        this.me = this;
        this.showPagingControl = true;
        this.views = new ArrayList();
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setDescendantFocusability(262144);
        this.animPrev = TiAnimationFactory.getAnimationFor((String)"slide-from-left", (int)250);
        this.animPrev.setAnimationListener((Animation.AnimationListener)proxy);
        this.animNext = TiAnimationFactory.getAnimationFor((String)"slide-from-right", (int)250);
        this.animNext.setAnimationListener((Animation.AnimationListener)proxy);
        this.gallery = new ViewAnimator(proxy.getContext());
        this.gallery.setFocusable(false);
        this.gallery.setFocusableInTouchMode(false);
        this.gallery.setClickable(false);
        TiCompositeLayout.LayoutParams p = new TiCompositeLayout.LayoutParams();
        p.autoFillsHeight = true;
        p.autoFillsWidth = true;
        this.addView((View)this.gallery, (ViewGroup.LayoutParams)p);
        this.pager = new RelativeLayout(proxy.getContext());
        this.pager.setFocusable(false);
        this.pager.setFocusableInTouchMode(false);
        TiArrowView left = new TiArrowView(proxy.getContext());
        left.setVisibility(4);
        left.setId(200);
        left.setMinimumWidth(80);
        left.setMinimumHeight(80);
        left.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TiScrollableView.this.doMovePrevious();
            }
        });
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(9);
        params.addRule(15);
        this.pager.addView((View)left, (ViewGroup.LayoutParams)params);
        TiArrowView right = new TiArrowView(proxy.getContext());
        right.setLeft(false);
        right.setVisibility(4);
        right.setId(201);
        right.setMinimumWidth(80);
        right.setMinimumHeight(80);
        right.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TiScrollableView.this.proxy.moveNext();
            }
        });
        params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(11);
        params.addRule(15);
        this.pager.addView((View)right, (ViewGroup.LayoutParams)params);
        this.pager.setVisibility(8);
        p = new TiCompositeLayout.LayoutParams();
        p.autoFillsHeight = true;
        p.autoFillsWidth = true;
        this.addView((View)this.pager, (ViewGroup.LayoutParams)p);
        this.detector = new GestureDetector(new GestureDetector.OnGestureListener(){

            public boolean onDown(MotionEvent arg0) {
                return true;
            }

            public boolean onFling(MotionEvent me1, MotionEvent me2, float velocityX, float velocityY) {
                if (Math.abs(me2.getY() - me1.getY()) > 100.0f) {
                    return false;
                }
                if (DBG) {
                    Log.e((String)TiScrollableView.LCAT, (String)"FLING IT");
                }
                if (me1.getX() > me2.getX()) {
                    TiScrollableView.this.doMoveNext();
                } else {
                    TiScrollableView.this.doMovePrevious();
                }
                return true;
            }

            public void onLongPress(MotionEvent arg0) {
            }

            public boolean onScroll(MotionEvent arg0, MotionEvent arg1, float arg2, float arg3) {
                return false;
            }

            public void onShowPress(MotionEvent arg0) {
            }

            public boolean onSingleTapUp(MotionEvent arg0) {
                return false;
            }
        });
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        boolean handled = false;
        handled = this.detector.onTouchEvent(ev);
        if (!handled || handled && ev.getAction() == 0) {
            handled = super.dispatchTouchEvent(ev);
        }
        return handled;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean handled = this.detector.onTouchEvent(event);
        if (event.getAction() == 0 && this.showPagingControl && this.pager.getVisibility() != 0) {
            this.gallery.onTouchEvent(event);
        }
        if (!handled) {
            handled = super.onTouchEvent(event);
        }
        return handled;
    }

    public int getSelectedItemPosition() {
        return this.gallery.getDisplayedChild();
    }

    public boolean hasPrevious() {
        return this.getSelectedItemPosition() > 0;
    }

    public boolean hasNext() {
        return this.getSelectedItemPosition() < this.gallery.getChildCount() - 1;
    }

    public void doMovePrevious() {
        int pos = this.getSelectedItemPosition();
        if (pos > 0) {
            int from = pos;
            int to = pos - 1;
            TiEventHelper.fireFocused((TiViewProxy)this.views.get(from));
            final ViewWrapper fromWrapper = (ViewWrapper)this.gallery.getChildAt(from);
            ViewWrapper toWrapper = (ViewWrapper)this.gallery.getChildAt(to);
            this.animPrev.apply(this.gallery);
            this.animPrev.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationEnd(Animation arg0) {
                    fromWrapper.doDetachView();
                }

                public void onAnimationRepeat(Animation arg0) {
                }

                public void onAnimationStart(Animation arg0) {
                }
            });
            toWrapper.doAttachView();
            this.gallery.setDisplayedChild(to);
            TiEventHelper.fireUnfocused((TiViewProxy)this.views.get(to));
            this.onScrolled(from, to);
            if (this.showPagingControl) {
                this.showPager();
            }
        }
    }

    public void doMoveNext() {
        int pos = this.getSelectedItemPosition();
        if (pos < this.gallery.getChildCount() - 1) {
            int from = pos;
            int to = pos + 1;
            TiEventHelper.fireFocused((TiViewProxy)this.views.get(from));
            final ViewWrapper fromWrapper = (ViewWrapper)this.gallery.getChildAt(from);
            ViewWrapper toWrapper = (ViewWrapper)this.gallery.getChildAt(to);
            toWrapper.doAttachView();
            this.animNext.apply(this.gallery);
            this.animNext.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationEnd(Animation arg0) {
                    fromWrapper.doDetachView();
                }

                public void onAnimationRepeat(Animation arg0) {
                }

                public void onAnimationStart(Animation arg0) {
                }
            });
            this.gallery.setDisplayedChild(to);
            TiEventHelper.fireUnfocused((TiViewProxy)this.views.get(to));
            this.onScrolled(from, to);
            if (this.showPagingControl) {
                this.showPager();
            }
        }
    }

    public void showPager() {
        View v = null;
        v = this.findViewById(200);
        if (v != null) {
            v.setVisibility(this.hasPrevious() ? 0 : 4);
        }
        if ((v = this.findViewById(201)) != null) {
            v.setVisibility(this.hasNext() ? 0 : 4);
        }
        this.pager.setVisibility(0);
        this.proxy.setPagerTimeout();
    }

    public void hidePager() {
        this.pager.setVisibility(4);
    }

    public void setViews(Object viewsObject) {
        int i;
        if (DBG) {
            Log.d((String)LCAT, (String)("Views: " + viewsObject));
        }
        if (this.views != null) {
            int len = this.gallery.getChildCount();
            for (i = 0; i < len; ++i) {
                ((ViewWrapper)this.gallery.getChildAt(i)).doDetachView();
            }
            this.views.clear();
        } else {
            this.views = new ArrayList();
        }
        if (viewsObject instanceof Object[]) {
            Object[] views = (Object[])viewsObject;
            this.gallery.removeAllViews();
            for (i = 0; i < views.length; ++i) {
                if (!(views[i] instanceof TiViewProxy)) continue;
                TiViewProxy tv = (TiViewProxy)views[i];
                this.views.add(tv);
                this.gallery.addView((View)new ViewWrapper(this.getContext(), i));
            }
            if (views.length > 0) {
                ((ViewWrapper)this.gallery.getChildAt(0)).doAttachView();
                ((TiViewProxy)views[0]).show(new KrollDict());
            }
        }
    }

    public void addView(TiViewProxy proxy) {
        if (proxy != null) {
            this.views.add(proxy);
            this.gallery.addView((View)new ViewWrapper(this.getContext(), this.gallery.getChildCount()));
        }
    }

    public void removeView(TiViewProxy proxy) {
        if (proxy != null) {
            int index = this.views.indexOf(proxy);
            this.views.remove(proxy);
            if (index == -1) {
                if (DBG) {
                    Log.d((String)LCAT, (String)"removeView -- view not located.");
                }
            } else {
                this.gallery.removeViewAt(index);
                for (int i = index; i < this.gallery.getChildCount(); ++i) {
                    ((ViewWrapper)this.gallery.getChildAt(i)).position = i;
                }
            }
        }
    }

    public void setShowPagingControl(boolean showPagingControl) {
        this.showPagingControl = showPagingControl;
    }

    public void doScrollToView(int position) {
        block2: {
            int current;
            block3: {
                if (position >= this.gallery.getChildCount()) break block2;
                current = this.getSelectedItemPosition();
                if (current >= position) break block3;
                while (this.getSelectedItemPosition() < position) {
                    this.doMoveNext();
                }
                break block2;
            }
            if (current <= position) break block2;
            while (this.getSelectedItemPosition() > position) {
                this.doMovePrevious();
            }
        }
    }

    public void doScrollToView(TiViewProxy view) {
        if (this.views.contains(view)) {
            this.doScrollToView(this.views.indexOf(view));
        }
    }

    public void doSetCurrentPage(int position) {
        if (position < this.gallery.getChildCount()) {
            int from = this.getSelectedItemPosition();
            ViewWrapper fromWrapper = (ViewWrapper)this.gallery.getChildAt(from);
            ViewWrapper toWrapper = (ViewWrapper)this.gallery.getChildAt(position);
            if (toWrapper != null) {
                toWrapper.doAttachView();
                this.gallery.setInAnimation(null);
                this.gallery.setOutAnimation(null);
                this.gallery.setDisplayedChild(position);
                this.proxy.setProperty("currentPage", position);
                this.proxy.fireScroll(position);
                if (fromWrapper != null && fromWrapper != toWrapper) {
                    fromWrapper.doDetachView();
                }
                if (this.showPagingControl) {
                    this.showPager();
                }
            }
        }
    }

    public void doSetCurrentPage(TiViewProxy view) {
        if (this.views.contains(view)) {
            this.doSetCurrentPage(this.views.indexOf(view));
        }
    }

    public ArrayList<TiViewProxy> getViews() {
        return this.views;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean handled = false;
        if (event.getAction() == 0) {
            switch (event.getKeyCode()) {
                case 21: {
                    this.proxy.movePrevious();
                    handled = true;
                    break;
                }
                case 22: {
                    this.proxy.moveNext();
                    handled = true;
                }
            }
        }
        if (!handled) {
            handled = super.dispatchKeyEvent(event);
        }
        return handled;
    }

    public boolean dispatchTrackballEvent(MotionEvent event) {
        boolean handled = false;
        if (this.showPagingControl) {
            if (this.pager.getVisibility() != 0) {
                this.handler.sendEmptyMessage(2100);
            }
            this.proxy.setPagerTimeout();
        }
        handled = super.dispatchTrackballEvent(event);
        return handled;
    }

    public void onScrolled(int from, int to) {
        View v = null;
        this.proxy.fireScroll(to);
        v = this.findViewById(200);
        if (v != null) {
            v.setVisibility(this.hasPrevious() ? 0 : 4);
        }
        if ((v = this.findViewById(201)) != null) {
            v.setVisibility(this.hasNext() ? 0 : 4);
        }
        this.proxy.setProperty("currentPage", to);
    }

    public void onNothingSelected(AdapterView<?> view) {
    }

    class ViewWrapper
    extends FrameLayout {
        private int position;
        private View view;

        public ViewWrapper(Context context, int position) {
            super(context);
            this.position = position;
        }

        public void doAttachView() {
            if (this.view == null) {
                this.view = TiScrollableView.this.views.get(this.position).getView(null).getNativeView();
                this.addView(this.view);
                if (this.getChildCount() > 2) {
                    Log.e((String)TiScrollableView.LCAT, (String)("----------------------- CHILD COUNT: " + this.getChildCount()));
                }
            }
        }

        public void doDetachView() {
            if (this.view != null) {
                this.removeView(this.view);
                this.view = null;
                TiScrollableView.this.views.get(this.position).releaseViews();
            }
        }
    }
}

