/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ZoomControls;
import java.lang.ref.SoftReference;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;

public class TiImageView
extends ViewGroup
implements Handler.Callback,
View.OnClickListener {
    private static final String LCAT = "TiImageView";
    private static final boolean DBG = TiConfig.LOGD;
    private static final int CONTROL_TIMEOUT = 4000;
    private static final int MSG_HIDE_CONTROLS = 500;
    private Handler handler;
    private View.OnClickListener clickListener;
    private boolean canScaleImage;
    private boolean enableZoomControls;
    private GestureDetector gestureDetector;
    private ImageView imageView;
    private ZoomControls zoomControls;
    private float scaleFactor;
    private float originalScaleFactor;
    private float scaleIncrement;
    private float scaleMin;
    private float scaleMax;
    private Matrix baseMatrix;
    private Matrix changeMatrix;

    public TiImageView(Context context) {
        super(context);
        final TiImageView me = this;
        this.handler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        this.canScaleImage = false;
        this.enableZoomControls = true;
        this.originalScaleFactor = this.scaleFactor = 1.0f;
        this.scaleIncrement = 0.1f;
        this.scaleMin = 1.0f;
        this.scaleMax = 5.0f;
        this.baseMatrix = new Matrix();
        this.changeMatrix = new Matrix();
        this.imageView = new NoLayoutImageView(context);
        this.addView((View)this.imageView);
        this.setCanScaleImage(false);
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDown(MotionEvent e) {
                if (TiImageView.this.zoomControls.getVisibility() == 0) {
                    super.onDown(e);
                    return true;
                }
                TiImageView.this.onClick((View)me);
                return false;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float dx, float dy) {
                if (TiImageView.this.zoomControls.getVisibility() == 0) {
                    TiImageView.this.changeMatrix.postTranslate(-dx, -dy);
                    TiImageView.this.imageView.setImageMatrix(TiImageView.this.getViewMatrix());
                    TiImageView.this.requestLayout();
                    TiImageView.this.scheduleControlTimeout();
                    return true;
                }
                return false;
            }

            public boolean onSingleTapConfirmed(MotionEvent e) {
                TiImageView.this.onClick((View)me);
                return super.onSingleTapConfirmed(e);
            }
        });
        this.gestureDetector.setIsLongpressEnabled(false);
        this.zoomControls = new ZoomControls(context);
        this.addView((View)this.zoomControls);
        this.zoomControls.setVisibility(8);
        this.zoomControls.setZoomSpeed(75L);
        this.zoomControls.setOnZoomInClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TiImageView.this.handleScaleUp();
            }
        });
        this.zoomControls.setOnZoomOutClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TiImageView.this.handleScaleDown();
            }
        });
        super.setOnClickListener((View.OnClickListener)this);
    }

    public void setOnSizeChangeListener(OnSizeChangeListener listener) {
        if (this.imageView != null) {
            ((NoLayoutImageView)this.imageView).setOnSizeChangeListener(listener);
        }
    }

    public void setCanScaleImage(boolean canScaleImage) {
        this.canScaleImage = canScaleImage;
        if (canScaleImage) {
            this.imageView.setAdjustViewBounds(true);
            if (Integer.parseInt(Build.VERSION.SDK) > 3) {
                this.imageView.setScaleType(ImageView.ScaleType.MATRIX);
            } else {
                this.imageView.setScaleType(ImageView.ScaleType.CENTER);
            }
        } else {
            this.imageView.setScaleType(ImageView.ScaleType.CENTER);
        }
        ((NoLayoutImageView)this.imageView).allowLayoutRequest = true;
        this.requestLayout();
    }

    public void setEnableZoomControls(boolean enableZoomControls) {
        this.enableZoomControls = enableZoomControls;
    }

    public void setImageDrawable(Drawable d) {
        this.setImageDrawable(d, true);
    }

    public void setImageDrawable(Drawable d, boolean recycle) {
        Drawable od = this.imageView.getDrawable();
        if (od != null) {
            od.setCallback(null);
            if (od instanceof BitmapDrawable && recycle) {
                ((BitmapDrawable)od).getBitmap().recycle();
            }
        }
        this.imageView.setImageDrawable(d);
        this.scaleFactor = this.originalScaleFactor;
        this.updateChangeMatrix(0.0f);
        this.setCanScaleImage(this.canScaleImage);
    }

    public Drawable getImageDrawable() {
        return this.imageView.getDrawable();
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.imageView.setImageBitmap(bitmap);
    }

    public void setOnClickListener(View.OnClickListener clickListener) {
        this.clickListener = clickListener;
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 500: {
                this.handleHideControls();
                return true;
            }
        }
        return false;
    }

    public void onClick(View view) {
        boolean sendClick = true;
        if (this.canScaleImage && this.enableZoomControls) {
            if (this.zoomControls.getVisibility() != 0) {
                sendClick = false;
                this.manageControls();
                this.zoomControls.setVisibility(0);
            }
            this.scheduleControlTimeout();
        }
        if (sendClick && this.clickListener != null) {
            this.clickListener.onClick(view);
        }
    }

    private void handleScaleUp() {
        if (this.scaleFactor < this.scaleMax) {
            this.onViewChanged(this.scaleIncrement);
        }
    }

    private void handleScaleDown() {
        if (this.scaleFactor > this.scaleMin) {
            this.onViewChanged(-this.scaleIncrement);
        }
    }

    private void handleHideControls() {
        this.zoomControls.setVisibility(8);
    }

    private void manageControls() {
        if (this.scaleFactor == this.scaleMax) {
            this.zoomControls.setIsZoomInEnabled(false);
        } else {
            this.zoomControls.setIsZoomInEnabled(true);
        }
        if (this.scaleFactor == this.scaleMin) {
            this.zoomControls.setIsZoomOutEnabled(false);
        } else {
            this.zoomControls.setIsZoomOutEnabled(true);
        }
    }

    private void onViewChanged(float dscale) {
        this.updateChangeMatrix(dscale);
        this.manageControls();
        this.requestLayout();
        this.scheduleControlTimeout();
    }

    private void computeBaseMatrix() {
        Drawable d = this.imageView.getDrawable();
        this.baseMatrix.reset();
        if (d != null) {
            Rect r = new Rect();
            this.getDrawingRect(r);
            int dwidth = d.getIntrinsicWidth();
            int dheight = d.getIntrinsicHeight();
            float vwidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
            float vheight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            float widthScale = Math.min(vwidth / (float)dwidth, 1.0f);
            float heightScale = Math.min(vheight / (float)dheight, 1.0f);
            float scale = Math.min(widthScale, heightScale);
            this.baseMatrix.setScale(scale, scale);
            float dx = (vwidth - (float)dwidth * scale) * 0.5f;
            float dy = (vheight - (float)dheight * scale) * 0.5f;
            this.baseMatrix.postTranslate(dx, dy);
        }
    }

    private void updateChangeMatrix(float dscale) {
        this.changeMatrix.reset();
        this.scaleFactor += dscale;
        this.scaleFactor = Math.max(this.scaleFactor, this.scaleMin);
        this.scaleFactor = Math.min(this.scaleFactor, this.scaleMax);
        this.changeMatrix.postScale(this.scaleFactor, this.scaleFactor, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
    }

    private Matrix getViewMatrix() {
        Matrix m = new Matrix(this.baseMatrix);
        m.postConcat(this.changeMatrix);
        return m;
    }

    private void scheduleControlTimeout() {
        this.handler.removeMessages(500);
        this.handler.sendEmptyMessageDelayed(500, 4000L);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        boolean handled = false;
        if (this.canScaleImage) {
            if (this.zoomControls.getVisibility() == 0) {
                this.zoomControls.onTouchEvent(ev);
            }
            handled = this.gestureDetector.onTouchEvent(ev);
        }
        if (!handled) {
            handled = super.onTouchEvent(ev);
        }
        return handled;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int maxWidth = 0;
        int maxHeight = 0;
        this.measureChild((View)this.imageView, widthMeasureSpec, heightMeasureSpec);
        maxWidth = Math.max(maxWidth, this.imageView.getMeasuredWidth());
        maxHeight = Math.max(maxHeight, this.imageView.getMeasuredHeight());
        if (this.canScaleImage) {
            this.measureChild((View)this.zoomControls, widthMeasureSpec, heightMeasureSpec);
            maxWidth = Math.max(maxWidth, this.zoomControls.getMeasuredWidth());
            maxHeight = Math.max(maxHeight, this.zoomControls.getMeasuredHeight());
        }
        this.setMeasuredDimension(TiImageView.resolveSize((int)maxWidth, (int)widthMeasureSpec), TiImageView.resolveSize((int)maxHeight, (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.computeBaseMatrix();
        this.imageView.setImageMatrix(this.getViewMatrix());
        int parentLeft = 0;
        int parentRight = right - left;
        int parentTop = 0;
        int parentBottom = bottom - top;
        this.imageView.layout(parentLeft, parentTop, parentRight, parentBottom);
        if (this.canScaleImage && this.zoomControls.getVisibility() == 0) {
            int zoomWidth = this.zoomControls.getMeasuredWidth();
            int zoomHeight = this.zoomControls.getMeasuredHeight();
            this.zoomControls.layout(parentRight - zoomWidth, parentBottom - zoomHeight, parentRight, parentBottom);
        }
    }

    public void setColorFilter(ColorFilter filter) {
        this.imageView.setColorFilter(filter);
    }

    public class NoLayoutImageView
    extends ImageView {
        public boolean allowLayoutRequest;
        public SoftReference<OnSizeChangeListener> listener;

        public NoLayoutImageView(Context context) {
            super(context);
            this.allowLayoutRequest = true;
        }

        public void requestLayout() {
            if (this.allowLayoutRequest) {
                super.requestLayout();
                this.allowLayoutRequest = false;
            }
        }

        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            OnSizeChangeListener l;
            super.onSizeChanged(w, h, oldw, oldh);
            if (DBG) {
                Log.d((String)TiImageView.LCAT, (String)("ImageView size change: w: " + w + " h: " + h + " oldw: " + oldw + " oldh: " + oldh));
            }
            if (this.listener != null && (l = this.listener.get()) != null) {
                l.sizeChanged(w, h, oldw, oldh);
            }
        }

        public void setOnSizeChangeListener(OnSizeChangeListener listener) {
            if (listener != null) {
                this.listener = new SoftReference<OnSizeChangeListener>(listener);
            } else {
                listener = null;
            }
        }

        public OnSizeChangeListener getOnSizeChangeListener() {
            if (this.listener != null) {
                return this.listener.get();
            }
            return null;
        }
    }

    public static interface OnSizeChangeListener {
        public void sizeChanged(int var1, int var2, int var3, int var4);
    }
}

