/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.view.View;

public class TiArrowView
extends View {
    private boolean leftArrow = true;
    private Path path;

    public TiArrowView(Context context) {
        super(context);
        this.setFocusable(false);
        this.setFocusableInTouchMode(false);
        this.configureDrawable();
    }

    public void setLeft(boolean leftArrow) {
        this.leftArrow = leftArrow;
        this.configureDrawable();
    }

    private void configureDrawable() {
        this.path = new Path();
        if (this.leftArrow) {
            this.path.moveTo(0.0f, 1.0f);
            this.path.lineTo(1.0f, 2.0f);
            this.path.lineTo(1.0f, 0.0f);
            this.path.close();
        } else {
            this.path.lineTo(1.0f, 1.0f);
            this.path.lineTo(0.0f, 2.0f);
            this.path.lineTo(0.0f, 0.0f);
            this.path.close();
        }
        this.setWillNotDraw(false);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.getSuggestedMinimumWidth(), this.getSuggestedMinimumHeight());
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.path != null) {
            int w = this.getWidth() / 2;
            int h = this.getHeight() / 2;
            canvas.save();
            canvas.scale((float)w, (float)h);
            if (!this.leftArrow) {
                canvas.translate(1.0f, 0.0f);
            }
            Paint p = new Paint();
            p.setAntiAlias(false);
            p.setARGB(175, 216, 216, 216);
            p.setStyle(Paint.Style.FILL);
            canvas.drawPath(this.path, p);
            p.setARGB(75, 0, 0, 0);
            p.setStrokeWidth(0.1f);
            p.setStrokeJoin(Paint.Join.ROUND);
            p.setStrokeCap(Paint.Cap.ROUND);
            p.setAntiAlias(true);
            p.setStyle(Paint.Style.STROKE);
            canvas.drawPath(this.path, p);
            canvas.restore();
        }
    }
}

