/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui.clipboard;

import android.text.ClipboardManager;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.titanium.TiContext;

public class ClipboardModule
extends KrollModule {
    public ClipboardModule(TiContext tiContext) {
        super(tiContext);
    }

    private ClipboardManager board() {
        return (ClipboardManager)this.getTiContext().getTiApp().getSystemService("clipboard");
    }

    private boolean isTextType(String type) {
        String mimeType = type.toLowerCase();
        return mimeType.equals("text/plain") || mimeType.startsWith("text");
    }

    public void clearData(String type) {
        this.clearText();
    }

    public void clearText() {
        this.board().setText((CharSequence)"");
    }

    public Object getData(String type) {
        if (this.isTextType(type)) {
            return this.getText();
        }
        return null;
    }

    public String getText() {
        return ((Object)this.board().getText()).toString();
    }

    public boolean hasData(String type) {
        if (type == null || this.isTextType(type)) {
            return this.hasText();
        }
        return false;
    }

    public boolean hasText() {
        return this.board().hasText();
    }

    public void setData(String type, Object data) {
        if (this.isTextType(type)) {
            data.toString();
        }
    }

    public void setText(String text) {
        this.board().setText((CharSequence)text);
    }
}

