/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui;

import android.app.Activity;
import android.content.Intent;
import android.os.Message;
import android.os.Messenger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.TiActivityWindow;
import org.appcelerator.titanium.TiActivityWindows;
import org.appcelerator.titanium.TiBaseActivity;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiMessageQueue;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.proxy.TiWindowProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.ButtonProxy;
import ti.modules.titanium.ui.TiUIWindow;

public class WindowProxy
extends TiWindowProxy {
    private static final String LCAT = "WindowProxy";
    private static final boolean DBG = TiConfig.LOGD;
    private static final int MSG_FIRST_ID = 2000;
    private static final int MSG_FINISH_OPEN = 2100;
    protected static final int MSG_LAST_ID = 2999;
    ArrayList<TiViewProxy> views;
    WeakReference<Activity> weakActivity;
    String windowId;

    public WindowProxy(TiContext tiContext) {
        super(tiContext);
    }

    protected KrollDict getLangConversionTable() {
        KrollDict table = new KrollDict();
        table.put((Object)"title", (Object)"titleid");
        table.put((Object)"titlePrompt", (Object)"titlepromptid");
        return table;
    }

    public TiUIView getView(Activity activity) {
        throw new IllegalStateException("call to getView on a Window");
    }

    protected TiUIWindow getWindow() {
        return (TiUIWindow)this.view;
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 2100: {
                this.realizeViews(this.getTiContext().getActivity(), this.view);
                if (this.tab == null) {
                    // empty if block
                }
                this.opened = true;
                this.handlePostOpen();
                this.fireEvent("open", null);
                return true;
            }
        }
        return super.handleMessage(msg);
    }

    protected void handleOpen(KrollDict options) {
        if (DBG) {
            Log.d((String)LCAT, (String)"handleOpen");
        }
        Messenger messenger = new Messenger(this.getUIHandler());
        this.view = new TiUIWindow(this, options, messenger, 2100);
    }

    public void fillIntentForTab(Intent intent) {
        intent.putExtra("useActivityWindow", true);
        int windowId = TiActivityWindows.addWindow((TiActivityWindow)new TiActivityWindow(){

            public void windowCreated(TiBaseActivity activity) {
                WindowProxy.this.view = new TiUIWindow(WindowProxy.this, (Activity)activity);
                WindowProxy.this.realizeViews(null, WindowProxy.this.view);
                WindowProxy.this.opened = true;
                WindowProxy.this.fireEvent("open", null);
                TiMessageQueue.getMainMessageQueue().stopBlocking();
            }
        });
        intent.putExtra("windowId", windowId);
    }

    protected void handleClose(KrollDict options) {
        if (DBG) {
            Log.d((String)LCAT, (String)"handleClose");
        }
        TiUIWindow window = this.getWindow();
        boolean isLightweight = false;
        if (window.lightWeight) {
            isLightweight = true;
        }
        if (window != null) {
            window.close(options);
        }
        this.releaseViews();
        if (isLightweight) {
            this.opened = false;
        }
    }

    public TiViewProxy getTab() {
        return this.tab;
    }

    public TiViewProxy getTabGroup() {
        return this.tabGroup;
    }

    public void setLeftNavButton(ButtonProxy button) {
        Log.w((String)LCAT, (String)"setLeftNavButton not supported in Android");
    }

    protected Activity handleGetActivity() {
        if (this.view == null) {
            return null;
        }
        return ((TiUIWindow)this.view).getActivity();
    }
}

