/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui;

import android.app.Activity;
import android.os.Handler;
import android.os.Message;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.AsyncResult;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.ViewProxy;
import ti.modules.titanium.ui.widget.webview.TiUIWebView;

public class WebViewProxy
extends ViewProxy
implements Handler.Callback {
    private static final int MSG_FIRST_ID = 2000;
    private static final int MSG_EVAL_JS = 2100;
    private static final int MSG_GO_BACK = 2101;
    private static final int MSG_GO_FORWARD = 2102;
    private static final int MSG_RELOAD = 2103;
    private static final int MSG_STOP_LOADING = 2104;
    protected static final int MSG_LAST_ID = 2999;

    public WebViewProxy(TiContext context) {
        super(context);
    }

    @Override
    public TiUIView createView(Activity activity) {
        TiUIWebView webView = new TiUIWebView(this);
        webView.focus();
        return webView;
    }

    public TiUIWebView getWebView() {
        return (TiUIWebView)this.getView(this.getTiContext().getActivity());
    }

    public Object evalJS(String code) {
        if (this.getTiContext().isUIThread()) {
            return this.getWebView().getJSValue(code);
        }
        return this.sendBlockingUiMessage(2100, code);
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 2100: {
                AsyncResult result = (AsyncResult)msg.obj;
                String value = this.getWebView().getJSValue((String)result.getArg());
                result.setResult((Object)value);
                return true;
            }
            case 2101: {
                this.getWebView().goBack();
                return true;
            }
            case 2102: {
                this.getWebView().goForward();
                return true;
            }
            case 2103: {
                this.getWebView().reload();
                return true;
            }
            case 2104: {
                this.getWebView().stopLoading();
                return true;
            }
        }
        return super.handleMessage(msg);
    }

    public void setBasicAuthentication(String username, String password) {
        this.getWebView().setBasicAuthentication(username, password);
    }

    public boolean canGoBack() {
        return this.getWebView().canGoBack();
    }

    public boolean canGoForward() {
        return this.getWebView().canGoForward();
    }

    public void goBack() {
        this.getUIHandler().sendEmptyMessage(2101);
    }

    public void goForward() {
        this.getUIHandler().sendEmptyMessage(2102);
    }

    public void reload() {
        this.getUIHandler().sendEmptyMessage(2103);
    }

    public void stopLoading() {
        this.getUIHandler().sendEmptyMessage(2104);
    }

    public void releaseViews() {
    }
}

