/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import android.view.Window;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.kroll.KrollProxyListener;
import org.appcelerator.titanium.TiActivity;
import org.appcelerator.titanium.TiActivityWindow;
import org.appcelerator.titanium.TiActivityWindows;
import org.appcelerator.titanium.TiBaseActivity;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiMessageQueue;
import org.appcelerator.titanium.TiModalActivity;
import org.appcelerator.titanium.TiTranslucentActivity;
import org.appcelerator.titanium.proxy.ActivityProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.proxy.TiWindowProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiBindingHelper;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiFileHelper;
import org.appcelerator.titanium.util.TiPropertyResolver;
import org.appcelerator.titanium.util.TiUIHelper;
import org.appcelerator.titanium.util.TiUrl;
import org.appcelerator.titanium.view.ITiWindowHandler;
import org.appcelerator.titanium.view.TiCompositeLayout;
import org.appcelerator.titanium.view.TiUIView;

public class TiUIWindow
extends TiUIView
implements Handler.Callback,
TiActivityWindow {
    private static final String LCAT = "TiUIWindow";
    private static final boolean DBG = TiConfig.LOGD;
    private static final int WINDOW_ZINDEX = 0x7FFFFFFD;
    private static final int MSG_ACTIVITY_CREATED = 1000;
    private static final int MSG_ANIMATE = 100;
    private static final int INTENT_FLAG_ACTIVITY_NO_ANIMATION = 65536;
    private static final String WINDOW_ID_PREFIX = "window$";
    protected String activityKey;
    protected Activity windowActivity;
    protected TiContext windowContext;
    protected String windowUrl;
    protected int windowId;
    protected TiCompositeLayout lightWindow;
    protected boolean lightWeight;
    protected boolean newActivity;
    protected boolean animate;
    protected boolean newContext = false;
    protected TiPropertyResolver resolver;
    protected Handler handler;
    protected Messenger messenger;
    protected int messageId;
    protected int lastWidth;
    protected int lastHeight;
    private static AtomicInteger idGenerator;

    public TiUIWindow(TiWindowProxy proxy, KrollDict options, Messenger messenger, int messageId) {
        super((TiViewProxy)proxy);
        this.animate = true;
        if (idGenerator == null) {
            idGenerator = new AtomicInteger(0);
        }
        this.messenger = messenger;
        this.messageId = messageId;
        this.handler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        this.lastWidth = -1;
        this.lastHeight = -1;
        this.resolver = new TiPropertyResolver(new KrollDict[]{options, proxy.getProperties()});
        this.newActivity = proxy.requiresNewActivity(options);
        if (!this.newActivity && options != null && options.containsKey((Object)"tabOpen")) {
            this.newActivity = TiConvert.toBoolean((KrollDict)options, (String)"tabOpen");
        }
        this.lightWeight = !this.newActivity;
        this.initContext();
        if (this.newActivity) {
            this.createNewActivity();
        } else {
            this.lightWindow = new TiCompositeLayout(proxy.getContext(), this.getLayoutArrangement());
            this.layoutParams.autoFillsHeight = true;
            this.layoutParams.autoFillsWidth = true;
            this.setNativeView((View)this.lightWindow);
            proxy.setModelListener((KrollProxyListener)this);
            this.handleWindowCreated();
            this.handleBooted();
        }
    }

    public TiUIWindow(TiWindowProxy proxy, Activity activity) {
        super((TiViewProxy)proxy);
        this.resolver = new TiPropertyResolver(new KrollDict[]{proxy.getProperties()});
        if (idGenerator == null) {
            idGenerator = new AtomicInteger(0);
        }
        this.newActivity = false;
        this.windowActivity = activity;
        this.lightWeight = false;
        this.handler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        this.initContext();
        this.handleWindowCreated();
        this.handleBooted();
    }

    public boolean isLightweight() {
        return this.lightWeight;
    }

    protected void initContext() {
        if (this.proxy.hasProperty("url")) {
            if (this.newActivity) {
                this.windowId = TiActivityWindows.addWindow((TiActivityWindow)this);
            }
            String url = TiConvert.toString((Object)this.proxy.getProperty("url"));
            String baseUrl = this.proxy.getTiContext().getBaseUrl();
            TiUrl tiUrl = TiUrl.normalizeWindowUrl((String)baseUrl, (String)url);
            this.windowUrl = tiUrl.url;
            Activity activity = null;
            if (!this.newActivity && (activity = this.windowActivity) == null) {
                activity = this.proxy.getTiContext().getActivity();
            }
            this.windowContext = TiContext.createTiContext((Activity)activity, (String)tiUrl.baseUrl, (String)tiUrl.url);
            this.newContext = true;
            ActivityProxy activityProxy = null;
            if (!this.newActivity && activity instanceof TiBaseActivity) {
                activityProxy = ((TiBaseActivity)activity).getActivityProxy();
            }
            if (activityProxy == null) {
                activityProxy = ((TiWindowProxy)this.proxy).getActivity(this.windowContext);
            }
            if (this.windowActivity != null) {
                this.bindWindowActivity(this.windowContext, this.windowActivity);
            }
            TiBindingHelper.bindCurrentWindowAndActivity((TiContext)this.windowContext, (TiViewProxy)this.proxy, (ActivityProxy)activityProxy);
        } else if (!this.lightWeight) {
            this.windowContext = TiContext.createTiContext((Activity)this.windowActivity, (String)this.proxy.getTiContext().getBaseUrl(), (String)this.proxy.getTiContext().getCurrentUrl());
            this.newContext = true;
            ActivityProxy activityProxy = ((TiWindowProxy)this.proxy).getActivity(this.windowContext);
            if (this.windowActivity != null) {
                this.bindWindowActivity(this.windowContext, this.windowActivity);
            }
            if (this.newActivity) {
                this.windowId = TiActivityWindows.addWindow((TiActivityWindow)this);
            }
            TiBindingHelper.bindCurrentWindowAndActivity((TiContext)this.windowContext, (TiViewProxy)this.proxy, (ActivityProxy)activityProxy);
            this.bindProxies();
        } else {
            this.bindWindowActivity(this.proxy.getTiContext(), this.proxy.getTiContext().getActivity());
        }
        if (!this.newActivity && !this.lightWeight) {
            this.proxy.switchContext(this.windowContext);
        }
    }

    protected void createNewActivity() {
        Activity activity = this.proxy.getTiContext().getActivity();
        Intent intent = this.createIntent(activity);
        KrollDict d = this.resolver.findProperty("animated");
        if (d != null) {
            this.animate = TiConvert.toBoolean((KrollDict)d, (String)"animated");
        }
        if (!this.animate) {
            intent.addFlags(65536);
            intent.putExtra("animate", false);
            activity.startActivity(intent);
            TiUIHelper.overridePendingTransition((Activity)activity);
        } else {
            activity.startActivity(intent);
        }
        this.proxy.switchContext(this.windowContext);
    }

    public void windowCreated(TiBaseActivity activity) {
        this.windowActivity = activity;
        this.windowContext.setActivity(this.windowActivity);
        this.bindWindowActivity(this.windowContext, this.windowActivity);
        this.bindProxies();
        this.handleWindowCreated();
        TiMessageQueue.getMainMessageQueue().stopBlocking();
    }

    protected void handleWindowCreated() {
        if (this.windowUrl != null) {
            try {
                this.windowContext.evalFile(this.windowUrl);
            }
            catch (IOException e) {
                Log.e((String)LCAT, (String)("Error opening URL: " + this.windowUrl), (Throwable)e);
            }
        }
    }

    protected ActivityProxy bindWindowActivity(TiContext tiContext, Activity activity) {
        ActivityProxy activityProxy = null;
        if (activity instanceof TiBaseActivity) {
            activityProxy = ((TiBaseActivity)activity).getActivityProxy();
        }
        if (activityProxy == null) {
            activityProxy = ((TiWindowProxy)this.proxy).getActivity(tiContext);
            activityProxy.setActivity(tiContext, activity);
            if (activity instanceof TiBaseActivity) {
                ((TiBaseActivity)activity).setActivityProxy(activityProxy);
            }
        }
        return activityProxy;
    }

    protected void bindProxies() {
        if (this.windowActivity instanceof TiBaseActivity) {
            TiBaseActivity tiActivity = (TiBaseActivity)this.windowActivity;
            TiWindowProxy windowProxy = (TiWindowProxy)this.proxy;
            tiActivity.setActivityProxy(windowProxy.getActivity(this.proxy.getTiContext()));
            tiActivity.setWindowProxy(windowProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleBooted() {
        this.activityKey = WINDOW_ID_PREFIX + idGenerator.incrementAndGet();
        View layout = this.getLayout();
        layout.setClickable(true);
        this.registerForTouch(layout);
        layout.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean hasFocus) {
                TiUIWindow.this.proxy.fireEvent(hasFocus ? "focus" : "blur", new KrollDict());
            }
        });
        if (this.messenger != null) {
            Message msg = Message.obtain();
            msg.what = this.messageId;
            try {
                this.messenger.send(msg);
            }
            catch (RemoteException e) {
                Log.e((String)LCAT, (String)("Unable to send message: " + e.getMessage()), (Throwable)e);
            }
            finally {
                this.messenger = null;
            }
        }
        if (this.lightWeight) {
            ITiWindowHandler windowHandler = this.proxy.getTiContext().getTiApp().getWindowHandler();
            if (windowHandler != null) {
                TiCompositeLayout.LayoutParams params = this.getLayoutParams();
                params.optionZIndex = 0x7FFFFFFD;
                windowHandler.addWindow((View)this.lightWindow, params);
            }
            this.handler.obtainMessage(100).sendToTarget();
        } else if (this.windowActivity != null && this.windowActivity instanceof TiActivity) {
            layout.requestFocus();
            ((TiActivity)this.windowActivity).fireInitialFocus();
        }
    }

    public void close(KrollDict options) {
        KrollDict props = this.proxy.getProperties();
        TiPropertyResolver resolver = new TiPropertyResolver(new KrollDict[]{options, props});
        props = resolver.findProperty("animated");
        boolean animateOnClose = this.animate;
        if (props != null && props.containsKey((Object)"animated")) {
            animateOnClose = props.getBoolean("animated");
        }
        if (!this.lightWeight) {
            if (this.windowActivity != null) {
                if (!animateOnClose) {
                    this.windowActivity.finish();
                    TiUIHelper.overridePendingTransition((Activity)this.windowActivity);
                } else {
                    this.windowActivity.finish();
                }
                this.windowActivity = null;
            }
        } else if (this.lightWindow != null) {
            KrollDict data = new KrollDict();
            data.put((Object)"source", (Object)this.proxy);
            this.proxy.fireSyncEvent("close", data);
            ITiWindowHandler windowHandler = this.proxy.getTiContext().getTiApp().getWindowHandler();
            if (windowHandler != null) {
                windowHandler.removeWindow((View)this.lightWindow);
            }
            this.lightWindow.removeAllViews();
            this.lightWindow = null;
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1000: {
                if (DBG) {
                    Log.d((String)LCAT, (String)"Received Activity creation message");
                }
                if (this.windowActivity == null) {
                    this.windowActivity = (Activity)msg.obj;
                }
                this.proxy.setModelListener((KrollProxyListener)this);
                this.handleBooted();
                return true;
            }
            case 100: {
                this.animate();
                return true;
            }
        }
        return false;
    }

    public View getNativeView() {
        View v = super.getNativeView();
        if (!this.lightWeight) {
            v = this.getLayout();
        }
        return v;
    }

    public View getLayout() {
        View layout = this.nativeView;
        if (!this.lightWeight) {
            TiActivity tia = (TiActivity)this.windowActivity;
            if (tia == null) {
                return null;
            }
            layout = tia.getLayout();
        }
        return layout;
    }

    protected void setActivityBackground(final Drawable drawable, boolean post) {
        if (post) {
            this.proxy.getUIHandler().post(new Runnable(){

                @Override
                public void run() {
                    TiUIWindow.this.windowActivity.getWindow().setBackgroundDrawable(drawable);
                }
            });
        } else {
            this.windowActivity.getWindow().setBackgroundDrawable(drawable);
        }
    }

    private void handleBackground(Drawable drawable, Object opacityValue, boolean post) {
        if (drawable != null) {
            if (opacityValue != null && !this.lightWeight) {
                this.setActivityOpacity(drawable, TiConvert.toFloat((Object)opacityValue), true);
            }
            if (this.lightWeight) {
                this.nativeView.setBackgroundDrawable(drawable);
            } else {
                this.setActivityBackground(drawable, post);
            }
        }
    }

    private void handleBackgroundColor(Object value, boolean post) {
        KrollDict d = this.resolver.findProperty("opacity");
        if (d != null && d.containsKey((Object)"opacity")) {
            this.handleBackgroundColor(value, d.get((Object)"opacity"), post);
        } else {
            this.handleBackgroundColor(value, null, post);
        }
    }

    private void setActivityOpacity(Drawable background, float opacity, boolean firstTime) {
        int alpha = Math.round(opacity * 255.0f);
        if (alpha > 254 && firstTime) {
            alpha = 254;
        } else if (alpha < 0) {
            alpha = 0;
        }
        background.setAlpha(alpha);
    }

    private void handleBackgroundColor(Object value, Object opacityValue, boolean post) {
        if (value != null) {
            ColorDrawable cd = TiConvert.toColorDrawable((String)TiConvert.toString((Object)value));
            this.handleBackground((Drawable)cd, opacityValue, post);
        } else {
            Log.w((String)LCAT, (String)"Unable to set opacity w/o a backgroundColor");
        }
    }

    private void handleBackgroundImage(Object value, boolean post) {
        KrollDict d = this.resolver.findProperty("opacity");
        if (d != null && d.containsKey((Object)"opacity")) {
            this.handleBackgroundImage(value, d.get((Object)"opacity"), post);
        } else {
            this.handleBackgroundImage(value, null, post);
        }
    }

    private void handleBackgroundImage(Object value, Object opacityValue, boolean post) {
        if (value != null) {
            String path = this.proxy.getTiContext().resolveUrl(null, TiConvert.toString((Object)value));
            TiFileHelper tfh = new TiFileHelper(this.proxy.getContext().getApplicationContext());
            Drawable bd = tfh.loadDrawable(this.proxy.getTiContext(), path, false);
            this.handleBackground(bd, opacityValue, post);
        }
    }

    public void processProperties(KrollDict d) {
        if (d.containsKey((Object)"backgroundImage")) {
            if (d.containsKey((Object)"opacity")) {
                this.handleBackgroundImage(d.get((Object)"backgroundImage"), d.get((Object)"opacity"), true);
            } else {
                this.handleBackgroundImage(d.get((Object)"backgroundImage"), true);
            }
        } else if (d.containsKey((Object)"backgroundColor")) {
            if (d.containsKey((Object)"opacity")) {
                this.handleBackgroundColor(d.get((Object)"backgroundColor"), d.get((Object)"opacity"), true);
            } else {
                this.handleBackgroundColor(d.get((Object)"backgroundColor"), true);
            }
        }
        if (d.containsKey((Object)"title")) {
            String title = TiConvert.toString((KrollDict)d, (String)"title");
            if (this.windowActivity != null) {
                this.windowActivity.setTitle((CharSequence)title);
            } else {
                this.proxy.getTiContext().getActivity().setTitle((CharSequence)title);
            }
        }
        if (d.containsKey((Object)"layout") && !this.lightWeight) {
            TiCompositeLayout layout = null;
            if (this.windowActivity instanceof TiActivity) {
                layout = ((TiActivity)this.windowActivity).getLayout();
            }
            if (layout != null) {
                layout.setLayoutArrangement(TiConvert.toString((KrollDict)d, (String)"layout"));
            }
        }
        d.remove((Object)"backgroundImage");
        d.remove((Object)"backgroundColor");
        super.processProperties(d);
    }

    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy) {
        if (key.equals("backgroundImage")) {
            if (newValue != null) {
                this.handleBackgroundImage(newValue, false);
            } else {
                this.handleBackgroundColor(proxy.getProperty("backgroundColor"), false);
            }
        } else if (key.equals("backgroundColor")) {
            this.handleBackgroundColor(newValue, false);
        } else if (key.equals("width") || key.equals("height")) {
            Window w = proxy.getTiContext().getActivity().getWindow();
            int width = this.lastWidth;
            int height = this.lastHeight;
            if (key.equals("width")) {
                width = newValue != null ? TiConvert.toInt((Object)newValue) : -1;
            }
            if (key.equals("height")) {
                height = newValue != null ? TiConvert.toInt((Object)newValue) : -1;
            }
            w.setLayout(width, height);
            this.lastWidth = width;
            this.lastHeight = height;
        } else if (key.equals("title")) {
            String title = TiConvert.toString((Object)newValue);
            if (this.windowActivity != null) {
                this.windowActivity.setTitle((CharSequence)title);
            } else {
                proxy.getTiContext().getActivity().setTitle((CharSequence)title);
            }
        } else if (key.equals("layout")) {
            if (!this.lightWeight) {
                TiCompositeLayout layout = null;
                if (this.windowActivity instanceof TiActivity) {
                    layout = ((TiActivity)this.windowActivity).getLayout();
                }
                if (layout != null) {
                    layout.setLayoutArrangement(TiConvert.toString((Object)newValue));
                }
            }
        } else if (key.equals("opacity")) {
            this.setOpacity(TiConvert.toFloat((Object)newValue));
        } else {
            super.propertyChanged(key, oldValue, newValue, proxy);
        }
    }

    protected TiCompositeLayout.LayoutArrangement getLayoutArrangement() {
        TiCompositeLayout.LayoutArrangement arrangement = TiCompositeLayout.LayoutArrangement.DEFAULT;
        KrollDict d = this.resolver.findProperty("layout");
        if (d != null) {
            if (TiConvert.toString((KrollDict)d, (String)"layout").equals("vertical")) {
                arrangement = TiCompositeLayout.LayoutArrangement.VERTICAL;
            } else if (TiConvert.toString((KrollDict)d, (String)"layout").equals("horizontal")) {
                arrangement = TiCompositeLayout.LayoutArrangement.HORIZONTAL;
            }
        }
        return arrangement;
    }

    protected Intent createIntent(Activity activity) {
        Intent intent = new Intent((Context)activity, TiActivity.class);
        KrollDict props = this.resolver.findProperty("fullscreen");
        if (props != null && props.containsKey((Object)"fullscreen")) {
            intent.putExtra("fullscreen", TiConvert.toBoolean((KrollDict)props, (String)"fullscreen"));
        }
        if ((props = this.resolver.findProperty("navBarHidden")) != null && props.containsKey((Object)"navBarHidden")) {
            intent.putExtra("navBarHidden", TiConvert.toBoolean((KrollDict)props, (String)"navBarHidden"));
        }
        props = this.resolver.findProperty("modal");
        boolean modal = false;
        if (props != null && props.containsKey((Object)"modal")) {
            modal = TiConvert.toBoolean((KrollDict)props, (String)"modal");
            intent.putExtra("modal", modal);
            if (modal) {
                intent.setClass((Context)activity, TiModalActivity.class);
            }
        }
        if ((props = this.resolver.findProperty("opacity")) != null && props.containsKey((Object)"opacity") && !modal) {
            intent.setClass((Context)activity, TiTranslucentActivity.class);
        }
        if ((props = this.resolver.findProperty("url")) != null && props.containsKey((Object)"url")) {
            intent.putExtra("url", TiConvert.toString((KrollDict)props, (String)"url"));
        }
        if ((props = this.resolver.findProperty("layout")) != null && props.containsKey((Object)"layout")) {
            intent.putExtra("layout", TiConvert.toString((KrollDict)props, (String)"layout"));
        }
        if ((props = this.resolver.findProperty("windowSoftInputMode")) != null && props.containsKey((Object)"windowSoftInputMode")) {
            intent.putExtra("windowSoftInputMode", TiConvert.toInt((KrollDict)props, (String)"windowSoftInputMode"));
        }
        boolean finishRoot = false;
        props = this.resolver.findProperty("exitOnClose");
        if (props != null && props.containsKey((Object)"exitOnClose")) {
            finishRoot = TiConvert.toBoolean((KrollDict)props, (String)"exitOnClose");
        }
        intent.putExtra("finishRoot", finishRoot);
        Messenger messenger = new Messenger(this.handler);
        intent.putExtra("messenger", (Parcelable)messenger);
        intent.putExtra("msgActivityCreatedId", 1000);
        intent.putExtra("useActivityWindow", true);
        intent.putExtra("windowId", this.windowId);
        return intent;
    }

    public void setOpacity(float opacity) {
        if (this.lightWeight) {
            super.setOpacity(this.nativeView, opacity);
        } else {
            this.setActivityOpacity(this.windowActivity.getWindow().getDecorView().getBackground(), opacity, false);
            this.windowActivity.getWindow().getDecorView().invalidate();
        }
    }

    public void release() {
        super.release();
        if (this.lightWindow != null) {
            this.lightWindow.removeAllViews();
            this.lightWindow = null;
        }
        this.messenger = null;
        this.handler = null;
        this.windowActivity = null;
        if (this.newContext && this.windowContext != null) {
            this.windowContext.release();
            this.windowContext = null;
        }
    }

    public Activity getActivity() {
        return this.windowActivity;
    }
}

