/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui;

import android.app.Activity;
import android.app.TabActivity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.TabHost;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiRootActivity;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.view.TiCompositeLayout;
import ti.modules.titanium.ui.TabGroupProxy;

public class TiTabActivity
extends TabActivity {
    private static final String LCAT = "TiTabActivity";
    protected TabGroupProxy proxy;
    protected Handler handler;

    public void setTabGroupProxy(TabGroupProxy proxy) {
        this.proxy = proxy;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        int layoutResId = this.getResources().getIdentifier("titanium_tabgroup", "layout", this.getPackageName());
        if (layoutResId == 0) {
            throw new IllegalStateException("titanium_tabgroup layout resource not found.  TabGroup cannot be created.");
        }
        Intent intent = this.getIntent();
        this.handler = new Handler();
        TabHost tabHost = (TabHost)LayoutInflater.from((Context)this).inflate(layoutResId, null);
        TiCompositeLayout.LayoutParams tabHostLayout = new TiCompositeLayout.LayoutParams();
        tabHostLayout.autoFillsHeight = true;
        tabHostLayout.autoFillsWidth = true;
        TiCompositeLayout layout = new TiCompositeLayout((Context)this, TiCompositeLayout.LayoutArrangement.DEFAULT);
        layout.addView((View)tabHost, (ViewGroup.LayoutParams)tabHostLayout);
        boolean fullscreen = false;
        boolean navbar = false;
        Messenger messenger = null;
        Integer messageId = null;
        if (intent != null) {
            Window w;
            int mode;
            if (intent.hasExtra("fullscreen")) {
                fullscreen = intent.getBooleanExtra("fullscreen", fullscreen);
            }
            if (intent.hasExtra("navBarHidden")) {
                boolean bl = navbar = !intent.getBooleanExtra("navBarHidden", navbar);
            }
            if (intent.hasExtra("messenger")) {
                messenger = (Messenger)intent.getParcelableExtra("messenger");
                messageId = intent.getIntExtra("messageId", -1);
            }
            if (intent.hasExtra("windowSoftInputMode") && (mode = intent.getIntExtra("windowSoftInputMode", -1)) != -1 && (w = this.getWindow()) != null) {
                w.setSoftInputMode(mode);
            }
        }
        if (fullscreen) {
            this.getWindow().setFlags(1024, 1024);
        }
        if (navbar) {
            this.requestWindowFeature(3);
            this.requestWindowFeature(4);
            this.requestWindowFeature(2);
            this.requestWindowFeature(5);
        } else {
            this.requestWindowFeature(1);
        }
        this.setContentView((View)layout);
        TabHost.TabSpec tabSpec = tabHost.newTabSpec("ti_empty").setIndicator((CharSequence)"");
        tabSpec.setContent(new TabHost.TabContentFactory(){

            public View createTabContent(String tag) {
                return new View((Context)TiTabActivity.this);
            }
        });
        tabHost.addTab(tabSpec);
        final TiTabActivity me = this;
        final Messenger fMessenger = messenger;
        final int fMessageId = messageId;
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (fMessenger != null) {
                    try {
                        Message msg = Message.obtain();
                        msg.what = fMessageId;
                        msg.obj = me;
                        if (fMessenger.getBinder().pingBinder()) {
                            fMessenger.send(msg);
                            Log.w((String)TiTabActivity.LCAT, (String)"Notifying TiTabGroup, activity is created");
                        } else {
                            me.finish();
                        }
                    }
                    catch (RemoteException e) {
                        Log.e((String)TiTabActivity.LCAT, (String)"Unable to message creator. finishing.");
                        me.finish();
                    }
                    catch (RuntimeException e) {
                        Log.w((String)TiTabActivity.LCAT, (String)("Run-time exception: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        });
    }

    public TiApplication getTiApp() {
        return (TiApplication)this.getApplication();
    }

    public void finish() {
        TiRootActivity rootActivity;
        TiApplication tiApp;
        if (this.shouldFinishRootActivity() && this.getApplication() != null && (tiApp = this.getTiApp()) != null && (rootActivity = tiApp.getRootActivity()) != null) {
            rootActivity.finish();
        }
        super.finish();
    }

    protected void onPause() {
        super.onPause();
        ((TiApplication)this.getApplication()).setCurrentActivity((Activity)this, null);
    }

    protected void onResume() {
        super.onResume();
        ((TiApplication)this.getApplication()).setCurrentActivity((Activity)this, (Activity)this);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (!this.isFinishing()) {
            Intent intent;
            if (!this.shouldFinishRootActivity() && (intent = this.getIntent()) != null) {
                intent.putExtra("finishRoot", true);
            }
            this.getTiApp().scheduleRestart(250);
            this.finish();
            return;
        }
        if (this.proxy != null) {
            this.proxy.closeFromActivity();
            this.proxy = null;
        }
        this.handler = null;
    }

    private boolean shouldFinishRootActivity() {
        Intent intent = this.getIntent();
        return intent.hasExtra("finishRoot") && intent.getBooleanExtra("finishRoot", false);
    }
}

