/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui;

import android.app.Activity;
import android.os.Message;
import java.util.ArrayList;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.view.TiUIView;
import org.mozilla.javascript.Scriptable;
import ti.modules.titanium.ui.LabelProxy;
import ti.modules.titanium.ui.TableViewProxy;
import ti.modules.titanium.ui.widget.tableview.TableViewModel;
import ti.modules.titanium.ui.widget.tableview.TiTableViewRowProxyItem;

public class TableViewRowProxy
extends TiViewProxy {
    private static final String LCAT = "TableViewRowProxy";
    protected ArrayList<TiViewProxy> controls;
    protected TiTableViewRowProxyItem tableViewItem;
    private static final int MSG_SET_DATA = 7000;

    public TableViewRowProxy(TiContext tiContext) {
        super(tiContext);
    }

    public void handleCreationDict(KrollDict options) {
        super.handleCreationDict(options);
        if (options.containsKey((Object)"selectedBackgroundColor")) {
            Log.w((String)LCAT, (String)"selectedBackgroundColor is deprecated, use backgroundSelectedColor instead");
            this.setProperty("backgroundSelectedColor", options.get((Object)"selectedBackgroundColor"));
        }
        if (options.containsKey((Object)"selectedBackgroundImage")) {
            Log.w((String)LCAT, (String)"selectedBackgroundImage is deprecated, use backgroundSelectedImage instead");
            this.setProperty("backgroundSelectedImage", options.get((Object)"selectedBackgroundImage"));
        }
    }

    public TiUIView createView(Activity activity) {
        return null;
    }

    public ArrayList<TiViewProxy> getControls() {
        return this.controls;
    }

    public boolean hasControls() {
        return this.controls != null && this.controls.size() > 0;
    }

    public TiViewProxy[] getChildren() {
        return this.controls.toArray(new TiViewProxy[this.controls.size()]);
    }

    public void add(TiViewProxy control) {
        if (this.controls == null) {
            this.controls = new ArrayList();
        }
        this.controls.add(control);
        control.setParent((TiViewProxy)this);
        if (this.tableViewItem != null) {
            Message msg = this.getUIHandler().obtainMessage(7000);
            msg.sendToTarget();
        }
    }

    public void remove(TiViewProxy control) {
        if (this.controls == null) {
            return;
        }
        this.controls.remove(control);
        if (this.tableViewItem != null) {
            Message msg = this.getUIHandler().obtainMessage(7000);
            msg.sendToTarget();
        }
    }

    public void setTableViewItem(TiTableViewRowProxyItem item) {
        this.tableViewItem = item;
    }

    public TableViewProxy getTable() {
        TiViewProxy parent;
        for (parent = this.getParent(); !(parent instanceof TableViewProxy) && parent != null; parent = parent.getParent()) {
        }
        return (TableViewProxy)parent;
    }

    public void set(Scriptable scope, String name, Object value) throws NoSuchFieldException {
        if (name.equals("selectedBackgroundColor")) {
            Log.w((String)LCAT, (String)"selectedBackgroundColor is deprecated, use backgroundSelectedColor instead");
            super.set(scope, "backgroundSelectedColor", value);
        } else if (name.equals("selectedBackgroundImage")) {
            Log.w((String)LCAT, (String)"selectedBackgroundImage is deprecated, use backgroundSelectedImage instead");
            super.set(scope, "backgroundSelectedImage", value);
        } else {
            super.set(scope, name, value);
        }
    }

    public void setProperty(String name, Object value, boolean fireChange) {
        super.setProperty(name, value, fireChange);
        if (this.tableViewItem != null) {
            if (this.context.isUIThread()) {
                this.tableViewItem.setRowData(this);
            } else {
                Message msg = this.getUIHandler().obtainMessage(7000);
                msg.sendToTarget();
            }
        }
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 7000) {
            if (this.tableViewItem != null) {
                this.tableViewItem.setRowData(this);
            }
            return true;
        }
        return super.handleMessage(msg);
    }

    public static void fillClickEvent(KrollDict data, TableViewModel model, TableViewModel.Item item) {
        data.put((Object)"rowData", item.rowData);
        data.put((Object)"section", (Object)model.getSection(item.sectionIndex));
        data.put((Object)"row", (Object)item.proxy);
        data.put((Object)"index", (Object)item.index);
        data.put((Object)"detail", (Object)false);
    }

    public boolean fireEvent(String eventName, KrollDict data) {
        if (eventName.equals("click")) {
            TableViewProxy table = this.getTable();
            TableViewModel.Item item = this.tableViewItem.getRowData();
            if (table != null && item != null) {
                TableViewRowProxy.fillClickEvent(data, table.getTableView().getModel(), item);
            }
        }
        return super.fireEvent(eventName, data);
    }

    public void setLabelsClickable(boolean clickable) {
        if (this.controls != null) {
            for (TiViewProxy control : this.controls) {
                if (!(control instanceof LabelProxy)) continue;
                ((LabelProxy)control).setClickable(clickable);
            }
        }
    }

    public void releaseViews() {
        super.releaseViews();
        if (this.tableViewItem != null) {
            this.tableViewItem.release();
            this.tableViewItem = null;
        }
        if (this.controls != null) {
            for (TiViewProxy control : this.controls) {
                control.releaseViews();
            }
        }
    }

    public TiTableViewRowProxyItem getTableViewRowProxyItem() {
        return this.tableViewItem;
    }
}

