/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui;

import android.app.Activity;
import android.os.Message;
import java.util.ArrayList;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.kroll.annotations.Kroll;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.bridge.OnEventListenerChange;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.AsyncResult;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.TableViewRowProxy;
import ti.modules.titanium.ui.TableViewSectionProxy;
import ti.modules.titanium.ui.widget.TiUITableView;

public class TableViewProxy
extends TiViewProxy {
    private static final String LCAT = "TableViewProxy";
    private static final boolean DBG = TiConfig.LOGD;
    private static final int INSERT_ROW_BEFORE = 0;
    private static final int INSERT_ROW_AFTER = 1;
    private static final int MSG_UPDATE_VIEW = 7000;
    private static final int MSG_SCROLL_TO_INDEX = 7001;
    private static final int MSG_SET_DATA = 7002;
    private static final int MSG_DELETE_ROW = 7003;
    private static final int MSG_INSERT_ROW = 7004;
    private static final int MSG_APPEND_ROW = 7005;
    private static final int MSG_SCROLL_TO_TOP = 7006;
    public static final String CLASSNAME_DEFAULT = "__default__";
    public static final String CLASSNAME_HEADER = "__header__";
    public static final String CLASSNAME_NORMAL = "__normal__";
    private ArrayList<TableViewSectionProxy> localSections;

    public TableViewProxy(TiContext tiContext) {
        super(tiContext);
        this.eventManager.addOnEventChangeListener((OnEventListenerChange)this);
    }

    public void handleCreationDict(KrollDict dict) {
        Object o;
        Object[] data = null;
        if (dict.containsKey((Object)"data") && (o = dict.get((Object)"data")) != null && o instanceof Object[]) {
            data = (Object[])o;
            dict.remove((Object)"data");
        }
        super.handleCreationDict(dict);
        if (data != null) {
            this.processData(data);
        }
    }

    public void releaseViews() {
        super.releaseViews();
        if (this.localSections != null) {
            for (TableViewSectionProxy section : this.localSections) {
                section.releaseViews();
            }
        }
    }

    public TiUIView createView(Activity activity) {
        return new TiUITableView(this);
    }

    public TiUITableView getTableView() {
        TiContext ctx = this.getTiContext();
        if (ctx != null) {
            return (TiUITableView)this.getView(ctx.getActivity());
        }
        return null;
    }

    public void updateRow(Object row, Object data, @Kroll.argument(optional=true) KrollDict options) {
        TableViewSectionProxy sectionProxy = null;
        int rowIndex = -1;
        if (row instanceof Number) {
            RowResult rr = new RowResult();
            rowIndex = ((Number)row).intValue();
            this.locateIndex(rowIndex, rr);
            sectionProxy = rr.section;
        } else if (row instanceof TableViewRowProxy) {
            ArrayList<TableViewSectionProxy> sections = this.getSections();
            block0: for (int i = 0; i < sections.size(); ++i) {
                ArrayList<TableViewRowProxy> rows = sections.get((int)i).rows;
                for (int j = 0; j < rows.size(); ++j) {
                    if (rows.get(j) != row) continue;
                    sectionProxy = sections.get(i);
                    rowIndex = j;
                    break block0;
                }
            }
        }
        if (sectionProxy != null) {
            sectionProxy.updateRowAt(rowIndex, this.rowProxyFor(data));
            this.getTableView().setModelDirty();
            this.updateView();
        }
    }

    public void appendRow(Object row, @Kroll.argument(optional=true) KrollDict options) {
        TiContext ctx = this.getTiContext();
        if (ctx == null) {
            Log.w((String)LCAT, (String)"Context has been GC'd, not appending row");
            return;
        }
        if (ctx.isUIThread()) {
            this.handleAppendRow(row);
            return;
        }
        this.sendBlockingUiMessage(7005, row);
    }

    private void handleAppendRow(Object row) {
        TableViewRowProxy rowProxy = this.rowProxyFor(row);
        ArrayList<TableViewSectionProxy> sections = this.getSections();
        if (sections.size() == 0) {
            Object[] data = new Object[]{rowProxy};
            this.processData(data);
        } else {
            TableViewSectionProxy lastSection = sections.get(sections.size() - 1);
            TableViewSectionProxy addedToSection = this.addRowToSection(rowProxy, lastSection);
            if (lastSection == null || !((Object)((Object)lastSection)).equals((Object)addedToSection)) {
                sections.add(addedToSection);
            }
            rowProxy.setProperty("section", (Object)addedToSection);
            rowProxy.setProperty("parent", (Object)addedToSection);
        }
        this.getTableView().setModelDirty();
        this.updateView();
    }

    public void deleteRow(int index, @Kroll.argument(optional=true) KrollDict options) {
        TiContext ctx = this.getTiContext();
        if (ctx == null) {
            Log.w((String)LCAT, (String)"Context has been GC'd, not deleting row.");
            return;
        }
        if (ctx.isUIThread()) {
            this.handleDeleteRow(index);
            return;
        }
        Message msg = this.getUIHandler().obtainMessage(7003);
        msg.arg1 = index;
        msg.sendToTarget();
    }

    private void handleDeleteRow(int index) {
        RowResult rr = new RowResult();
        if (!this.locateIndex(index, rr)) {
            throw new IllegalStateException("Index out of range. Non-existant row at " + index);
        }
        rr.section.removeRowAt(rr.rowIndexInSection);
        this.getTableView().setModelDirty();
        this.updateView();
    }

    public int getIndexByName(String name) {
        int index = -1;
        int idx = 0;
        if (name != null) {
            for (TableViewSectionProxy section : this.getSections()) {
                for (TableViewRowProxy row : section.getRows()) {
                    String rname = TiConvert.toString((Object)row.getProperty("name"));
                    if (rname != null && name.equals(rname)) {
                        index = idx;
                        break;
                    }
                    ++idx;
                }
                if (index <= -1) continue;
                break;
            }
        }
        return index;
    }

    public void insertRowBefore(int index, Object data, @Kroll.argument(optional=true) KrollDict options) {
        TiContext ctx = this.getTiContext();
        if (ctx == null) {
            Log.w((String)LCAT, (String)"Context has been GC'd, not inserting row");
            return;
        }
        if (ctx.isUIThread()) {
            this.handleInsertRowBefore(index, data);
            return;
        }
        this.sendBlockingUiMessage(7004, data, 0, index);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleInsertRowBefore(int index, Object data) {
        if (this.getSections().size() > 0) {
            RowResult rr;
            if (index < 0) {
                index = 0;
            }
            if (!this.locateIndex(index, rr = new RowResult())) throw new IllegalStateException("Index out of range. Non-existant row at " + index);
            TableViewRowProxy rowProxy = this.rowProxyFor(data);
            rr.section.insertRowAt(rr.rowIndexInSection, rowProxy);
        } else {
            Object[] args = new Object[]{this.rowProxyFor(data)};
            this.processData(args);
        }
        this.getTableView().setModelDirty();
        this.updateView();
    }

    public void insertRowAfter(int index, Object data, @Kroll.argument(optional=true) KrollDict options) {
        TiContext ctx = this.getTiContext();
        if (ctx == null) {
            Log.w((String)LCAT, (String)"Context has been GC'd, not inserting row.");
            return;
        }
        if (ctx.isUIThread()) {
            this.handleInsertRowAfter(index, data);
            return;
        }
        this.sendBlockingUiMessage(7004, data, 1, index);
    }

    private void handleInsertRowAfter(int index, Object data) {
        RowResult rr = new RowResult();
        if (!this.locateIndex(index, rr)) {
            throw new IllegalStateException("Index out of range. Non-existant row at " + index);
        }
        TableViewRowProxy rowProxy = this.rowProxyFor(data);
        rr.section.insertRowAt(rr.rowIndexInSection + 1, rowProxy);
        this.getTableView().setModelDirty();
        this.updateView();
    }

    public ArrayList<TableViewSectionProxy> getSections() {
        ArrayList<TableViewSectionProxy> sections = this.localSections;
        if (sections == null) {
            this.localSections = sections = new ArrayList();
        }
        return sections;
    }

    private TableViewSectionProxy addRowToSection(TableViewRowProxy row, TableViewSectionProxy currentSection) {
        KrollDict d = row.getProperties();
        TableViewSectionProxy addedToSection = null;
        addedToSection = currentSection == null || d.containsKey((Object)"header") ? new TableViewSectionProxy(this.getTiContext()) : currentSection;
        if (d.containsKey((Object)"header")) {
            addedToSection.setProperty("headerTitle", d.get((Object)"header"));
        }
        if (d.containsKey((Object)"footer")) {
            addedToSection.setProperty("footerTitle", d.get((Object)"footer"));
        }
        addedToSection.add(row);
        return addedToSection;
    }

    public void processData(Object[] data) {
        ArrayList<TableViewSectionProxy> sections = this.getSections();
        sections.clear();
        TableViewSectionProxy currentSection = null;
        if (this.hasProperty("headerTitle")) {
            currentSection = new TableViewSectionProxy(this.context);
            sections.add(currentSection);
            currentSection.setProperty("headerTitle", this.getProperty("headerTitle"));
        }
        if (this.hasProperty("footerTitle")) {
            if (currentSection == null) {
                currentSection = new TableViewSectionProxy(this.context);
                sections.add(currentSection);
            }
            currentSection.setProperty("footerTitle", this.getProperty("footerTitle"));
        }
        for (int i = 0; i < data.length; ++i) {
            Object o = data[i];
            if (o instanceof KrollDict || o instanceof TableViewRowProxy) {
                TableViewRowProxy rowProxy = this.rowProxyFor(o);
                TableViewSectionProxy addedToSection = this.addRowToSection(rowProxy, currentSection);
                if (currentSection != null && ((Object)((Object)currentSection)).equals((Object)addedToSection)) continue;
                currentSection = addedToSection;
                sections.add(currentSection);
                continue;
            }
            if (!(o instanceof TableViewSectionProxy)) continue;
            currentSection = (TableViewSectionProxy)((Object)o);
            sections.add(currentSection);
            currentSection.setParent(this);
        }
    }

    public void setData(Object[] data, @Kroll.argument(optional=true) KrollDict options) {
        TiContext ctx = this.getTiContext();
        Object[] actualData = data;
        if (data != null && data.length > 0 && data[0] instanceof Object[]) {
            actualData = (Object[])data[0];
        }
        if (ctx == null) {
            Log.w((String)LCAT, (String)"Context has been GC'd, not setting table data.");
            return;
        }
        if (ctx.isUIThread()) {
            this.handleSetData(actualData);
        } else {
            this.sendBlockingUiMessage(7002, actualData);
        }
    }

    private void handleSetData(Object[] data) {
        if (data != null) {
            this.processData(data);
            this.getTableView().setModelDirty();
            this.updateView();
        }
    }

    public Object[] getData() {
        ArrayList<TableViewSectionProxy> sections = this.getSections();
        if (sections != null) {
            return sections.toArray();
        }
        return new Object[0];
    }

    private TableViewRowProxy rowProxyFor(Object row) {
        TableViewRowProxy rowProxy = null;
        if (row instanceof KrollDict) {
            KrollDict d = (KrollDict)row;
            rowProxy = new TableViewRowProxy(this.getTiContext());
            rowProxy.handleCreationDict(d);
            rowProxy.setProperty("className", CLASSNAME_NORMAL);
            rowProxy.setProperty("rowData", row);
        } else {
            rowProxy = (TableViewRowProxy)((Object)row);
        }
        rowProxy.setParent(this);
        return rowProxy;
    }

    private boolean locateIndex(int index, RowResult rowResult) {
        boolean found = false;
        int rowCount = 0;
        int sectionIndex = 0;
        for (TableViewSectionProxy section : this.getSections()) {
            int sectionRowCount = (int)section.getRowCount();
            if (sectionRowCount + rowCount > index) {
                rowResult.section = section;
                rowResult.sectionIndex = sectionIndex;
                rowResult.row = section.getRows()[index - rowCount];
                rowResult.rowIndexInSection = index - rowCount;
                found = true;
                break;
            }
            rowCount += sectionRowCount;
            ++sectionIndex;
        }
        return found;
    }

    public void updateView() {
        if (this.getTiContext().isUIThread()) {
            this.getTableView().updateView();
            return;
        }
        this.sendBlockingUiMessage(7000, null);
    }

    public void scrollToIndex(int index) {
        Message msg = this.getUIHandler().obtainMessage(7001);
        msg.arg1 = index;
        msg.sendToTarget();
    }

    public void scrollToTop(int index) {
        Message msg = this.getUIHandler().obtainMessage(7006);
        msg.arg1 = index;
        msg.sendToTarget();
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 7000) {
            this.getTableView().updateView();
            ((AsyncResult)msg.obj).setResult((Object)0);
            return true;
        }
        if (msg.what == 7001) {
            this.getTableView().scrollToIndex(msg.arg1);
            return true;
        }
        if (msg.what == 7002) {
            AsyncResult result = (AsyncResult)msg.obj;
            Object[] data = (Object[])result.getArg();
            this.handleSetData(data);
            result.setResult((Object)0);
            return true;
        }
        if (msg.what == 7004) {
            AsyncResult result = (AsyncResult)msg.obj;
            if (msg.arg1 == 1) {
                this.handleInsertRowAfter(msg.arg2, result.getArg());
            } else {
                this.handleInsertRowBefore(msg.arg2, result.getArg());
            }
            result.setResult((Object)0);
            return true;
        }
        if (msg.what == 7005) {
            AsyncResult result = (AsyncResult)msg.obj;
            this.handleAppendRow(result.getArg());
            result.setResult((Object)0);
            return true;
        }
        if (msg.what == 7003) {
            this.handleDeleteRow(msg.arg1);
            return true;
        }
        if (msg.what == 7006) {
            this.getTableView().scrollToTop(msg.arg1);
            return true;
        }
        return super.handleMessage(msg);
    }

    public void eventListenerAdded(String eventName, int count, KrollProxy proxy) {
        super.eventListenerAdded(eventName, count, proxy);
        if (eventName.equals("click") && proxy == this) {
            for (TableViewSectionProxy section : this.getSections()) {
                for (TableViewRowProxy row : section.getRows()) {
                    row.setLabelsClickable(true);
                }
            }
        }
    }

    public void eventListenerRemoved(String eventName, int count, KrollProxy proxy) {
        super.eventListenerRemoved(eventName, count, proxy);
        if (eventName.equals("click") && count == 0 && proxy == this) {
            for (TableViewSectionProxy section : this.getSections()) {
                for (TableViewRowProxy row : section.getRows()) {
                    row.setLabelsClickable(false);
                }
            }
        }
    }

    class RowResult {
        int sectionIndex;
        TableViewSectionProxy section;
        TableViewRowProxy row;
        int rowIndexInSection;

        RowResult() {
        }
    }
}

