/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.view.View;
import android.widget.TabHost;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.TiActivity;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.proxy.TiWindowProxy;
import org.appcelerator.titanium.util.AsyncResult;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiUIHelper;
import org.appcelerator.titanium.view.TiDrawableReference;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.TabProxy;
import ti.modules.titanium.ui.TiTabActivity;
import ti.modules.titanium.ui.WindowProxy;
import ti.modules.titanium.ui.widget.TiUITabGroup;

public class TabGroupProxy
extends TiWindowProxy {
    private static final String LCAT = "TabGroupProxy";
    private static boolean DBG = TiConfig.LOGD;
    private static final int MSG_FIRST_ID = 2000;
    private static final int MSG_ADD_TAB = 2100;
    private static final int MSG_REMOVE_TAB = 2101;
    private static final int MSG_FINISH_OPEN = 2102;
    protected static final int MSG_LAST_ID = 2999;
    private ArrayList<TabProxy> tabs;
    private WeakReference<TiTabActivity> weakActivity;
    String windowId;
    Object initialActiveTab = null;

    public TabGroupProxy(TiContext tiContext) {
        super(tiContext);
    }

    public boolean requiresNewActivity(KrollDict extraOptions) {
        return true;
    }

    public TiUIView getView(Activity activity) {
        throw new IllegalStateException("call to getView on a Window");
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 2100: {
                AsyncResult result = (AsyncResult)msg.obj;
                this.handleAddTab((TabProxy)((Object)result.getArg()));
                result.setResult(null);
                return true;
            }
            case 2101: {
                AsyncResult result = (AsyncResult)msg.obj;
                this.handleRemoveTab((TabProxy)((Object)result.getArg()));
                result.setResult(null);
                return true;
            }
            case 2102: {
                TiTabActivity activity = (TiTabActivity)((Object)msg.obj);
                this.view = new TiUITabGroup((TiViewProxy)this, activity);
                this.modelListener = this.view;
                this.handlePostOpen((Activity)activity);
                return true;
            }
        }
        return super.handleMessage(msg);
    }

    public TabProxy[] getTabs() {
        TabProxy[] tps = null;
        if (this.tabs != null) {
            tps = this.tabs.toArray(new TabProxy[this.tabs.size()]);
        }
        return tps;
    }

    public ArrayList<TabProxy> getTabList() {
        return this.tabs;
    }

    public void addTab(TabProxy tab) {
        if (this.tabs == null) {
            this.tabs = new ArrayList();
        }
        if (this.getTiContext().isUIThread()) {
            this.handleAddTab(tab);
            return;
        }
        this.sendBlockingUiMessage(2100, (Object)tab);
    }

    private void handleAddTab(TabProxy tab) {
        String tag = TiConvert.toString((Object)tab.getProperty("tag"));
        if (tag == null) {
            String icon;
            String title = TiConvert.toString((Object)tab.getProperty("title"));
            tag = title == null ? ((icon = TiConvert.toString((Object)tab.getProperty("icon"))) == null ? tab.toString() : icon) : title;
            tab.setProperty("tag", tag, false);
        }
        if (this.tabs.size() == 0) {
            this.initialActiveTab = tab;
        }
        this.tabs.add(tab);
        if (this.peekView() != null) {
            TiUITabGroup tg = (TiUITabGroup)this.peekView();
            this.addTabToGroup(tg, tab);
        }
    }

    private void addTabToGroup(TiUITabGroup tg, TabProxy tab) {
        TiTabActivity tta = (TiTabActivity)((Object)this.weakActivity.get());
        if (tta == null && DBG) {
            Log.w((String)LCAT, (String)"Could not add tab because tab activity no longer exists");
        }
        Drawable icon = TiDrawableReference.fromObject((TiContext)this.getTiContext(), (Object)tab.getProperty("icon")).getDrawable();
        String tag = TiConvert.toString((Object)tab.getProperty("tag"));
        String title = TiConvert.toString((Object)tab.getProperty("title"));
        if (title == null) {
            title = "";
        }
        tab.setTabGroup(this);
        WindowProxy vp = (WindowProxy)((Object)tab.getProperty("window"));
        vp.setTabGroupProxy((TiViewProxy)this);
        vp.setTabProxy(tab);
        if (tag != null && vp != null) {
            TabHost.TabSpec tspec = tg.newTab(tag);
            if (icon == null) {
                tspec.setIndicator((CharSequence)title);
            } else {
                tspec.setIndicator((CharSequence)title, icon);
            }
            Intent intent = new Intent((Context)tta, TiActivity.class);
            vp.fillIntentForTab(intent);
            tspec.setContent(intent);
            tg.addTab(tspec);
        }
    }

    public void removeTab(TabProxy tab) {
    }

    public void handleRemoveTab(TabProxy tab) {
    }

    public void setActiveTab(Object tab) {
        if (this.peekView() != null) {
            TiUITabGroup tg = (TiUITabGroup)this.peekView();
            tg.changeActiveTab(tab);
        } else {
            this.initialActiveTab = tab;
        }
    }

    public TabProxy getActiveTab() {
        TabProxy activeTab = null;
        if (this.peekView() != null) {
            TiUITabGroup tg = (TiUITabGroup)this.peekView();
            int activeTabIndex = tg.getActiveTab();
            if (activeTabIndex < 0) {
                Log.e((String)LCAT, (String)("unable to get active tab, invalid index returned: " + activeTabIndex));
            } else if (activeTabIndex >= this.tabs.size()) {
                Log.e((String)LCAT, (String)("unable to get active tab, index is larger than tabs array: " + activeTabIndex));
            }
            activeTab = this.tabs.get(activeTabIndex);
        } else if (this.initialActiveTab instanceof Number) {
            int tabsIndex = TiConvert.toInt((Object)this.initialActiveTab);
            if (tabsIndex >= this.tabs.size()) {
                activeTab = this.tabs.get(tabsIndex);
            } else {
                Log.e((String)LCAT, (String)"Unable to get active tab, initialActiveTab index is larger than tabs array");
            }
        } else if (this.initialActiveTab instanceof TabProxy) {
            activeTab = (TabProxy)((Object)this.initialActiveTab);
        } else {
            Log.e((String)LCAT, (String)"Unable to get active tab, initialActiveTab is not recognized");
        }
        if (activeTab == null) {
            String errorMessage = "Failed to get activeTab, make sure tabs are added first before calling getActiveTab()";
            Log.e((String)LCAT, (String)errorMessage);
            throw new RuntimeException(errorMessage);
        }
        return activeTab;
    }

    protected void handleOpen(KrollDict options) {
        if (DBG) {
            Log.d((String)LCAT, (String)("handleOpen: " + options));
        }
        if (this.hasProperty("activeTab")) {
            this.initialActiveTab = this.getProperty("activeTab");
        }
        Activity activity = this.getTiContext().getActivity();
        Intent intent = new Intent((Context)activity, TiTabActivity.class);
        this.fillIntent(activity, intent);
        activity.startActivity(intent);
    }

    public void handlePostOpen(Activity activity) {
        ((TiTabActivity)activity).setTabGroupProxy(this);
        this.weakActivity = new WeakReference<TiTabActivity>((TiTabActivity)activity);
        TiUITabGroup tg = (TiUITabGroup)this.view;
        if (this.tabs != null) {
            for (TabProxy tab : this.tabs) {
                this.addTabToGroup(tg, tab);
            }
        }
        tg.changeActiveTab(this.initialActiveTab);
        this.opened = true;
        super.handlePostOpen();
        this.fireEvent("open", null);
    }

    protected void handleClose(KrollDict options) {
        if (DBG) {
            Log.d((String)LCAT, (String)("handleClose: " + options));
        }
        this.modelListener = null;
        if (this.weakActivity.get() != null) {
            ((TiTabActivity)((Object)this.weakActivity.get())).finish();
        }
        this.releaseViews();
        this.windowId = null;
        this.view = null;
        this.opened = false;
    }

    public KrollDict buildFocusEvent(String to, String from) {
        int toIndex = this.indexForId(to);
        int fromIndex = this.indexForId(from);
        return this.buildFocusEvent(toIndex, fromIndex);
    }

    public KrollDict buildFocusEvent(int toIndex, int fromIndex) {
        KrollDict e = new KrollDict();
        e.put((Object)"index", (Object)toIndex);
        e.put((Object)"previousIndex", (Object)fromIndex);
        if (fromIndex != -1) {
            e.put((Object)"previousTab", (Object)this.tabs.get(fromIndex));
        } else {
            KrollDict fakeTab = new KrollDict();
            fakeTab.put((Object)"title", (Object)"no tab");
            e.put((Object)"previousTab", (Object)fakeTab);
        }
        if (toIndex != -1) {
            e.put((Object)"tab", (Object)this.tabs.get(toIndex));
        }
        return e;
    }

    private int indexForId(String id) {
        int index = -1;
        int i = 0;
        for (TabProxy t : this.tabs) {
            String tag = (String)t.getProperty("tag");
            if (tag.equals(id)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private void fillIntent(Activity activity, Intent intent) {
        KrollDict props = this.getProperties();
        if (props != null) {
            if (props.containsKey((Object)"fullscreen")) {
                intent.putExtra("fullscreen", TiConvert.toBoolean((KrollDict)props, (String)"fullscreen"));
            }
            if (props.containsKey((Object)"navBarHidden")) {
                intent.putExtra("navBarHidden", TiConvert.toBoolean((KrollDict)props, (String)"navBarHidden"));
            }
            if (props.containsKey((Object)"windowSoftInputMode")) {
                intent.putExtra("windowSoftInputMode", TiConvert.toInt((KrollDict)props, (String)"windowSoftInputMode"));
            }
        }
        if (props != null && props.containsKey((Object)"exitOnClose")) {
            intent.putExtra("finishRoot", TiConvert.toBoolean((KrollDict)props, (String)"exitOnClose"));
        } else {
            intent.putExtra("finishRoot", activity.isTaskRoot());
        }
        Messenger messenger = new Messenger(this.getUIHandler());
        intent.putExtra("messenger", (Parcelable)messenger);
        intent.putExtra("messageId", 2102);
    }

    public KrollDict handleToImage() {
        return TiUIHelper.viewToImage((TiContext)this.getTiContext(), (KrollDict)this.properties, (View)this.getTiContext().getActivity().getWindow().getDecorView());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseViews() {
        super.releaseViews();
        if (this.tabs != null) {
            ArrayList<TabProxy> arrayList = this.tabs;
            synchronized (arrayList) {
                for (TabProxy t : this.tabs) {
                    t.setTabGroup(null);
                    t.releaseViews();
                }
            }
        }
    }

    protected Activity handleGetActivity() {
        return (Activity)this.weakActivity.get();
    }
}

