/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui;

import android.app.Activity;
import android.os.Message;
import android.view.animation.Animation;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.AsyncResult;
import org.appcelerator.titanium.util.TiEventHelper;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.widget.TiUIScrollableView;

public class ScrollableViewProxy
extends TiViewProxy
implements Animation.AnimationListener {
    private static final String EVENT_SCROLL = "scroll";
    private static final int MSG_FIRST_ID = 2000;
    public static final int MSG_SHOW_PAGER = 2100;
    public static final int MSG_HIDE_PAGER = 2101;
    public static final int MSG_MOVE_PREV = 2102;
    public static final int MSG_MOVE_NEXT = 2103;
    public static final int MSG_SCROLL_TO = 2104;
    public static final int MSG_SET_VIEWS = 2105;
    public static final int MSG_ADD_VIEW = 2106;
    public static final int MSG_SET_CURRENT = 2107;
    public static final int MSG_REMOVE_VIEW = 2108;
    public static final int MSG_LAST_ID = 2999;
    protected AtomicBoolean inAnimation = new AtomicBoolean(false);
    protected AtomicBoolean inScroll = new AtomicBoolean(false);

    public ScrollableViewProxy(TiContext context) {
        super(context);
    }

    public TiUIView createView(Activity activity) {
        return new TiUIScrollableView(this, this.getUIHandler());
    }

    protected TiUIScrollableView getView() {
        return (TiUIScrollableView)this.getView(this.getTiContext().getActivity());
    }

    public boolean handleMessage(Message msg) {
        boolean handled = false;
        switch (msg.what) {
            case 2100: {
                this.getView().showPager();
                break;
            }
            case 2101: {
                this.getView().hidePager();
                handled = true;
                break;
            }
            case 2102: {
                this.inScroll.set(true);
                this.getView().doMovePrevious();
                this.inScroll.set(false);
                handled = true;
                break;
            }
            case 2103: {
                this.inScroll.set(true);
                this.getView().doMoveNext();
                this.inScroll.set(false);
                handled = true;
                break;
            }
            case 2104: {
                this.inScroll.set(true);
                this.getView().doScrollToView(msg.obj);
                this.inScroll.set(false);
                handled = true;
                break;
            }
            case 2107: {
                this.getView().doSetCurrentPage(msg.obj);
                handled = true;
                break;
            }
            case 2105: {
                AsyncResult holder = (AsyncResult)msg.obj;
                Object views = holder.getArg();
                this.getView().setViews(views);
                holder.setResult(null);
                handled = true;
                break;
            }
            case 2106: {
                AsyncResult holder = (AsyncResult)msg.obj;
                Object view = holder.getArg();
                if (view instanceof TiViewProxy) {
                    this.getView().addView((TiViewProxy)view);
                    handled = true;
                }
                holder.setResult(null);
                break;
            }
            case 2108: {
                AsyncResult holder = (AsyncResult)msg.obj;
                Object view = holder.getArg();
                if (view instanceof TiViewProxy) {
                    this.getView().removeView((TiViewProxy)view);
                    handled = true;
                }
                holder.setResult(null);
                break;
            }
            default: {
                handled = super.handleMessage(msg);
            }
        }
        return handled;
    }

    public Object getViews() {
        ArrayList list = new ArrayList();
        return this.getView().getViews().toArray(new TiViewProxy[list.size()]);
    }

    public void setViews(Object viewsObject) {
        this.sendBlockingUiMessage(2105, viewsObject);
    }

    public void addView(Object viewObject) {
        this.sendBlockingUiMessage(2106, viewObject);
    }

    public void removeView(Object viewObject) {
        this.sendBlockingUiMessage(2108, viewObject);
    }

    public void scrollToView(Object view) {
        if (this.inScroll.get()) {
            return;
        }
        this.getUIHandler().obtainMessage(2104, view).sendToTarget();
    }

    public void movePrevious() {
        if (this.inScroll.get() || this.inAnimation.get()) {
            return;
        }
        this.getUIHandler().removeMessages(2102);
        this.getUIHandler().sendEmptyMessage(2102);
    }

    public void moveNext() {
        if (this.inScroll.get() || this.inAnimation.get()) {
            return;
        }
        this.getUIHandler().removeMessages(2103);
        this.getUIHandler().sendEmptyMessage(2103);
    }

    public void setPagerTimeout() {
        this.getUIHandler().removeMessages(2101);
        this.getUIHandler().sendEmptyMessageDelayed(2101, 3000L);
    }

    public void setShowPagingControl(boolean showPagingControl) {
        this.getView().setShowPagingControl(showPagingControl);
        if (!showPagingControl) {
            this.getUIHandler().sendEmptyMessage(2101);
        } else {
            this.getUIHandler().sendEmptyMessage(2100);
        }
    }

    public void fireScroll(int to) {
        if (this.hasListeners(EVENT_SCROLL)) {
            KrollDict options = new KrollDict();
            options.put((Object)"index", (Object)to);
            options.put((Object)"view", (Object)this);
            options.put((Object)"currentPage", (Object)this.getView().getCurrentPage());
            TiEventHelper.fireViewEvent((TiViewProxy)this, (String)EVENT_SCROLL, (Map)options);
        }
    }

    public int getCurrentPage() {
        return this.getView().getCurrentPage();
    }

    public void setCurrentPage(Object page) {
        this.getUIHandler().obtainMessage(2107, page).sendToTarget();
    }

    public void onAnimationRepeat(Animation anim) {
    }

    public void onAnimationEnd(Animation anim) {
        this.inAnimation.set(false);
    }

    public void onAnimationStart(Animation anim) {
        this.inAnimation.set(true);
    }

    public void releaseViews() {
        this.getUIHandler().removeMessages(2100);
        this.getUIHandler().removeMessages(2101);
        super.releaseViews();
    }
}

