/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui;

import android.app.Activity;
import android.os.Handler;
import android.os.Message;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.AsyncResult;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.widget.TiUIScrollView;

public class ScrollViewProxy
extends TiViewProxy
implements Handler.Callback {
    private static final int MSG_FIRST_ID = 1000;
    private static final int MSG_SCROLL_TO = 1100;
    private static final int MSG_SCROLL_TO_BOTTOM = 1101;
    protected static final int MSG_LAST_ID = 1999;

    public ScrollViewProxy(TiContext context) {
        super(context);
    }

    public TiUIView createView(Activity activity) {
        return new TiUIScrollView(this);
    }

    public TiUIScrollView getScrollView(Activity activity) {
        return (TiUIScrollView)this.getView(activity);
    }

    public void scrollTo(int x, int y) {
        if (!this.getTiContext().isUIThread()) {
            this.sendBlockingUiMessage(1100, this.getTiContext().getActivity(), x, y);
        } else {
            this.handleScrollTo(x, y);
        }
    }

    public void scrollToBottom() {
        if (!this.getTiContext().isUIThread()) {
            this.sendBlockingUiMessage(1101, this.getTiContext().getActivity());
        } else {
            this.handleScrollToBottom();
        }
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 1100) {
            this.handleScrollTo(msg.arg1, msg.arg2);
            AsyncResult result = (AsyncResult)msg.obj;
            result.setResult(null);
            return true;
        }
        if (msg.what == 1101) {
            this.handleScrollToBottom();
            AsyncResult result = (AsyncResult)msg.obj;
            result.setResult(null);
            return true;
        }
        return super.handleMessage(msg);
    }

    public void handleScrollTo(int x, int y) {
        this.getScrollView(this.getTiContext().getActivity()).scrollTo(x, y);
    }

    public void handleScrollToBottom() {
        this.getScrollView(this.getTiContext().getActivity()).scrollToBottom();
    }
}

