/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import android.util.Log;
import android.widget.DatePicker;
import android.widget.TimePicker;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.annotations.Kroll;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.AsyncResult;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.PickerColumnProxy;
import ti.modules.titanium.ui.PickerRowProxy;
import ti.modules.titanium.ui.widget.picker.TiUIDatePicker;
import ti.modules.titanium.ui.widget.picker.TiUIDateSpinner;
import ti.modules.titanium.ui.widget.picker.TiUINativePicker;
import ti.modules.titanium.ui.widget.picker.TiUIPicker;
import ti.modules.titanium.ui.widget.picker.TiUISpinner;
import ti.modules.titanium.ui.widget.picker.TiUITimePicker;
import ti.modules.titanium.ui.widget.picker.TiUITimeSpinner;

public class PickerProxy
extends TiViewProxy
implements PickerColumnProxy.PickerColumnListener {
    private int type = -1;
    private ArrayList<Integer> preselectedRows = new ArrayList();
    private static final String LCAT = "PickerProxy";
    public static final int DEFAULT_VISIBLE_ITEMS_COUNT = 5;
    private static final int MSG_FIRST_ID = 2000;
    private static final int MSG_SELECT_ROW = 2101;
    private static final int MSG_SET_COLUMNS = 2102;
    private static final int MSG_ADD = 2103;
    private static final int MSG_REMOVE = 2104;
    private static final int MSG_FIRE_COL_CHANGE = 2105;
    private static final int MSG_FIRE_ROW_CHANGE = 2106;
    private static final int MSG_FORCE_LAYOUT = 2107;
    private boolean useSpinner = false;

    public PickerProxy(TiContext tiContext) {
        super(tiContext);
    }

    public void handleCreationDict(KrollDict dict) {
        super.handleCreationDict(dict);
        if (dict.containsKey((Object)"useSpinner")) {
            this.useSpinner = TiConvert.toBoolean((KrollDict)dict, (String)"useSpinner");
        }
        if (this.hasProperty("type")) {
            this.type = this.getProperties().getInt("type");
        }
        if (dict.containsKey((Object)"columns")) {
            this.setColumns(dict.get((Object)"columns"));
        }
    }

    public TiUIView createView(Activity activity) {
        if (this.type == 3) {
            Log.w((String)LCAT, (String)"Countdown timer not supported in Titanium for Android");
            return null;
        }
        if (this.type == 2) {
            Log.w((String)LCAT, (String)"Date+Time timer not supported in Titanium for Android");
            return null;
        }
        if (this.type == -1) {
            return this.createPlainPicker(activity, this.useSpinner);
        }
        if (this.type == 1) {
            if (this.useSpinner) {
                return this.createDateSpinner(activity);
            }
            return this.createDatePicker(activity);
        }
        if (this.type == 0) {
            if (this.useSpinner) {
                return this.createTimeSpinner(activity);
            }
            return this.createTimePicker(activity);
        }
        Log.w((String)LCAT, (String)"Unknown picker type");
        return null;
    }

    private TiUIView createPlainPicker(Activity activity, boolean useSpinner) {
        TiUIPicker picker = useSpinner ? new TiUISpinner(this, activity) : new TiUINativePicker(this, activity);
        return picker;
    }

    private TiUIView createDatePicker(Activity activity) {
        return new TiUIDatePicker(this, activity);
    }

    private TiUIView createTimePicker(Activity activity) {
        return new TiUITimePicker(this, activity);
    }

    private TiUIView createTimeSpinner(Activity activity) {
        return new TiUITimeSpinner(this, activity);
    }

    private TiUIView createDateSpinner(Activity activity) {
        return new TiUIDateSpinner(this, activity);
    }

    public boolean getUseSpinner() {
        return this.useSpinner;
    }

    public void setUseSpinner(boolean value) {
        if (this.peekView() != null) {
            Log.w((String)LCAT, (String)"Attempt to change useSpinner property after view has already been created. Ignoring.");
        } else {
            this.useSpinner = value;
            if (this.children != null && this.children.size() > 0) {
                for (TiViewProxy child : this.children) {
                    if (!(child instanceof PickerColumnProxy)) continue;
                    ((PickerColumnProxy)child).setUseSpinner(value);
                }
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (this.peekView() != null) {
            Log.e((String)LCAT, (String)"Attempt to change picker type after view has been created.");
            throw new IllegalStateException("You cannot change the picker type after it has been rendered.");
        }
        this.type = type;
    }

    private boolean isPlainPicker() {
        return this.type == -1;
    }

    public void remove(TiViewProxy child) {
        if (this.getTiContext().isUIThread() || this.peekView() == null) {
            this.handleRemoveColumn(child);
        } else {
            this.sendBlockingUiMessage(2104, child);
        }
    }

    private void handleRemoveColumn(TiViewProxy child) {
        int index = -1;
        if (this.children.contains(child)) {
            index = this.children.indexOf(child);
        }
        super.remove(child);
        if (this.peekView() instanceof TiUIPicker) {
            ((TiUIPicker)this.peekView()).onColumnRemoved(index);
        }
    }

    public void add(TiViewProxy child) {
        this.add((Object)child);
    }

    public void add(Object child) {
        if (!this.isPlainPicker()) {
            Log.w((String)LCAT, (String)"Attempt to add to date/time or countdown picker ignored.");
            return;
        }
        if (this.getTiContext().isUIThread() || this.peekView() == null) {
            this.handleAddObject(child);
        } else {
            this.sendBlockingUiMessage(2103, child);
        }
    }

    private void handleAddObject(Object child) {
        if (child instanceof PickerColumnProxy) {
            PickerColumnProxy column = (PickerColumnProxy)child;
            this.prepareColumn(column);
            super.add((TiViewProxy)column);
            if (this.peekView() instanceof TiUIPicker) {
                ((TiUIPicker)this.peekView()).onColumnAdded(this.children.indexOf(column));
            }
        } else if (child instanceof PickerRowProxy) {
            this.getFirstColumn(true).add((PickerRowProxy)((Object)child));
        } else if (child.getClass().isArray()) {
            this.getFirstColumn(true).addRows((Object[])child);
        } else {
            Log.w((String)LCAT, (String)("Unexpected type not added to picker: " + child.getClass().getName()));
        }
    }

    private void prepareColumn(PickerColumnProxy column) {
        column.setUseSpinner(this.useSpinner);
        column.setColumnListener(this);
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 2101: {
                AsyncResult result = (AsyncResult)msg.obj;
                this.handleSelectRow((KrollDict)result.getArg());
                result.setResult(null);
                return true;
            }
            case 2102: {
                AsyncResult result = (AsyncResult)msg.obj;
                this.handleSetColumns(result.getArg());
                result.setResult(null);
                return true;
            }
            case 2103: {
                AsyncResult result = (AsyncResult)msg.obj;
                this.handleAddObject(result.getArg());
                result.setResult(null);
                return true;
            }
            case 2104: {
                AsyncResult result = (AsyncResult)msg.obj;
                this.handleRemoveColumn((TiViewProxy)result.getArg());
                result.setResult(null);
                return true;
            }
            case 2105: {
                this.handleFireColumnModelChange(msg.arg1);
                return true;
            }
            case 2106: {
                this.handleFireRowChange(msg.arg1, msg.arg2);
                return true;
            }
            case 2107: {
                this.handleForceRequestLayout();
                return true;
            }
        }
        return super.handleMessage(msg);
    }

    public void setSelectedRow(int column, int row, @Kroll.argument(optional=true) boolean animated) {
        if (!this.isPlainPicker()) {
            Log.w((String)LCAT, (String)"Selecting row in date/time or countdown picker is not supported.");
            return;
        }
        TiUIView view = this.peekView();
        if (view == null) {
            if (this.preselectedRows == null) {
                this.preselectedRows = new ArrayList();
            }
            while (this.preselectedRows.size() < column + 1) {
                this.preselectedRows.add(null);
            }
            if (this.preselectedRows.size() >= column + 1) {
                this.preselectedRows.remove(column);
            }
            this.preselectedRows.add(column, new Integer(row));
            return;
        }
        if (this.getTiContext().isUIThread()) {
            this.handleSelectRow(column, row, animated);
        } else {
            KrollDict dict = new KrollDict();
            dict.put((Object)"column", (Object)new Integer(column));
            dict.put((Object)"row", (Object)new Integer(row));
            dict.put((Object)"animated", (Object)new Boolean(animated));
            this.sendBlockingUiMessage(2101, dict);
        }
    }

    public PickerRowProxy getSelectedRow(int columnIndex) {
        int rowIndex;
        if (!this.isPlainPicker()) {
            Log.w((String)LCAT, (String)"Cannot get selected row in date/time or countdown picker.");
            return null;
        }
        if (!(this.peekView() instanceof TiUIPicker)) {
            return null;
        }
        PickerRowProxy row = null;
        if (this.peekView() instanceof TiUIPicker && (rowIndex = ((TiUIPicker)this.peekView()).getSelectedRowIndex(columnIndex)) >= 0) {
            row = this.getRow(columnIndex, rowIndex);
        }
        return row;
    }

    public PickerColumnProxy[] getColumns() {
        if (!this.isPlainPicker()) {
            Log.w((String)LCAT, (String)"Cannot get columns from date/time or countdown picker.");
            return null;
        }
        if (this.children == null) {
            return new PickerColumnProxy[0];
        }
        return this.children.toArray(new PickerColumnProxy[this.children.size()]);
    }

    public void setColumns(Object passedColumns) {
        if (!this.isPlainPicker()) {
            Log.w((String)LCAT, (String)"Cannot set columns in date/time or countdown picker.");
            return;
        }
        if (this.getTiContext().isUIThread() || this.peekView() == null) {
            this.handleSetColumns(passedColumns);
        } else {
            this.sendBlockingUiMessage(2102, passedColumns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSetColumns(Object passedColumns) {
        TiUIPicker pickerView;
        boolean dirty = false;
        try {
            if (this.peekView() instanceof TiUIPicker) {
                ((TiUIPicker)this.peekView()).batchModelChange = true;
            }
            if (this.children != null && this.children.size() > 0) {
                int count = this.children.size();
                for (int i = count - 1; i >= 0; --i) {
                    this.remove((TiViewProxy)this.children.get(i));
                    dirty = true;
                }
            }
            Object[] columns = null;
            columns = passedColumns.getClass().isArray() ? (Object[])passedColumns : new Object[]{passedColumns};
            if (!(columns[0] instanceof PickerColumnProxy)) {
                Log.w((String)LCAT, (String)"Unexpected object type ignored for setColumns");
            } else {
                for (Object o : columns) {
                    if (!(o instanceof PickerColumnProxy)) continue;
                    this.add((PickerColumnProxy)o);
                    dirty = true;
                }
            }
        }
        finally {
            if (this.peekView() instanceof TiUIPicker) {
                ((TiUIPicker)this.peekView()).batchModelChange = false;
            }
        }
        if (dirty && (pickerView = (TiUIPicker)this.peekView()) != null) {
            pickerView.onModelReplaced();
        }
    }

    private void handleSelectRow(KrollDict dict) {
        this.handleSelectRow(dict.getInt("column"), dict.getInt("row"), dict.getBoolean("animated"));
    }

    private void handleSelectRow(int column, int row, boolean animated) {
        if (this.peekView() == null) {
            return;
        }
        ((TiUIPicker)this.peekView()).selectRow(column, row, animated);
    }

    public int getColumnCount() {
        PickerColumnProxy[] columns = this.getColumns();
        if (columns == null) {
            return 0;
        }
        return columns.length;
    }

    public PickerColumnProxy getColumn(int index) {
        if (this.children == null || index >= this.children.size() || !(this.children.get(index) instanceof PickerColumnProxy)) {
            return null;
        }
        return (PickerColumnProxy)this.children.get(index);
    }

    public int getColumnIndex(PickerColumnProxy column) {
        if (this.children != null && this.children.size() > 0) {
            return this.children.indexOf(column);
        }
        return -1;
    }

    public PickerRowProxy getRow(int columnIndex, int rowIndex) {
        PickerColumnProxy column = this.getColumn(columnIndex);
        if (column == null) {
            return null;
        }
        TiViewProxy[] rowArray = column.getChildren();
        if (rowArray == null || rowIndex >= rowArray.length || !(rowArray[rowIndex] instanceof PickerRowProxy)) {
            return null;
        }
        return (PickerRowProxy)rowArray[rowIndex];
    }

    public PickerColumnProxy getFirstColumn(boolean createIfMissing) {
        PickerColumnProxy column = this.getColumn(0);
        if (column == null && createIfMissing) {
            column = new PickerColumnProxy(this.getTiContext());
            this.add(column);
        }
        return column;
    }

    public void showDatePickerDialog(KrollInvocation invocation, Object[] args) {
        Object typeTest;
        KrollDict settings = new KrollDict();
        final AtomicInteger callbackCount = new AtomicInteger(0);
        if (args.length > 0) {
            settings = (KrollDict)args[0];
        }
        Calendar calendar = Calendar.getInstance();
        if (settings.containsKey((Object)"value")) {
            calendar.setTime(TiConvert.toDate((KrollDict)settings, (String)"value"));
        }
        final KrollCallback callback = settings.containsKey((Object)"callback") ? ((typeTest = settings.get((Object)"callback")) instanceof KrollCallback ? (KrollCallback)typeTest : null) : null;
        DatePickerDialog.OnDateSetListener dateSetListener = null;
        DialogInterface.OnDismissListener dismissListener = null;
        if (callback != null) {
            dateSetListener = new DatePickerDialog.OnDateSetListener(){

                public void onDateSet(DatePicker picker, int year, int monthOfYear, int dayOfMonth) {
                    if (callback != null) {
                        callbackCount.incrementAndGet();
                        Calendar calendar = Calendar.getInstance();
                        calendar.set(1, year);
                        calendar.set(2, monthOfYear);
                        calendar.set(5, dayOfMonth);
                        Date value = calendar.getTime();
                        KrollDict data = new KrollDict();
                        data.put((Object)"cancel", (Object)false);
                        data.put((Object)"value", (Object)value);
                        callback.callAsync(new Object[]{data});
                    }
                }
            };
            dismissListener = new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    if (callbackCount.get() == 0 && callback != null) {
                        callbackCount.incrementAndGet();
                        KrollDict data = new KrollDict();
                        data.put((Object)"cancel", (Object)true);
                        data.put((Object)"value", null);
                        callback.callAsync(new Object[]{data});
                    }
                }
            };
        }
        DatePickerDialog dialog = new DatePickerDialog((Context)invocation.getActivity(), dateSetListener, calendar.get(1), calendar.get(2), calendar.get(5));
        dialog.setCancelable(true);
        if (dismissListener != null) {
            dialog.setOnDismissListener(dismissListener);
        }
        if (settings.containsKey((Object)"title")) {
            dialog.setTitle((CharSequence)TiConvert.toString((KrollDict)settings, (String)"title"));
        }
        dialog.show();
        if (settings.containsKey((Object)"okButtonTitle")) {
            dialog.getButton(-1).setText((CharSequence)TiConvert.toString((KrollDict)settings, (String)"okButtonTitle"));
        }
    }

    public void showTimePickerDialog(KrollInvocation invocation, Object[] args) {
        Object typeTest;
        KrollDict settings = new KrollDict();
        boolean is24HourView = false;
        final AtomicInteger callbackCount = new AtomicInteger(0);
        if (args.length > 0) {
            settings = (KrollDict)args[0];
        }
        if (settings.containsKey((Object)"format24")) {
            is24HourView = TiConvert.toBoolean((KrollDict)settings, (String)"format24");
        }
        Calendar calendar = Calendar.getInstance();
        if (settings.containsKey((Object)"value")) {
            calendar.setTime(TiConvert.toDate((KrollDict)settings, (String)"value"));
        }
        final KrollCallback callback = settings.containsKey((Object)"callback") ? ((typeTest = settings.get((Object)"callback")) instanceof KrollCallback ? (KrollCallback)typeTest : null) : null;
        TimePickerDialog.OnTimeSetListener timeSetListener = null;
        DialogInterface.OnDismissListener dismissListener = null;
        if (callback != null) {
            timeSetListener = new TimePickerDialog.OnTimeSetListener(){

                public void onTimeSet(TimePicker field, int hourOfDay, int minute) {
                    if (callback != null) {
                        callbackCount.incrementAndGet();
                        Calendar calendar = Calendar.getInstance();
                        calendar.set(11, hourOfDay);
                        calendar.set(12, minute);
                        Date value = calendar.getTime();
                        KrollDict data = new KrollDict();
                        data.put((Object)"cancel", (Object)false);
                        data.put((Object)"value", (Object)value);
                        callback.callAsync(new Object[]{data});
                    }
                }
            };
            dismissListener = new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    if (callbackCount.get() == 0 && callback != null) {
                        callbackCount.incrementAndGet();
                        KrollDict data = new KrollDict();
                        data.put((Object)"cancel", (Object)true);
                        data.put((Object)"value", null);
                        callback.callAsync(new Object[]{data});
                    }
                }
            };
        }
        TimePickerDialog dialog = new TimePickerDialog((Context)invocation.getActivity(), timeSetListener, calendar.get(11), calendar.get(12), is24HourView);
        dialog.setCancelable(true);
        if (dismissListener != null) {
            dialog.setOnDismissListener(dismissListener);
        }
        if (settings.containsKey((Object)"title")) {
            dialog.setTitle((CharSequence)TiConvert.toString((KrollDict)settings, (String)"title"));
        }
        dialog.show();
        if (settings.containsKey((Object)"okButtonTitle")) {
            dialog.getButton(-1).setText((CharSequence)TiConvert.toString((KrollDict)settings, (String)"okButtonTitle"));
        }
    }

    private void fireColumnModelChange(int columnIndex) {
        if (!(this.peekView() instanceof TiUIPicker)) {
            return;
        }
        if (this.getTiContext().isUIThread()) {
            this.handleFireColumnModelChange(columnIndex);
        } else {
            Message msg = this.getUIHandler().obtainMessage(2105);
            msg.arg1 = columnIndex;
            msg.sendToTarget();
        }
    }

    private void handleFireColumnModelChange(int columnIndex) {
        if (this.peekView() instanceof TiUIPicker) {
            ((TiUIPicker)this.peekView()).onColumnModelChanged(columnIndex);
        }
    }

    private void fireRowChange(int columnIndex, int rowIndex) {
        if (!(this.peekView() instanceof TiUIPicker)) {
            return;
        }
        if (this.getTiContext().isUIThread()) {
            this.handleFireRowChange(columnIndex, rowIndex);
        } else {
            Message msg = this.getUIHandler().obtainMessage(2106);
            msg.arg1 = columnIndex;
            msg.arg2 = rowIndex;
            msg.sendToTarget();
        }
    }

    private void handleFireRowChange(int columnIndex, int rowIndex) {
        if (this.peekView() instanceof TiUIPicker) {
            ((TiUIPicker)this.peekView()).onRowChanged(columnIndex, rowIndex);
        }
    }

    public void fireSelectionChange(int columnIndex, int rowIndex) {
        KrollDict d = new KrollDict();
        d.put((Object)"columnIndex", (Object)columnIndex);
        d.put((Object)"rowIndex", (Object)rowIndex);
        PickerColumnProxy column = this.getColumn(columnIndex);
        PickerRowProxy row = this.getRow(columnIndex, rowIndex);
        d.put((Object)"column", (Object)column);
        d.put((Object)"row", (Object)row);
        int columnCount = this.getColumnCount();
        ArrayList<String> selectedValues = new ArrayList<String>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            PickerRowProxy rowInColumn = this.getSelectedRow(i);
            if (rowInColumn != null) {
                selectedValues.add(rowInColumn.toString());
                continue;
            }
            selectedValues.add(null);
        }
        d.put((Object)"selectedValue", (Object)selectedValues.toArray());
        this.fireEvent("change", d);
    }

    @Override
    public void rowAdded(PickerColumnProxy column, int rowIndex) {
        this.fireColumnModelChange(this.children.indexOf(column));
    }

    @Override
    public void rowRemoved(PickerColumnProxy column, int oldRowIndex) {
        this.fireColumnModelChange(this.children.indexOf(column));
    }

    @Override
    public void rowsReplaced(PickerColumnProxy column) {
        this.fireColumnModelChange(this.children.indexOf(column));
    }

    @Override
    public void rowChanged(PickerColumnProxy column, int rowIndex) {
        this.fireRowChange(this.children.indexOf(column), rowIndex);
    }

    @Override
    public void rowSelected(PickerColumnProxy column, int rowIndex) {
        int columnIndex = this.children.indexOf(column);
        this.fireSelectionChange(columnIndex, rowIndex);
    }

    public ArrayList<Integer> getPreselectedRows() {
        return this.preselectedRows;
    }

    public void forceRequestLayout() {
        if (!(this.peekView() instanceof TiUISpinner)) {
            return;
        }
        if (this.getTiContext().isUIThread()) {
            this.handleForceRequestLayout();
        } else {
            this.getUIHandler().obtainMessage(2107).sendToTarget();
        }
    }

    private void handleForceRequestLayout() {
        ((TiUISpinner)this.view).forceRequestLayout();
    }
}

