/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui;

import android.app.Activity;
import android.os.Message;
import android.util.Log;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.AsyncResult;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.PickerProxy;
import ti.modules.titanium.ui.PickerRowProxy;
import ti.modules.titanium.ui.widget.picker.TiUIPickerColumn;
import ti.modules.titanium.ui.widget.picker.TiUISpinnerColumn;

public class PickerColumnProxy
extends TiViewProxy
implements PickerRowProxy.PickerRowListener {
    private static final String LCAT = "PickerColumnProxy";
    private static final int MSG_FIRST_ID = 2000;
    private static final int MSG_ADD = 2100;
    private static final int MSG_REMOVE = 2101;
    private static final int MSG_SET_ROWS = 2102;
    private PickerColumnListener columnListener = null;
    private boolean useSpinner = false;
    private boolean suppressListenerEvents = false;

    public PickerColumnProxy(TiContext tiContext) {
        super(tiContext);
    }

    public void setColumnListener(PickerColumnListener listener) {
        this.columnListener = listener;
    }

    public void setUseSpinner(boolean value) {
        this.useSpinner = value;
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 2100: {
                AsyncResult result = (AsyncResult)msg.obj;
                this.handleAddRow((TiViewProxy)result.getArg());
                result.setResult(null);
                return true;
            }
            case 2101: {
                AsyncResult result = (AsyncResult)msg.obj;
                this.handleRemoveRow((TiViewProxy)result.getArg());
                result.setResult(null);
                return true;
            }
            case 2102: {
                AsyncResult result = (AsyncResult)msg.obj;
                this.handleSetRows((Object[])result.getArg());
                result.setResult(null);
                return true;
            }
        }
        return super.handleMessage(msg);
    }

    public void handleCreationDict(KrollDict dict) {
        Object rowsAtCreation;
        super.handleCreationDict(dict);
        if (this.hasProperty("rows") && (rowsAtCreation = this.getProperty("rows")).getClass().isArray()) {
            Object[] rowsArray = (Object[])rowsAtCreation;
            this.addRows(rowsArray);
        }
    }

    public void add(TiViewProxy o) {
        if (this.getTiContext().isUIThread() || this.peekView() == null) {
            this.handleAddRow(o);
        } else {
            this.sendBlockingUiMessage(2100, o);
        }
    }

    private void handleAddRow(TiViewProxy o) {
        if (o == null) {
            return;
        }
        if (o instanceof PickerRowProxy) {
            ((PickerRowProxy)o).setRowListener(this);
            super.add((TiViewProxy)((PickerRowProxy)o));
            if (this.columnListener != null && !this.suppressListenerEvents) {
                int index = this.children.indexOf(o);
                this.columnListener.rowAdded(this, index);
            }
        } else {
            Log.w((String)LCAT, (String)("add() unsupported argument type: " + o.getClass().getSimpleName()));
        }
    }

    public void remove(TiViewProxy o) {
        if (this.getTiContext().isUIThread() || this.peekView() == null) {
            this.handleRemoveRow(o);
        } else {
            this.sendBlockingUiMessage(2101, o);
        }
    }

    private void handleRemoveRow(TiViewProxy o) {
        if (o == null) {
            return;
        }
        if (o instanceof PickerRowProxy) {
            int index = this.children.indexOf(o);
            super.remove((TiViewProxy)((PickerRowProxy)o));
            if (this.columnListener != null && !this.suppressListenerEvents) {
                this.columnListener.rowRemoved(this, index);
            }
        } else {
            Log.w((String)LCAT, (String)("remove() unsupported argment type: " + o.getClass().getSimpleName()));
        }
    }

    public void addRow(PickerRowProxy row) {
        this.add(row);
    }

    protected void addRows(Object[] rows) {
        for (Object obj : rows) {
            if (obj instanceof PickerRowProxy) {
                this.add((PickerRowProxy)((Object)obj));
                continue;
            }
            Log.w((String)LCAT, (String)("Unexpected type not added to picker column: " + obj.getClass().getName()));
        }
    }

    public void removeRow(PickerRowProxy row) {
        this.remove(row);
    }

    public PickerRowProxy[] getRows() {
        if (this.children == null || this.children.size() == 0) {
            return null;
        }
        return this.children.toArray(new PickerRowProxy[this.children.size()]);
    }

    public void setRows(Object[] rows) {
        if (this.getTiContext().isUIThread() || this.peekView() == null) {
            this.handleSetRows(rows);
        } else {
            this.sendBlockingUiMessage(2102, rows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSetRows(Object[] rows) {
        try {
            this.suppressListenerEvents = true;
            if (this.children != null && this.children.size() > 0) {
                int count = this.children.size();
                for (int i = count - 1; i >= 0; --i) {
                    this.remove((TiViewProxy)this.children.get(i));
                }
            }
            this.addRows(rows);
        }
        finally {
            this.suppressListenerEvents = false;
        }
        if (this.columnListener != null) {
            this.columnListener.rowsReplaced(this);
        }
    }

    public int getRowCount() {
        return this.children.size();
    }

    public TiUIView createView(Activity activity) {
        if (this.useSpinner) {
            return new TiUISpinnerColumn(this);
        }
        return new TiUIPickerColumn(this);
    }

    @Override
    public void rowChanged(PickerRowProxy row) {
        if (this.columnListener != null && !this.suppressListenerEvents) {
            int index = this.children.indexOf((Object)row);
            this.columnListener.rowChanged(this, index);
        }
    }

    public void onItemSelected(int rowIndex) {
        if (this.columnListener != null && !this.suppressListenerEvents) {
            this.columnListener.rowSelected(this, rowIndex);
        }
    }

    public PickerRowProxy getSelectedRow() {
        if (!(this.peekView() instanceof TiUISpinnerColumn)) {
            return null;
        }
        int rowIndex = ((TiUISpinnerColumn)this.peekView()).getSelectedRowIndex();
        if (rowIndex < 0) {
            return null;
        }
        return (PickerRowProxy)((Object)this.children.get(rowIndex));
    }

    public int getThisColumnIndex() {
        return ((PickerProxy)this.getParent()).getColumnIndex(this);
    }

    public void parentShouldRequestLayout() {
        if (this.getParent() instanceof PickerProxy) {
            ((PickerProxy)this.getParent()).forceRequestLayout();
        }
    }

    public static interface PickerColumnListener {
        public void rowAdded(PickerColumnProxy var1, int var2);

        public void rowRemoved(PickerColumnProxy var1, int var2);

        public void rowChanged(PickerColumnProxy var1, int var2);

        public void rowSelected(PickerColumnProxy var1, int var2);

        public void rowsReplaced(PickerColumnProxy var1);
    }
}

