/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui;

import android.app.Activity;
import android.graphics.Bitmap;
import java.util.ArrayList;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.view.TiDrawableReference;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.ui.TableViewProxy;
import ti.modules.titanium.ui.ViewProxy;
import ti.modules.titanium.ui.widget.TiUIImageView;

public class ImageViewProxy
extends ViewProxy {
    private static final String PROPERTY_INTERNAL_BITMAP = "_internalBitmap";
    private static final String PROPERTY_INTERNAL_SOURCES = "_internalSources";

    public ImageViewProxy(TiContext tiContext) {
        super(tiContext);
    }

    @Override
    public TiUIView createView(Activity activity) {
        return new TiUIImageView(this);
    }

    public Bitmap getBitmap() {
        Bitmap bitmap = (Bitmap)this.getProperty(PROPERTY_INTERNAL_BITMAP);
        if (bitmap != null && bitmap.isRecycled()) {
            this.properties.remove((Object)PROPERTY_INTERNAL_BITMAP);
            return null;
        }
        return bitmap;
    }

    public ArrayList<TiDrawableReference> getImageSources() {
        return (ArrayList)this.getProperty(PROPERTY_INTERNAL_SOURCES);
    }

    public void onImageSourcesChanged(TiUIImageView imageView, ArrayList<TiDrawableReference> imageSources) {
        this.setProperty(PROPERTY_INTERNAL_SOURCES, imageSources);
        this.onBitmapChanged(imageView, null);
    }

    public void onBitmapChanged(TiUIImageView imageView, Bitmap bitmap) {
        this.setProperty(PROPERTY_INTERNAL_BITMAP, bitmap);
    }

    public boolean inTableView() {
        for (TiViewProxy parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TableViewProxy)) continue;
            return true;
        }
        return false;
    }

    private TiUIImageView getImageView() {
        return (TiUIImageView)this.getView(this.getTiContext().getActivity());
    }

    public void start() {
        this.getImageView().start();
    }

    public void stop() {
        this.getImageView().stop();
    }

    public void pause() {
        this.getImageView().pause();
    }

    public void resume() {
        this.getImageView().resume();
    }

    public boolean getAnimating() {
        return this.getImageView().isAnimating();
    }

    public boolean getReverse() {
        return this.getImageView().isReverse();
    }

    public void setReverse(boolean reverse) {
        this.getImageView().setReverse(reverse);
    }

    public TiBlob toBlob() {
        return this.getImageView().toBlob();
    }

    public void releaseViews() {
        if (this.hasProperty(PROPERTY_INTERNAL_BITMAP)) {
            this.properties.remove((Object)PROPERTY_INTERNAL_BITMAP);
        }
        if (this.hasProperty(PROPERTY_INTERNAL_SOURCES)) {
            this.properties.remove((Object)PROPERTY_INTERNAL_SOURCES);
        }
        super.releaseViews();
    }
}

