/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.ui;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.Html;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.io.TiFile;
import org.appcelerator.titanium.io.TiFileFactory;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiActivityResultHandler;
import org.appcelerator.titanium.util.TiActivitySupport;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiMimeTypeHelper;
import org.appcelerator.titanium.view.TiUIView;
import ti.modules.titanium.filesystem.FileProxy;

public class EmailDialogProxy
extends TiViewProxy {
    private static final String LCAT = "EmailDialogProxy";
    private static final boolean DBG = TiConfig.LOGD;
    public static final int CANCELLED = 0;
    public static final int SAVED = 1;
    public static final int SENT = 2;
    public static final int FAILED = 3;
    private ArrayList<Object> attachments;
    private String privateDataDirectoryPath = null;

    public EmailDialogProxy(TiContext tiContext) {
        super(tiContext);
        TiBaseFile privateDataDirectory = TiFileFactory.createTitaniumFile((TiContext)tiContext, (String)"appdata-private:///", (boolean)false);
        this.privateDataDirectoryPath = privateDataDirectory.getNativeFile().getAbsolutePath();
    }

    public boolean isSupported() {
        Intent intent;
        List activities;
        PackageManager pm;
        boolean supported = false;
        Activity activity = this.getTiContext().getActivity();
        if (activity != null && (pm = activity.getPackageManager()) != null && (activities = pm.queryIntentActivities(intent = this.buildIntent(), 65536)) != null && activities.size() > 0) {
            supported = true;
            if (DBG) {
                Log.d((String)LCAT, (String)("Number of activities that support ACTION_SEND: " + activities.size()));
            }
        }
        return supported;
    }

    public void addAttachment(Object attachment) {
        if (attachment instanceof FileProxy || attachment instanceof TiBlob) {
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.add(attachment);
        } else if (DBG) {
            Log.d((String)LCAT, (String)("addAttachment for type " + attachment.getClass().getName() + " ignored. Only files and blobs may be attached."));
        }
    }

    private String baseMimeType(boolean isHtml) {
        String result;
        String string = result = isHtml ? "text/html" : "text/plain";
        if (Build.VERSION.SDK_INT > 4) {
            result = "message/rfc822";
        }
        return result;
    }

    private Intent buildIntent() {
        ArrayList<Uri> uris = this.getAttachmentUris();
        Intent sendIntent = new Intent(uris != null && uris.size() > 1 ? "android.intent.action.SEND_MULTIPLE" : "android.intent.action.SEND");
        boolean isHtml = false;
        if (this.hasProperty("html")) {
            isHtml = TiConvert.toBoolean((Object)this.getProperty("html"));
        }
        String intentType = this.baseMimeType(isHtml);
        sendIntent.setType(intentType);
        this.putAddressExtra(sendIntent, "android.intent.extra.EMAIL", "toRecipients");
        this.putAddressExtra(sendIntent, "android.intent.extra.CC", "ccRecipients");
        this.putAddressExtra(sendIntent, "android.intent.extra.BCC", "bccRecipients");
        this.putStringExtra(sendIntent, "android.intent.extra.SUBJECT", "subject");
        this.putStringExtra(sendIntent, "android.intent.extra.TEXT", "messageBody", isHtml);
        this.prepareAttachments(sendIntent, uris);
        if (DBG) {
            Log.d((String)LCAT, (String)("Choosing for mime type " + sendIntent.getType()));
        }
        return sendIntent;
    }

    public void open() {
        Intent sendIntent = this.buildIntent();
        Intent choosingIntent = Intent.createChooser((Intent)sendIntent, (CharSequence)"Send");
        Activity activity = this.getTiContext().getActivity();
        TiActivitySupport activitySupport = (TiActivitySupport)activity;
        int code = activitySupport.getUniqueResultCode();
        activitySupport.launchActivityForResult(choosingIntent, code, new TiActivityResultHandler(){

            public void onResult(Activity activity, int requestCode, int resultCode, Intent data) {
                KrollDict result = new KrollDict();
                result.put((Object)"result", (Object)2);
                result.put((Object)"success", (Object)true);
                EmailDialogProxy.this.fireEvent("complete", result);
            }

            public void onError(Activity activity, int requestCode, Exception e) {
                KrollDict result = new KrollDict();
                result.put((Object)"result", (Object)3);
                result.put((Object)"error", (Object)e.getMessage());
                result.put((Object)"success", (Object)false);
                EmailDialogProxy.this.fireEvent("complete", result);
            }
        });
    }

    private File blobToTemp(TiBlob blob, String fileName) {
        File tempFolder = new File(this.getTiContext().getTiFileHelper().getDataDirectory(false), "temp");
        tempFolder.mkdirs();
        File tempfilej = new File(tempFolder, fileName);
        TiFile tempfile = new TiFile(this.getTiContext(), tempfilej, tempfilej.getPath(), false);
        if (tempfile.exists()) {
            tempfile.deleteFile();
        }
        try {
            tempfile.write(blob, false);
            return tempfile.getNativeFile();
        }
        catch (IOException e) {
            Log.e((String)LCAT, (String)("Unable to attach file " + fileName + ": " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private File privateFileToTemp(FileProxy file) {
        File tempfile = null;
        try {
            tempfile = this.blobToTemp(file.read(), file.getName());
        }
        catch (IOException e) {
            Log.e((String)LCAT, (String)("Unable to attach file " + file.getName() + ": " + e.getMessage()), (Throwable)e);
        }
        return tempfile;
    }

    private File blobToFile(TiBlob blob) {
        if (blob.getType() == 1) {
            return ((TiBaseFile)blob.getData()).getNativeFile();
        }
        String fileName = "attachment";
        String extension = TiMimeTypeHelper.getFileExtensionFromMimeType((String)blob.getMimeType(), (String)"");
        if (extension.length() > 0) {
            fileName = fileName + "." + extension;
        }
        return this.blobToTemp(blob, fileName);
    }

    private Uri getAttachmentUri(Object attachment) {
        File file;
        if (attachment instanceof FileProxy) {
            FileProxy fileProxy = (FileProxy)attachment;
            if (fileProxy.isFile()) {
                if (this.isPrivateData(fileProxy)) {
                    File file2 = this.privateFileToTemp(fileProxy);
                    if (file2 != null) {
                        return Uri.fromFile((File)file2);
                    }
                    return null;
                }
                File nativeFile = fileProxy.getBaseFile().getNativeFile();
                return Uri.fromFile((File)nativeFile);
            }
        } else if (attachment instanceof TiBlob && (file = this.blobToFile((TiBlob)attachment)) != null) {
            return Uri.fromFile((File)file);
        }
        return null;
    }

    private ArrayList<Uri> getAttachmentUris() {
        if (this.attachments == null) {
            return null;
        }
        ArrayList<Uri> uris = new ArrayList<Uri>();
        for (Object attachment : this.attachments) {
            Uri uri = this.getAttachmentUri(attachment);
            if (uri == null) continue;
            uris.add(uri);
        }
        return uris;
    }

    private void prepareAttachments(Intent sendIntent, ArrayList<Uri> uris) {
        if (uris == null || uris.size() == 0) {
            return;
        }
        if (uris.size() == 1) {
            sendIntent.putExtra("android.intent.extra.STREAM", (Parcelable)uris.get(0));
            if (Build.VERSION.SDK_INT == 4) {
                sendIntent.setType(TiMimeTypeHelper.getMimeType((String)uris.get(0).toString()));
            }
            return;
        }
        sendIntent.putExtra("android.intent.extra.STREAM", uris);
    }

    private void putStringExtra(Intent intent, String extraType, String ourKey) {
        this.putStringExtra(intent, extraType, ourKey, false);
    }

    private void putStringExtra(Intent intent, String extraType, String ourkey, boolean encodeHtml) {
        if (this.hasProperty(ourkey)) {
            String text = TiConvert.toString((Object)this.getProperty(ourkey));
            if (encodeHtml) {
                intent.putExtra(extraType, (CharSequence)Html.fromHtml((String)text));
            } else {
                intent.putExtra(extraType, text);
            }
        }
    }

    private void putAddressExtra(Intent intent, String extraType, String ourkey) {
        Object testprop = this.getProperty(ourkey);
        if (testprop instanceof Object[]) {
            Object[] oaddrs = (Object[])testprop;
            int len = oaddrs.length;
            String[] addrs = new String[len];
            for (int i = 0; i < len; ++i) {
                addrs[i] = TiConvert.toString((Object)oaddrs[i]);
            }
            intent.putExtra(extraType, addrs);
        }
    }

    public TiUIView createView(Activity activity) {
        return null;
    }

    private boolean isPrivateData(FileProxy file) {
        if (file.isFile()) {
            if (file.getNativePath().contains("android_asset")) {
                return true;
            }
            if (file.getNativePath().contains(this.privateDataDirectoryPath)) {
                return true;
            }
        }
        return false;
    }
}

