/*
 * Decompiled with CFR 0.152.
 */
package kankan.wheel.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.FloatMath;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import kankan.wheel.widget.WheelAdapter;

public class WheelView
extends View {
    private static final int NOVAL = -1;
    private static final int VALUE_TEXT_COLOR = -536870912;
    private static final int ITEMS_TEXT_COLOR = -16777216;
    private static final int[] SHADOWS_COLORS = new int[]{-15658735, 0xAAAAAA, 0xAAAAAA};
    private int textSize = 24;
    private static final int ADDITIONAL_ITEMS_SPACE = 5;
    private static final int LABEL_OFFSET = 8;
    private static final int PADDING = 10;
    private static final int DEF_VISIBLE_ITEMS = 5;
    private WheelAdapter adapter = null;
    private int currentItem = 0;
    private int itemsWidth = 0;
    private int labelWidth = 0;
    private int visibleItems = 5;
    private TextPaint itemsPaint;
    private TextPaint valuePaint;
    private StaticLayout itemsLayout;
    private StaticLayout labelLayout;
    private StaticLayout valueLayout;
    private String label;
    private Drawable centerDrawable;
    private GradientDrawable topShadow;
    private GradientDrawable bottomShadow;
    private float lastYTouch;
    private OnItemSelectedListener itemSelectedListener;
    private int textColor = -1;
    private Typeface typeface = Typeface.DEFAULT;
    private int typefaceWeight = 0;
    private boolean showSelectionIndicator = true;

    public WheelView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public WheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public WheelView(Context context) {
        super(context);
    }

    public WheelAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(WheelAdapter adapter) {
        this.adapter = adapter;
        this.itemsLayout = null;
        this.valueLayout = null;
        this.invalidate();
    }

    public int getVisibleItems() {
        return this.visibleItems;
    }

    public void setVisibleItems(int count) {
        this.visibleItems = count;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
        this.labelLayout = null;
        this.invalidate();
    }

    public int getCurrentItem() {
        return this.currentItem;
    }

    public void setCurrentItem(int index) {
        if (index != this.currentItem) {
            this.itemsLayout = null;
            this.valueLayout = null;
            this.currentItem = index;
            this.invalidate();
            if (this.itemSelectedListener != null) {
                this.itemSelectedListener.onItemSelected(this, index);
            }
        }
    }

    private void resetTextPainters() {
        TextPaint[] painters = new TextPaint[]{this.itemsPaint, this.valuePaint};
        for (int i = 0; i < painters.length; ++i) {
            TextPaint painter = painters[i];
            if (painter == null) continue;
            int flags = 1;
            if (this.typefaceWeight == 1) {
                flags |= 0x20;
            }
            if (i == 1) {
                flags |= 4;
            }
            painter.setFlags(flags);
            painter.setColor(this.textColor == -1 ? -16777216 : this.textColor);
            painter.setTypeface(this.typeface);
            painter.setTextSize((float)this.textSize);
        }
    }

    private void initResourcesIfNecessary() {
        if (this.itemsPaint == null) {
            this.itemsPaint = this.typefaceWeight == 1 ? new TextPaint(33) : new TextPaint(1);
            this.itemsPaint.setTextSize((float)this.textSize);
            this.itemsPaint.setTypeface(this.typeface);
            this.itemsPaint.setColor(this.textColor == -1 ? -16777216 : this.textColor);
        }
        if (this.valuePaint == null) {
            this.valuePaint = this.typefaceWeight == 1 ? new TextPaint(37) : new TextPaint(5);
            this.valuePaint.setTextSize((float)this.textSize);
            this.valuePaint.setShadowLayer(0.5f, 0.0f, 0.5f, -1);
            this.valuePaint.setTypeface(this.typeface);
            this.valuePaint.setColor(this.textColor == -1 ? -16777216 : this.textColor);
        }
        if (this.centerDrawable == null) {
            this.centerDrawable = this.getWheelValDrawable();
        }
        if (this.topShadow == null) {
            this.topShadow = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, SHADOWS_COLORS);
        }
        if (this.bottomShadow == null) {
            this.bottomShadow = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, SHADOWS_COLORS);
        }
        this.setBackgroundDrawable(this.getWheelBackground());
    }

    private int dipToInt(float dips) {
        return Math.round(TypedValue.applyDimension((int)1, (float)dips, (DisplayMetrics)this.getResources().getDisplayMetrics()));
    }

    private GradientDrawable makeGradientDrawable(GradientDrawable.Orientation orientation, int startColor, int centerColor, int endColor, float strokeDips, int strokeColor) {
        GradientDrawable gd = this.makeGradientDrawable(orientation, startColor, centerColor, endColor);
        gd.setStroke(this.dipToInt(strokeDips), strokeColor);
        return gd;
    }

    private GradientDrawable makeGradientDrawable(GradientDrawable.Orientation orientation, int startColor, int centerColor, int endColor) {
        int[] colors = new int[]{startColor, centerColor, endColor};
        GradientDrawable gd = new GradientDrawable(orientation, colors);
        return gd;
    }

    private Drawable getWheelValDrawable() {
        return this.makeGradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, Color.parseColor((String)"#70222222"), Color.parseColor((String)"#70222222"), Color.parseColor((String)"#70EEEEEE"), 1.0f, Color.parseColor((String)"#70333333"));
    }

    private Drawable getWheelBackground() {
        GradientDrawable item0 = this.makeGradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, Color.parseColor((String)"#333333"), Color.parseColor((String)"#DDDDDD"), Color.parseColor((String)"#333333"), 1.0f, Color.parseColor((String)"#FF333333"));
        GradientDrawable item1 = this.makeGradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, Color.parseColor((String)"#AAAAAA"), Color.parseColor((String)"#FFFFFF"), Color.parseColor((String)"#AAAAAA"));
        LayerDrawable ld = new LayerDrawable(new Drawable[]{item0, item1});
        ld.setLayerInset(1, this.dipToInt(4.0f), this.dipToInt(1.0f), this.dipToInt(4.0f), this.dipToInt(1.0f));
        return ld;
    }

    private int getDesiredHeight(Layout layout) {
        if (layout == null) {
            return 0;
        }
        int linecount = layout.getLineCount();
        int desired = layout.getLineTop(linecount) - this.getItemOffset() * 2 - this.getAdditionalItemHeight();
        desired = Math.max(desired, this.getSuggestedMinimumHeight());
        return desired;
    }

    private String buildText() {
        String text;
        int i;
        WheelAdapter adapter = this.getAdapter();
        StringBuilder itemsText = new StringBuilder();
        int addItems = this.visibleItems / 2;
        for (i = this.currentItem - addItems; i < this.currentItem; ++i) {
            if (i >= 0 && adapter != null && (text = adapter.getItem(i)) != null) {
                itemsText.append(text);
            }
            itemsText.append("\n");
        }
        itemsText.append("\n");
        for (i = this.currentItem + 1; i <= this.currentItem + addItems; ++i) {
            if (adapter != null && i < adapter.getItemsCount() && (text = adapter.getItem(i)) != null) {
                itemsText.append(text);
            }
            if (i >= this.currentItem + addItems) continue;
            itemsText.append("\n");
        }
        return itemsText.toString();
    }

    private int getMaxTextLength() {
        WheelAdapter adapter = this.getAdapter();
        if (adapter == null) {
            return 0;
        }
        int adapterLength = adapter.getMaximumLength();
        if (adapterLength > 0) {
            return adapterLength;
        }
        String maxText = null;
        int addItems = this.visibleItems / 2;
        for (int i = Math.max(this.currentItem - addItems, 0); i < Math.min(this.currentItem + this.visibleItems, adapter.getItemsCount()); ++i) {
            String text = adapter.getItem(i);
            if (text == null || maxText != null && maxText.length() >= text.length()) continue;
            maxText = text;
        }
        return maxText != null ? maxText.length() : 0;
    }

    private int calculateLayoutWidth(int widthSize, int mode) {
        this.initResourcesIfNecessary();
        int width = widthSize;
        int maxLength = this.getMaxTextLength();
        if (maxLength > 0) {
            float textWidth = FloatMath.ceil((float)Layout.getDesiredWidth((CharSequence)"0", (TextPaint)this.itemsPaint));
            this.itemsWidth = (int)((float)maxLength * textWidth);
        } else {
            this.itemsWidth = 0;
        }
        this.itemsWidth += 5;
        this.labelWidth = 0;
        if (this.label != null && this.label.length() > 0) {
            this.labelWidth = (int)FloatMath.ceil((float)Layout.getDesiredWidth((CharSequence)this.label, (TextPaint)this.valuePaint));
        }
        boolean recalculate = false;
        if (mode == 0x40000000) {
            width = widthSize;
            recalculate = true;
        } else {
            width = this.itemsWidth + this.labelWidth + 20;
            if (this.labelWidth > 0) {
                width += 8;
            }
            width = Math.max(width, this.getSuggestedMinimumWidth());
            if (mode == Integer.MIN_VALUE && widthSize < width) {
                width = widthSize;
                recalculate = true;
            }
        }
        if (recalculate) {
            int pureWidth = width - 8 - 20;
            if (pureWidth <= 0) {
                this.labelWidth = 0;
                this.itemsWidth = 0;
            }
            if (this.labelWidth > 0) {
                double newWidthItems = (double)this.itemsWidth * (double)pureWidth / (double)(this.itemsWidth + this.labelWidth);
                this.itemsWidth = (int)newWidthItems;
                this.labelWidth = pureWidth - this.itemsWidth;
            } else {
                this.itemsWidth = pureWidth + 8;
            }
        }
        if (this.itemsWidth > 0) {
            this.createLayouts(this.itemsWidth, this.labelWidth);
        }
        return width;
    }

    private void createLayouts(int widthItems, int widthLabel) {
        String text;
        if (this.itemsLayout == null || this.itemsLayout.getWidth() > widthItems) {
            text = this.buildText();
            if (text == null) {
                text = "";
            }
            this.itemsLayout = new StaticLayout((CharSequence)text, 0, text.length(), this.itemsPaint, widthItems, widthLabel > 0 ? Layout.Alignment.ALIGN_OPPOSITE : Layout.Alignment.ALIGN_CENTER, 1.0f, (float)this.getAdditionalItemHeight(), false, TextUtils.TruncateAt.END, widthItems);
        } else {
            this.itemsLayout.increaseWidthTo(widthItems);
        }
        if (this.valueLayout == null || this.valueLayout.getWidth() > widthItems) {
            text = this.getAdapter() != null ? this.getAdapter().getItem(this.currentItem) : null;
            this.valueLayout = new StaticLayout((CharSequence)(text != null ? text : ""), 0, text != null ? text.length() : 0, this.valuePaint, widthItems, widthLabel > 0 ? Layout.Alignment.ALIGN_OPPOSITE : Layout.Alignment.ALIGN_CENTER, 1.0f, (float)this.getAdditionalItemHeight(), false, TextUtils.TruncateAt.END, widthItems);
        } else {
            this.valueLayout.increaseWidthTo(widthItems);
        }
        if (widthLabel > 0) {
            if (this.labelLayout == null || this.labelLayout.getWidth() > widthLabel) {
                this.labelLayout = new StaticLayout((CharSequence)this.label, this.valuePaint, widthLabel, Layout.Alignment.ALIGN_NORMAL, 1.0f, (float)this.getAdditionalItemHeight(), false);
            } else {
                this.labelLayout.increaseWidthTo(widthLabel);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = this.calculateLayoutWidth(widthSize, widthMode);
        if (heightMode == 0x40000000) {
            height = heightSize;
        } else {
            height = this.getDesiredHeight((Layout)this.itemsLayout);
            if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(height, heightSize);
            }
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.itemsLayout == null) {
            if (this.itemsWidth == 0) {
                this.calculateLayoutWidth(this.getWidth(), 0x40000000);
            } else {
                this.createLayouts(this.itemsWidth, this.labelWidth);
            }
        }
        this.drawCenterRect(canvas);
        if (this.itemsWidth > 0) {
            canvas.save();
            canvas.translate(10.0f, (float)(-this.getItemOffset()));
            this.drawItems(canvas);
            this.drawValue(canvas);
            canvas.restore();
        }
        this.drawShadows(canvas);
    }

    private void drawShadows(Canvas canvas) {
        this.topShadow.setBounds(0, 0, this.getWidth(), this.getHeight() / this.visibleItems);
        this.topShadow.draw(canvas);
        this.bottomShadow.setBounds(0, this.getHeight() - this.getHeight() / this.visibleItems, this.getWidth(), this.getHeight());
        this.bottomShadow.draw(canvas);
    }

    private void drawValue(Canvas canvas) {
        this.valuePaint.setColor(this.textColor == -1 ? -536870912 : this.textColor);
        this.valuePaint.drawableState = this.getDrawableState();
        Rect bounds = new Rect();
        this.itemsLayout.getLineBounds(this.visibleItems / 2, bounds);
        if (this.labelLayout != null) {
            canvas.save();
            canvas.translate((float)(this.itemsLayout.getWidth() + 8), (float)bounds.top);
            this.labelLayout.draw(canvas);
            canvas.restore();
        }
        canvas.save();
        canvas.translate(0.0f, (float)bounds.top);
        this.valueLayout.draw(canvas);
        canvas.restore();
    }

    private void drawItems(Canvas canvas) {
        this.itemsPaint.drawableState = this.getDrawableState();
        this.itemsLayout.draw(canvas);
    }

    private void drawCenterRect(Canvas canvas) {
        if (!this.showSelectionIndicator) {
            return;
        }
        int center = this.getHeight() / 2;
        int offset = this.getHeight() / this.visibleItems / 2;
        this.centerDrawable.setBounds(0, center - offset, this.getWidth(), center + offset);
        this.centerDrawable.draw(canvas);
    }

    public boolean onTouchEvent(MotionEvent event) {
        WheelAdapter adapter = this.getAdapter();
        if (adapter == null) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                this.lastYTouch = event.getY();
                break;
            }
            case 2: {
                float delta = event.getY() - this.lastYTouch;
                int count = (int)((float)this.visibleItems * delta / (float)this.getHeight());
                int pos = this.currentItem - count;
                pos = Math.max(pos, 0);
                pos = Math.min(pos, adapter.getItemsCount() - 1);
                if (pos == this.currentItem) break;
                this.lastYTouch = event.getY();
                this.setCurrentItem(pos);
                break;
            }
        }
        return true;
    }

    public void setItemSelectedListener(OnItemSelectedListener listener) {
        this.itemSelectedListener = listener;
    }

    private int getAdditionalItemHeight() {
        return (int)((double)this.textSize * 0.625);
    }

    private int getItemOffset() {
        return this.textSize / 5;
    }

    public void fullLayoutReset() {
        this.itemsLayout = null;
        this.valueLayout = null;
        this.requestLayout();
    }

    public void setTextSize(int size) {
        int orig = this.textSize;
        this.textSize = size;
        if (orig != this.textSize) {
            this.resetTextPainters();
        }
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextColor(int color) {
        this.textColor = color;
        this.resetTextPainters();
        this.invalidate();
    }

    public void setTypeface(Typeface tf) {
        Typeface old = this.typeface;
        this.typeface = tf;
        if (!old.equals(tf)) {
            this.resetTextPainters();
        }
    }

    public Typeface getTypeface() {
        return this.typeface;
    }

    public void setTypefaceWeight(int weight) {
        int old = this.typefaceWeight;
        this.typefaceWeight = weight;
        if (old != weight) {
            this.resetTextPainters();
        }
    }

    public int getTypefaceWeight() {
        return this.typefaceWeight;
    }

    public void setShowSelectionIndicator(boolean show) {
        boolean oldval = this.showSelectionIndicator;
        this.showSelectionIndicator = show;
        if (oldval != show) {
            this.invalidate();
        }
    }

    public boolean getShowSelectionIndicator() {
        return this.showSelectionIndicator;
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(WheelView var1, int var2);
    }
}

