/*
 * Decompiled with CFR 0.152.
 */
package kankan.wheel.widget;

import kankan.wheel.widget.WheelAdapter;

public class NumericWheelAdapter
implements WheelAdapter {
    public static final int DEFAULT_MAX_VALUE = 9;
    private static final int DEFAULT_MIN_VALUE = 0;
    private static final int DEFAULT_STEP_VALUE = 1;
    private int minValue;
    private int maxValue;
    private int stepValue;

    public NumericWheelAdapter() {
        this(0, 9, 1);
    }

    public NumericWheelAdapter(int minValue, int maxValue) {
        this(minValue, maxValue, 1);
    }

    public NumericWheelAdapter(int minValue, int maxValue, int stepValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepValue = stepValue;
    }

    @Override
    public String getItem(int index) {
        if (index >= 0 && index < this.getItemsCount()) {
            int actualValue = this.minValue + index * this.stepValue;
            return Integer.toString(actualValue);
        }
        return null;
    }

    @Override
    public int getItemsCount() {
        int itemCount = (this.maxValue - this.minValue) / this.stepValue + 1;
        return itemCount;
    }

    @Override
    public int getMaximumLength() {
        int max = Math.max(Math.abs(this.maxValue), Math.abs(this.minValue));
        int maxLen = Integer.toString(max).length();
        if (this.minValue < 0) {
            ++maxLen;
        }
        return maxLen;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getValue(int index) {
        int tmpValue = this.minValue + index * this.stepValue;
        if (tmpValue > this.maxValue) {
            return this.maxValue;
        }
        return tmpValue;
    }

    public int getIndex(int value) {
        return (value - this.minValue) / this.stepValue;
    }

    public void setStepValue(int value) {
        this.stepValue = value;
    }
}

