/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.platform;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.bridge.OnEventListenerChange;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiPlatformHelper;
import ti.modules.titanium.platform.DisplayCapsProxy;

public class PlatformModule
extends KrollModule {
    private static final String LCAT = "PlatformModule";
    private static final boolean DBG = TiConfig.LOGD;
    public static int BATTERY_STATE_UNKNOWN = 0;
    public static int BATTERY_STATE_UNPLUGGED = 1;
    public static int BATTERY_STATE_CHARGING = 2;
    public static int BATTERY_STATE_FULL = 3;
    protected DisplayCapsProxy displayCaps;
    protected int batteryState;
    protected double batteryLevel;
    protected boolean batteryStateReady;
    protected BroadcastReceiver batteryStateReceiver;

    public PlatformModule(TiContext context) {
        super(context);
        this.eventManager.addOnEventChangeListener((OnEventListenerChange)this);
        this.batteryState = BATTERY_STATE_UNKNOWN;
        this.batteryLevel = -1.0;
    }

    public String getName() {
        return TiPlatformHelper.getName();
    }

    public String getOsname() {
        return TiPlatformHelper.getName();
    }

    public String getLocale() {
        return TiPlatformHelper.getLocale();
    }

    public DisplayCapsProxy getDisplayCaps() {
        if (this.displayCaps == null) {
            this.displayCaps = new DisplayCapsProxy(this.getTiContext());
        }
        return this.displayCaps;
    }

    public int getProcessorCount() {
        return TiPlatformHelper.getProcessorCount();
    }

    public String getUsername() {
        return TiPlatformHelper.getUsername();
    }

    public String getVersion() {
        return TiPlatformHelper.getVersion();
    }

    public double getAvailableMemory() {
        return TiPlatformHelper.getAvailableMemory();
    }

    public String getModel() {
        return TiPlatformHelper.getModel();
    }

    public String getOstype() {
        return TiPlatformHelper.getOstype();
    }

    public String getArchitecture() {
        return TiPlatformHelper.getArchitecture();
    }

    public String getAddress() {
        return TiPlatformHelper.getIpAddress();
    }

    public String getNetmask() {
        return TiPlatformHelper.getNetmask();
    }

    public String createUUID() {
        return TiPlatformHelper.createUUID();
    }

    public boolean openURL(String url) {
        if (DBG) {
            Log.d((String)LCAT, (String)("Launching viewer for: " + url));
        }
        Uri uri = Uri.parse((String)url);
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        try {
            this.getTiContext().getActivity().startActivity(intent);
            return true;
        }
        catch (ActivityNotFoundException e) {
            Log.e((String)LCAT, (String)("Activity not found: " + url), (Throwable)e);
            return false;
        }
    }

    public String getMacaddress() {
        return TiPlatformHelper.getMacaddress();
    }

    public String getId() {
        return TiPlatformHelper.getMobileId();
    }

    public void setBatteryMonitoring(boolean monitor) {
        if (monitor && this.batteryStateReceiver == null) {
            this.registerBatteryStateReceiver();
        } else if (!monitor && this.batteryStateReceiver != null) {
            this.unregisterBatteryStateReceiver();
        }
    }

    public int getBatteryState() {
        return this.batteryState;
    }

    public double getBatteryLevel() {
        return this.batteryLevel;
    }

    protected void registerBatteryStateReceiver() {
        this.batteryStateReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                int scale = intent.getIntExtra("scale", -1);
                PlatformModule.this.batteryLevel = PlatformModule.this.convertBatteryLevel(intent.getIntExtra("level", -1), scale);
                PlatformModule.this.batteryState = PlatformModule.this.convertBatteryStatus(intent.getIntExtra("status", -1));
                KrollDict event = new KrollDict();
                event.put((Object)"level", (Object)PlatformModule.this.batteryLevel);
                event.put((Object)"state", (Object)PlatformModule.this.batteryState);
                PlatformModule.this.fireEvent("battery", event);
            }
        };
        this.registerBatteryReceiver(this.batteryStateReceiver);
    }

    protected void unregisterBatteryStateReceiver() {
        this.getTiContext().getActivity().unregisterReceiver(this.batteryStateReceiver);
    }

    public void listenerAdded(String type, int count, KrollProxy proxy) {
        if ("battery".equals(type) && this.batteryStateReceiver == null) {
            this.registerBatteryStateReceiver();
        }
    }

    public void listenerRemoved(String type, int count, KrollProxy proxy) {
        if ("battery".equals(type) && count == 0 && this.batteryStateReceiver != null) {
            this.unregisterBatteryStateReceiver();
        }
    }

    private int convertBatteryStatus(int status) {
        int state = BATTERY_STATE_UNKNOWN;
        switch (status) {
            case 2: {
                state = BATTERY_STATE_CHARGING;
                break;
            }
            case 5: {
                state = BATTERY_STATE_FULL;
                break;
            }
            case 3: 
            case 4: {
                state = BATTERY_STATE_UNPLUGGED;
            }
        }
        return state;
    }

    private double convertBatteryLevel(int level, int scale) {
        int l = -1;
        if (level >= 0 && scale > 0) {
            l = level * 100 / scale;
        }
        return l;
    }

    private void registerBatteryReceiver(BroadcastReceiver batteryReceiver) {
        Activity a = this.getTiContext().getActivity();
        IntentFilter batteryFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        a.registerReceiver(batteryReceiver, batteryFilter);
    }

    public void onResume(Activity activity) {
        super.onResume(activity);
        if (this.batteryStateReceiver != null) {
            if (DBG) {
                Log.i((String)LCAT, (String)"Reregistering battery changed receiver");
            }
            this.registerBatteryReceiver(this.batteryStateReceiver);
        }
    }

    public void onPause(Activity activity) {
        super.onPause(activity);
        if (this.batteryStateReceiver != null) {
            this.unregisterBatteryStateReceiver();
        }
    }

    public void onDestroy(Activity activity) {
        super.onDestroy(activity);
        if (this.batteryStateReceiver != null) {
            this.unregisterBatteryStateReceiver();
            this.batteryStateReceiver = null;
        }
    }
}

