/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.platform;

import android.util.DisplayMetrics;
import android.view.Display;
import java.lang.ref.SoftReference;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;

public class DisplayCapsProxy
extends KrollProxy {
    private final DisplayMetrics dm = new DisplayMetrics();
    private SoftReference<Display> softDisplay;

    public DisplayCapsProxy(TiContext tiContext) {
        super(tiContext);
    }

    private Display getDisplay() {
        if (this.softDisplay == null || this.softDisplay.get() == null) {
            this.softDisplay = new SoftReference<Display>(this.getTiContext().getActivity().getWindowManager().getDefaultDisplay());
        }
        return this.softDisplay.get();
    }

    public int getPlatformWidth() {
        return this.getDisplay().getWidth();
    }

    public int getPlatformHeight() {
        return this.getDisplay().getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDensity() {
        DisplayMetrics displayMetrics = this.dm;
        synchronized (displayMetrics) {
            this.getDisplay().getMetrics(this.dm);
            switch (this.dm.densityDpi) {
                case 240: {
                    return "high";
                }
                case 160: {
                    return "medium";
                }
                case 320: {
                    return "xhigh";
                }
                case 120: {
                    return "low";
                }
            }
            return "medium";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getDpi() {
        DisplayMetrics displayMetrics = this.dm;
        synchronized (displayMetrics) {
            this.getDisplay().getMetrics(this.dm);
            return this.dm.densityDpi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getXdpi() {
        DisplayMetrics displayMetrics = this.dm;
        synchronized (displayMetrics) {
            this.getDisplay().getMetrics(this.dm);
            return this.dm.xdpi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getYdpi() {
        DisplayMetrics displayMetrics = this.dm;
        synchronized (displayMetrics) {
            this.getDisplay().getMetrics(this.dm);
            return this.dm.ydpi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getLogicalDensityFactor() {
        DisplayMetrics displayMetrics = this.dm;
        synchronized (displayMetrics) {
            this.getDisplay().getMetrics(this.dm);
            return this.dm.density;
        }
    }
}

