/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.network.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.io.TiStream;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiStreamHelper;
import ti.modules.titanium.BufferProxy;

public class TCPProxy
extends KrollProxy
implements TiStream {
    private static final String LCAT = "TCPProxy";
    private static final boolean DBG = TiConfig.LOGD;
    private Socket clientSocket = null;
    private ServerSocket serverSocket = null;
    private boolean accepting = false;
    private KrollDict acceptOptions = null;
    private int state = 1;
    private InputStream inputStream = null;

    public TCPProxy(TiContext context) {
        super(context);
    }

    public void connect() throws Exception {
        if (this.state != 3 && this.state != 2) {
            Object host = this.getProperty("host");
            Object port = this.getProperty("port");
            if (host == null || port == null) {
                throw new IllegalArgumentException("unable to call connect, socket must have a valid host and port");
            }
        } else {
            throw new Exception("Unable to call connect on socket in <" + this.state + "> state");
        }
        new ConnectedSocketThread().start();
    }

    public void listen() throws Exception {
        if (this.state != 3 && this.state != 2) {
            Object port = this.getProperty("port");
            Object listenQueueSize = this.getProperty("listenQueueSize");
            try {
                this.serverSocket = port != null && listenQueueSize != null ? new ServerSocket(TiConvert.toInt((Object)port), TiConvert.toInt((Object)listenQueueSize)) : (port != null ? new ServerSocket(TiConvert.toInt((Object)port)) : new ServerSocket());
                new ListeningSocketThread().start();
                this.state = 3;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.state = 5;
                throw new Exception("Unable to listen, IO error");
            }
        } else {
            throw new Exception("Unable to call listen on socket in <" + this.state + "> state");
        }
    }

    public void accept(KrollDict acceptOptions) throws Exception {
        if (this.state != 3) {
            throw new Exception("Socket is not listening, unable to call accept");
        }
        this.acceptOptions = acceptOptions;
        this.accepting = true;
    }

    private void closeSocket() throws IOException {
        if (this.clientSocket != null) {
            this.clientSocket.close();
            this.clientSocket = null;
        }
        if (this.serverSocket != null) {
            this.serverSocket.close();
            this.serverSocket = null;
        }
    }

    public void setHost(String host) {
        this.setSocketProperty("host", host);
    }

    public void setPort(int port) {
        this.setSocketProperty("port", port);
    }

    public void setTimeout(int timeout) {
        this.setSocketProperty("timeout", timeout);
    }

    public void setOptions() {
        Log.i((String)LCAT, (String)"setting options on socket is not supported yet");
    }

    public void setListenQueueSize(int listenQueueSize) {
        this.setSocketProperty("listenQueueSize", listenQueueSize);
    }

    public void setConnected(KrollCallback connected) {
        this.setSocketProperty("connected", connected);
    }

    public void setError(KrollCallback error) {
        this.setSocketProperty("error", error);
    }

    public void setAccepted(KrollCallback accepted) {
        this.setSocketProperty("accepted", accepted);
    }

    private void setSocketProperty(String propertyName, Object propertyValue) {
        if (this.state != 3 && this.state != 2) {
            this.setProperty(propertyName, propertyValue);
        } else {
            Log.e((String)LCAT, (String)("Unable to set property <" + propertyName + "> on socket in <" + this.state + "> state"));
        }
    }

    public int getState() {
        return this.state;
    }

    private KrollDict buildConnectedCallbackArgs() {
        KrollDict callbackArgs = new KrollDict();
        callbackArgs.put((Object)"socket", (Object)this);
        return callbackArgs;
    }

    private KrollDict buildErrorCallbackArgs(String error, int errorCode) {
        KrollDict callbackArgs = new KrollDict();
        callbackArgs.put((Object)"socket", (Object)this);
        callbackArgs.put((Object)"error", (Object)error);
        callbackArgs.put((Object)"errorCode", (Object)errorCode);
        return callbackArgs;
    }

    private KrollDict buildAcceptedCallbackArgs(TCPProxy acceptedTcpProxy) {
        KrollDict callbackArgs = new KrollDict();
        callbackArgs.put((Object)"socket", (Object)this);
        callbackArgs.put((Object)"inbound", (Object)acceptedTcpProxy);
        return callbackArgs;
    }

    public void updateState(int state, String callbackName, KrollDict callbackArgs) {
        Object callback;
        this.state = state;
        if (state == 5) {
            try {
                if (this.clientSocket != null) {
                    this.clientSocket.close();
                }
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException e) {
                Log.w((String)LCAT, (String)"unable to close socket in error state");
            }
        }
        if ((callback = this.getProperty(callbackName)) instanceof KrollCallback) {
            ((KrollCallback)callback).callAsync(callbackArgs);
        }
    }

    public boolean isConnected() {
        return this.state == 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(Object[] args) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("Unable to read from socket, not connected");
        }
        BufferProxy bufferProxy = null;
        int offset = 0;
        int length = 0;
        if (args.length != 1 && args.length != 3) throw new IllegalArgumentException("Invalid number of arguments");
        if (args.length > 0) {
            if (!(args[0] instanceof BufferProxy)) throw new IllegalArgumentException("Invalid buffer argument");
            bufferProxy = (BufferProxy)args[0];
            length = bufferProxy.getLength();
        }
        if (args.length == 3) {
            if (args[1] instanceof Integer) {
                offset = (Integer)args[1];
            } else {
                if (!(args[1] instanceof Double)) throw new IllegalArgumentException("Invalid offset argument");
                offset = ((Double)args[1]).intValue();
            }
            if (args[2] instanceof Integer) {
                length = (Integer)args[2];
            } else {
                if (!(args[2] instanceof Double)) throw new IllegalArgumentException("Invalid length argument");
                length = ((Double)args[2]).intValue();
            }
        }
        if (this.inputStream == null) {
            this.inputStream = this.clientSocket.getInputStream();
        }
        try {
            return TiStreamHelper.read((InputStream)this.inputStream, (BufferProxy)bufferProxy, (int)offset, (int)length);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.closeSocket();
            this.updateState(5, "error", this.buildErrorCallbackArgs("Unable to read from socket, IO error", 0));
            throw new IOException("Unable to read from socket, IO error");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int write(Object[] args) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("Unable to write to socket, not connected");
        }
        BufferProxy bufferProxy = null;
        int offset = 0;
        int length = 0;
        if (args.length != 1 && args.length != 3) throw new IllegalArgumentException("Invalid number of arguments");
        if (args.length > 0) {
            if (!(args[0] instanceof BufferProxy)) throw new IllegalArgumentException("Invalid buffer argument");
            bufferProxy = (BufferProxy)args[0];
            length = bufferProxy.getLength();
        }
        if (args.length == 3) {
            if (args[1] instanceof Integer) {
                offset = (Integer)args[1];
            } else {
                if (!(args[1] instanceof Double)) throw new IllegalArgumentException("Invalid offset argument");
                offset = ((Double)args[1]).intValue();
            }
            if (args[2] instanceof Integer) {
                length = (Integer)args[2];
            } else {
                if (!(args[2] instanceof Double)) throw new IllegalArgumentException("Invalid length argument");
                length = ((Double)args[2]).intValue();
            }
        }
        try {
            return TiStreamHelper.write((OutputStream)this.clientSocket.getOutputStream(), (BufferProxy)bufferProxy, (int)offset, (int)length);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.closeSocket();
            this.updateState(5, "error", this.buildErrorCallbackArgs("Unable to write to socket, IO error", 0));
            throw new IOException("Unable to write to socket, IO error");
        }
    }

    public boolean isWritable() {
        return this.isConnected();
    }

    public boolean isReadable() {
        return this.isConnected();
    }

    public void close() throws IOException {
        if (this.state != 2 && this.state != 3) {
            throw new IOException("Socket is not connected or listening, unable to call close on socket in <" + this.state + "> state");
        }
        try {
            this.state = 0;
            this.closeSocket();
            this.state = 4;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("Error occured when closing socket");
        }
    }

    private class ListeningSocketThread
    extends Thread {
        public ListeningSocketThread() {
            super("ListeningSocketThread");
        }

        @Override
        public void run() {
            while (true) {
                if (TCPProxy.this.accepting) {
                    try {
                        Socket acceptedSocket = TCPProxy.this.serverSocket.accept();
                        TCPProxy acceptedTcpProxy = new TCPProxy(TCPProxy.this.context);
                        acceptedTcpProxy.clientSocket = acceptedSocket;
                        acceptedTcpProxy.setProperty("host", acceptedTcpProxy.clientSocket.getInetAddress());
                        acceptedTcpProxy.setProperty("port", acceptedTcpProxy.clientSocket.getPort());
                        Object optionValue = TCPProxy.this.acceptOptions.get((Object)"timeout");
                        if (optionValue != null) {
                            acceptedTcpProxy.setProperty("timeout", TiConvert.toInt((Object)optionValue));
                        }
                        if ((optionValue = TCPProxy.this.acceptOptions.get((Object)"error")) != null && optionValue instanceof KrollCallback) {
                            acceptedTcpProxy.setProperty("error", (KrollCallback)optionValue);
                        }
                        acceptedTcpProxy.state = 2;
                        Object callback = TCPProxy.this.getProperty("accepted");
                        if (callback instanceof KrollCallback) {
                            ((KrollCallback)callback).callAsync(TCPProxy.this.buildAcceptedCallbackArgs(acceptedTcpProxy));
                        }
                        TCPProxy.this.accepting = false;
                        continue;
                    }
                    catch (IOException e) {
                        if (TCPProxy.this.state != 3) break;
                        e.printStackTrace();
                        TCPProxy.this.updateState(5, "error", TCPProxy.this.buildErrorCallbackArgs("Unable to accept new connection, IO error", 0));
                        break;
                    }
                }
                try {
                    ListeningSocketThread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Log.e((String)TCPProxy.LCAT, (String)"listening thread interrupted");
                }
            }
        }
    }

    private class ConnectedSocketThread
    extends Thread {
        public ConnectedSocketThread() {
            super("ConnectedSocketThread");
        }

        @Override
        public void run() {
            String host = TiConvert.toString((Object)TCPProxy.this.getProperty("host"));
            Object timeoutProperty = TCPProxy.this.getProperty("timeout");
            try {
                if (timeoutProperty != null) {
                    int timeout = TiConvert.toInt((Object)timeoutProperty);
                    TCPProxy.this.clientSocket = new Socket();
                    TCPProxy.this.clientSocket.setSoTimeout(timeout);
                    TCPProxy.this.clientSocket.connect(new InetSocketAddress(host, TiConvert.toInt((Object)TCPProxy.this.getProperty("port"))), timeout);
                } else {
                    TCPProxy.this.clientSocket = new Socket(host, TiConvert.toInt((Object)TCPProxy.this.getProperty("port")));
                }
                TCPProxy.this.updateState(2, "connected", TCPProxy.this.buildConnectedCallbackArgs());
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                TCPProxy.this.updateState(5, "error", TCPProxy.this.buildErrorCallbackArgs("Unable to connect, unknown host <" + host + ">", 0));
            }
            catch (IOException e) {
                e.printStackTrace();
                TCPProxy.this.updateState(5, "error", TCPProxy.this.buildErrorCallbackArgs("Unable to connect, IO error", 0));
            }
        }
    }
}

