/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;

public class TiNetworkListener {
    private static final String LCAT = "TiNetListener";
    private static final boolean DBG = TiConfig.LOGD;
    public static final String EXTRA_CONNECTED = "connected";
    public static final String EXTRA_NETWORK_TYPE = "networkType";
    public static final String EXTRA_NETWORK_TYPE_NAME = "networkTypeName";
    public static final String EXTRA_FAILOVER = "failover";
    public static final String EXTRA_REASON = "reason";
    private IntentFilter connectivityIntentFilter;
    private ConnectivityBroadcastReceiver receiver = new ConnectivityBroadcastReceiver();
    private Handler messageHandler;
    private Context context;
    private boolean listening;

    public TiNetworkListener(Handler messageHandler) {
        this.messageHandler = messageHandler;
        this.connectivityIntentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
    }

    public void attach(Context context) {
        if (!this.listening) {
            if (this.context != null) {
                throw new IllegalStateException("Context was not cleaned up from last release.");
            }
            this.context = context;
            context.registerReceiver((BroadcastReceiver)this.receiver, this.connectivityIntentFilter);
            this.listening = true;
        } else {
            Log.w((String)LCAT, (String)"Connectivity listener is already attached");
        }
    }

    public void detach() {
        if (this.listening) {
            this.context.unregisterReceiver((BroadcastReceiver)this.receiver);
            this.context = null;
            this.listening = false;
        }
    }

    private class ConnectivityBroadcastReceiver
    extends BroadcastReceiver {
        private ConnectivityBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (!action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                return;
            }
            if (TiNetworkListener.this.messageHandler == null) {
                Log.w((String)TiNetworkListener.LCAT, (String)"Network receiver is active but no handler has been set.");
                return;
            }
            boolean noConnectivity = intent.getBooleanExtra("noConnectivity", false);
            NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            NetworkInfo otherNetworkInfo = (NetworkInfo)intent.getParcelableExtra("otherNetwork");
            String reason = intent.getStringExtra(TiNetworkListener.EXTRA_REASON);
            boolean failover = intent.getBooleanExtra("isFailover", false);
            if (DBG) {
                Log.d((String)TiNetworkListener.LCAT, (String)("onReceive(): mNetworkInfo=" + networkInfo + " mOtherNetworkInfo = " + (otherNetworkInfo == null ? "[none]" : otherNetworkInfo + " noConn=" + noConnectivity)));
            }
            Message message = Message.obtain((Handler)TiNetworkListener.this.messageHandler);
            Bundle b = message.getData();
            b.putBoolean(TiNetworkListener.EXTRA_CONNECTED, !noConnectivity);
            b.putInt(TiNetworkListener.EXTRA_NETWORK_TYPE, networkInfo.getType());
            if (noConnectivity) {
                b.putString(TiNetworkListener.EXTRA_NETWORK_TYPE_NAME, "NONE");
            } else {
                b.putString(TiNetworkListener.EXTRA_NETWORK_TYPE_NAME, networkInfo.getTypeName());
            }
            b.putBoolean(TiNetworkListener.EXTRA_FAILOVER, failover);
            b.putString(TiNetworkListener.EXTRA_REASON, reason);
            message.sendToTarget();
        }
    }
}

