/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.network;

import android.net.Uri;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectHandler;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiFileProxy;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.io.TiFile;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiMimeTypeHelper;
import org.appcelerator.titanium.util.TiTempFileHelper;
import org.mozilla.javascript.Context;
import ti.modules.titanium.network.NonValidatingSSLSocketFactory;
import ti.modules.titanium.network.TiCookieStore;
import ti.modules.titanium.xml.DocumentProxy;
import ti.modules.titanium.xml.XMLModule;

public class TiHTTPClient {
    private static final String LCAT = "TiHttpClient";
    private static final boolean DBG = TiConfig.LOGD;
    private static final int IS_BINARY_THRESHOLD = 30;
    private static final int DEFAULT_MAX_BUFFER_SIZE = 524288;
    private static final String PROPERTY_MAX_BUFFER_SIZE = "ti.android.httpclient.maxbuffersize";
    private static final int PROTOCOL_DEFAULT_PORT = -1;
    private static AtomicInteger httpClientThreadCounter;
    public static final int READY_STATE_UNSENT = 0;
    public static final int READY_STATE_OPENED = 1;
    public static final int READY_STATE_HEADERS_RECEIVED = 2;
    public static final int READY_STATE_LOADING = 3;
    public static final int READY_STATE_DONE = 4;
    private static final String ON_READY_STATE_CHANGE = "onreadystatechange";
    private static final String ON_LOAD = "onload";
    private static final String ON_ERROR = "onerror";
    private static final String ON_DATA_STREAM = "ondatastream";
    private static final String ON_SEND_STREAM = "onsendstream";
    private DefaultHttpClient client;
    private KrollProxy proxy;
    private int readyState;
    private String responseText;
    private DocumentProxy responseXml;
    private int status;
    private String statusText;
    private boolean connected;
    private HttpRequest request;
    private HttpResponse response;
    private String method;
    private HttpHost host;
    private LocalResponseHandler handler;
    private Credentials credentials;
    private TiBlob responseData;
    private OutputStream responseOut;
    private String charset;
    private String contentType;
    private long maxBufferSize;
    private ArrayList<NameValuePair> nvPairs;
    private HashMap<String, ContentBody> parts;
    private String data;
    private boolean needMultipart;
    Thread clientThread;
    private boolean aborted;
    private int timeout = -1;
    private boolean autoEncodeUrl = true;
    protected HashMap<String, String> headers = new HashMap();
    private Uri uri;
    private String url;

    public TiHTTPClient(KrollProxy proxy) {
        this.proxy = proxy;
        if (httpClientThreadCounter == null) {
            httpClientThreadCounter = new AtomicInteger();
        }
        this.readyState = 0;
        this.responseText = "";
        this.credentials = null;
        this.connected = false;
        this.nvPairs = new ArrayList();
        this.parts = new HashMap();
        this.maxBufferSize = proxy.getTiContext().getTiApp().getSystemProperties().getInt(PROPERTY_MAX_BUFFER_SIZE, 524288);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReadyState() {
        TiHTTPClient tiHTTPClient = this;
        synchronized (tiHTTPClient) {
            this.notify();
        }
        return this.readyState;
    }

    public KrollCallback getCallback(String name) {
        Object value = this.proxy.getProperty(name);
        if (value != null && value instanceof KrollCallback) {
            return (KrollCallback)value;
        }
        return null;
    }

    public void fireCallback(String name) {
        KrollDict eventProperties = new KrollDict();
        eventProperties.put((Object)"source", (Object)this.proxy);
        this.fireCallback(name, new Object[]{eventProperties});
    }

    public void fireCallback(String name, Object[] args) {
        KrollCallback cb = this.getCallback(name);
        if (cb != null) {
            cb.setThisProxy(this.proxy);
            cb.callAsync(args);
        }
    }

    public boolean validatesSecureCertificate() {
        if (this.proxy.hasProperty("validatesSecureCertificate")) {
            return TiConvert.toBoolean((Object)this.proxy.getProperty("validatesSecureCertificate"));
        }
        return this.proxy.getTiContext().getTiApp().getDeployType().equals("production");
    }

    public void setReadyState(int readyState) {
        Log.d((String)LCAT, (String)("Setting ready state to " + readyState));
        this.readyState = readyState;
        this.fireCallback(ON_READY_STATE_CHANGE);
        if (readyState == 4) {
            this.fireCallback(ON_LOAD);
        }
    }

    public void sendError(String error) {
        Log.i((String)LCAT, (String)("Sending error " + error));
        KrollDict event = new KrollDict();
        event.put((Object)"error", (Object)error);
        event.put((Object)"source", (Object)this.proxy);
        this.fireCallback(ON_ERROR, new Object[]{event});
    }

    public String getResponseText() {
        if (this.responseData != null && this.responseText == null) {
            byte[] data = this.responseData.getBytes();
            if (this.charset == null) {
                int binaryCount = 0;
                int len = data.length;
                if (len > 0) {
                    for (int i = 0; i < len; ++i) {
                        byte b = data[i];
                        if (b >= 32 && b <= 127 || b == 10 || b == 13 || b == 9 || b == 8) continue;
                        ++binaryCount;
                    }
                    if (binaryCount * 100 / len >= 30) {
                        return null;
                    }
                }
                this.charset = "ISO-8859-1";
            }
            try {
                this.responseText = new String(data, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)LCAT, (String)("Unable to convert to String using charset: " + this.charset));
            }
        }
        return this.responseText;
    }

    public TiBlob getResponseData() {
        return this.responseData;
    }

    public DocumentProxy getResponseXML() {
        if (TiMimeTypeHelper.isBinaryMimeType((String)this.contentType)) {
            return null;
        }
        if (this.responseXml == null && (this.responseData != null || this.responseText != null)) {
            try {
                String text = this.getResponseText();
                if (text == null || text.length() == 0) {
                    return null;
                }
                this.responseXml = this.charset != null && this.charset.length() > 0 ? XMLModule.parse((TiContext)this.proxy.getTiContext(), (String)text, (String)this.charset) : XMLModule.parse((TiContext)this.proxy.getTiContext(), (String)text);
            }
            catch (Exception e) {
                Log.e((String)LCAT, (String)"Error parsing XML", (Throwable)e);
            }
        }
        return this.responseXml;
    }

    public void setResponseText(String responseText) {
        this.responseText = responseText;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public void abort() {
        if (this.readyState > 0 && this.readyState < 4) {
            this.aborted = true;
            if (this.client != null) {
                this.client.getConnectionManager().shutdown();
                this.client = null;
            }
        }
    }

    public String getAllResponseHeaders() {
        String result = "";
        if (this.readyState >= 2 && this.response != null) {
            StringBuilder sb = new StringBuilder(1024);
            for (Header h : this.response.getAllHeaders()) {
                sb.append(h.getName()).append(":").append(h.getValue()).append("\n");
            }
            result = sb.toString();
        }
        return result;
    }

    public void clearCookies(String url) {
        ArrayList cookies = new ArrayList(this.client.getCookieStore().getCookies());
        this.client.getCookieStore().clear();
        String lower_url = url.toLowerCase();
        for (Cookie cookie : cookies) {
            if (lower_url.contains(cookie.getDomain().toLowerCase())) continue;
            this.client.getCookieStore().addCookie(cookie);
        }
    }

    public void setRequestHeader(String header, String value) {
        if (this.readyState != 1) {
            throw new IllegalStateException("setRequestHeader can only be called before invoking send.");
        }
        this.headers.put(header, value);
    }

    public String getResponseHeader(String header) {
        String result = "";
        if (this.readyState > 1) {
            Header h = this.response.getFirstHeader(header);
            if (h != null) {
                result = h.getValue();
            } else if (DBG) {
                Log.w((String)LCAT, (String)("No value for respose header: " + header));
            }
        } else {
            throw new IllegalStateException("getResponseHeader can only be called when readyState > 1");
        }
        return result;
    }

    private static Uri getCleanUri(String uri) {
        int lastAt;
        Uri base = Uri.parse((String)uri);
        Uri.Builder builder = base.buildUpon();
        builder.encodedQuery(Uri.encode((String)Uri.decode((String)base.getQuery()), (String)"&="));
        String encodedAuthority = Uri.encode((String)Uri.decode((String)base.getAuthority()), (String)"/:@");
        int firstAt = encodedAuthority.indexOf(64);
        if (firstAt >= 0 && (lastAt = encodedAuthority.lastIndexOf(64)) > firstAt) {
            encodedAuthority = Uri.encode((String)encodedAuthority.substring(0, lastAt), (String)"/:") + encodedAuthority.substring(lastAt);
        }
        builder.encodedAuthority(encodedAuthority);
        builder.encodedPath(Uri.encode((String)Uri.decode((String)base.getPath()), (String)"/"));
        return builder.build();
    }

    public void open(String method, String url) {
        if (DBG) {
            Log.d((String)LCAT, (String)("open request method=" + method + " url=" + url));
        }
        this.uri = this.autoEncodeUrl ? TiHTTPClient.getCleanUri(url) : Uri.parse((String)url);
        this.url = this.autoEncodeUrl && !url.matches(".*\\?.*\\%\\d\\d.*$") ? this.uri.toString() : url;
        this.method = method;
        String hostString = this.uri.getHost();
        int port = -1;
        if (this.uri.getUserInfo() != null && this.uri.getUserInfo().contains("@")) {
            try {
                URL javaUrl = new URL(this.uri.toString());
                hostString = javaUrl.getHost();
                port = javaUrl.getPort();
            }
            catch (MalformedURLException e) {
                Log.e((String)LCAT, (String)("Error attempting to derive Java url from uri: " + e.getMessage()), (Throwable)e);
            }
        } else {
            port = this.uri.getPort();
        }
        if (DBG) {
            Log.d((String)LCAT, (String)("Instantiating host with hostString='" + hostString + "', port='" + port + "', scheme='" + this.uri.getScheme() + "'"));
        }
        this.host = new HttpHost(hostString, port, this.uri.getScheme());
        if (this.uri.getUserInfo() != null) {
            this.credentials = new UsernamePasswordCredentials(this.uri.getUserInfo());
        }
        this.setReadyState(1);
        this.setRequestHeader("User-Agent", (String)this.proxy.getProperty("userAgent"));
        if (!hostString.contains("twitter.com")) {
            this.setRequestHeader("X-Requested-With", "XMLHttpRequest");
        } else {
            Log.i((String)LCAT, (String)"Twitter: not sending X-Requested-With header");
        }
    }

    public void addStringData(String data) {
        this.data = data;
    }

    public void addPostData(String name, String value) {
        if (value == null) {
            value = "";
        }
        try {
            if (this.needMultipart) {
                this.parts.put(name, (ContentBody)new StringBody(value, "", null));
            } else {
                this.nvPairs.add((NameValuePair)new BasicNameValuePair(name, value.toString()));
            }
        }
        catch (UnsupportedEncodingException e) {
            this.nvPairs.add((NameValuePair)new BasicNameValuePair(name, value.toString()));
        }
    }

    public int addTitaniumFileAsPostData(String name, Object value) {
        try {
            if (value instanceof TiBaseFile) {
                TiBaseFile baseFile = (TiBaseFile)value;
                FileBody body = new FileBody(baseFile.getNativeFile(), TiMimeTypeHelper.getMimeType((String)baseFile.nativePath()));
                this.parts.put(name, (ContentBody)body);
                return (int)baseFile.getNativeFile().length();
            }
            if (value instanceof TiBlob) {
                TiBlob blob = (TiBlob)value;
                String mimeType = blob.getMimeType();
                File tmpFile = File.createTempFile("tixhr", "." + TiMimeTypeHelper.getFileExtensionFromMimeType((String)mimeType, (String)"txt"));
                FileOutputStream fos = new FileOutputStream(tmpFile);
                fos.write(blob.getBytes());
                fos.close();
                FileBody body = new FileBody(tmpFile, mimeType);
                this.parts.put(name, (ContentBody)body);
                return blob.getLength();
            }
            if (value != null) {
                Log.e((String)LCAT, (String)(name + " is a " + value.getClass().getSimpleName()));
            } else {
                Log.e((String)LCAT, (String)(name + " is null"));
            }
        }
        catch (IOException e) {
            Log.e((String)LCAT, (String)("Error adding post data (" + name + "): " + e.getMessage()));
        }
        return 0;
    }

    public void send(Object userData) throws MethodNotSupportedException {
        if (this.client == null) {
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            BasicHttpParams params = new BasicHttpParams();
            ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)200);
            ConnPerRouteBean connPerRoute = new ConnPerRouteBean(20);
            ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)connPerRoute);
            HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            this.client = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager((HttpParams)params, registry), (HttpParams)params);
            this.client.setCookieStore((CookieStore)TiCookieStore.getInstance());
        }
        this.aborted = false;
        double totalLength = 0.0;
        this.needMultipart = false;
        if (userData != null) {
            if (userData instanceof KrollDict) {
                KrollDict data = (KrollDict)userData;
                boolean isPostOrPut = this.method.equals("POST") || this.method.equals("PUT");
                boolean isGet = !isPostOrPut && this.method.equals("GET");
                for (String key : data.keySet()) {
                    Object value = data.get((Object)key);
                    if (value == null) continue;
                    if (value instanceof TiFileProxy) {
                        value = ((TiFileProxy)value).getBaseFile();
                    }
                    if (!(value instanceof TiBaseFile) && !(value instanceof TiBlob)) continue;
                    this.needMultipart = true;
                    break;
                }
                boolean queryStringAltered = false;
                for (String key : data.keySet()) {
                    Object value = data.get((Object)key);
                    if (isPostOrPut && value != null) {
                        if (value instanceof TiFileProxy) {
                            value = ((TiFileProxy)value).getBaseFile();
                        }
                        if (value instanceof TiBaseFile || value instanceof TiBlob) {
                            totalLength += (double)this.addTitaniumFileAsPostData(key, value);
                            continue;
                        }
                        String str = TiConvert.toString((Object)value);
                        this.addPostData(key, str);
                        totalLength += (double)str.length();
                        continue;
                    }
                    if (!isGet) continue;
                    this.uri = this.uri.buildUpon().appendQueryParameter(key, TiConvert.toString((Object)value)).build();
                    queryStringAltered = true;
                }
                if (queryStringAltered) {
                    this.url = this.uri.toString();
                }
            } else {
                this.addStringData(TiConvert.toString((Object)userData));
            }
        }
        if (DBG) {
            Log.d((String)LCAT, (String)("Instantiating http request with method='" + this.method + "' and this url:"));
            Log.d((String)LCAT, (String)this.url);
        }
        this.request = new DefaultHttpRequestFactory().newHttpRequest(this.method, this.url);
        for (String header : this.headers.keySet()) {
            this.request.setHeader(header, this.headers.get(header));
        }
        this.clientThread = new Thread((Runnable)new ClientRunnable(totalLength), "TiHttpClient-" + httpClientThreadCounter.incrementAndGet());
        this.clientThread.setPriority(1);
        this.clientThread.start();
        if (DBG) {
            Log.d((String)LCAT, (String)"Leaving send()");
        }
    }

    private void handleURLEncodedData(UrlEncodedFormEntity form) {
        UrlEncodedFormEntity entity = null;
        if (this.data != null) {
            try {
                entity = new StringEntity(this.data, "UTF-8");
            }
            catch (Exception ex) {
                Log.e((String)LCAT, (String)"Exception, implement recovery: ", (Throwable)ex);
            }
        } else {
            entity = form;
        }
        if (entity != null) {
            Header header = this.request.getFirstHeader("Content-Type");
            if (header == null) {
                entity.setContentType("application/x-www-form-urlencoded");
            } else {
                entity.setContentType(header.getValue());
            }
            HttpEntityEnclosingRequest e = (HttpEntityEnclosingRequest)this.request;
            e.setEntity((HttpEntity)entity);
        }
    }

    public String getLocation() {
        return this.url;
    }

    public String getConnectionType() {
        return this.method;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setTimeout(int millis) {
        this.timeout = millis;
    }

    protected void setAutoEncodeUrl(boolean value) {
        this.autoEncodeUrl = value;
    }

    protected boolean getAutoEncodeUrl() {
        return this.autoEncodeUrl;
    }

    private class ClientRunnable
    implements Runnable {
        private double totalLength;

        public ClientRunnable(double totalLength) {
            this.totalLength = totalLength;
        }

        @Override
        public void run() {
            try {
                String result;
                block22: {
                    Thread.sleep(10L);
                    if (DBG) {
                        Log.d((String)TiHTTPClient.LCAT, (String)"send()");
                    }
                    TiHTTPClient.this.handler = new LocalResponseHandler(TiHTTPClient.this);
                    Object sslFactory = TiHTTPClient.this.validatesSecureCertificate() ? SSLSocketFactory.getSocketFactory() : new NonValidatingSSLSocketFactory();
                    TiHTTPClient.this.client.getConnectionManager().getSchemeRegistry().register(new Scheme("https", (SocketFactory)sslFactory, 443));
                    if (TiHTTPClient.this.credentials != null) {
                        TiHTTPClient.this.client.getCredentialsProvider().setCredentials(new AuthScope(TiHTTPClient.this.uri.getHost(), -1), TiHTTPClient.this.credentials);
                        TiHTTPClient.this.credentials = null;
                    }
                    TiHTTPClient.this.client.setRedirectHandler((org.apache.http.client.RedirectHandler)new RedirectHandler());
                    if (TiHTTPClient.this.request instanceof BasicHttpEntityEnclosingRequest) {
                        UrlEncodedFormEntity form = null;
                        MultipartEntity mpe = null;
                        if (TiHTTPClient.this.nvPairs.size() > 0) {
                            try {
                                form = new UrlEncodedFormEntity((List)TiHTTPClient.this.nvPairs, "UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                Log.e((String)TiHTTPClient.LCAT, (String)"Unsupported encoding: ", (Throwable)e);
                            }
                        }
                        if (TiHTTPClient.this.parts.size() > 0 && TiHTTPClient.this.needMultipart) {
                            mpe = new MultipartEntity();
                            for (String name : TiHTTPClient.this.parts.keySet()) {
                                Log.d((String)TiHTTPClient.LCAT, (String)("adding part " + name + ", part type: " + ((ContentBody)TiHTTPClient.this.parts.get(name)).getMimeType() + ", len: " + ((ContentBody)TiHTTPClient.this.parts.get(name)).getContentLength()));
                                mpe.addPart(name, (ContentBody)TiHTTPClient.this.parts.get(name));
                            }
                            if (form != null) {
                                try {
                                    ByteArrayOutputStream bos = new ByteArrayOutputStream((int)form.getContentLength());
                                    form.writeTo((OutputStream)bos);
                                    mpe.addPart("form", (ContentBody)new StringBody(bos.toString(), "application/x-www-form-urlencoded", Charset.forName("UTF-8")));
                                }
                                catch (UnsupportedEncodingException e) {
                                    Log.e((String)TiHTTPClient.LCAT, (String)"Unsupported encoding: ", (Throwable)e);
                                }
                                catch (IOException e) {
                                    Log.e((String)TiHTTPClient.LCAT, (String)"Error converting form to string: ", (Throwable)e);
                                }
                            }
                            HttpEntityEnclosingRequest e = (HttpEntityEnclosingRequest)TiHTTPClient.this.request;
                            Log.d((String)TiHTTPClient.LCAT, (String)("totalLength=" + this.totalLength));
                            ProgressEntity progressEntity = new ProgressEntity((HttpEntity)mpe, new ProgressListener(){

                                @Override
                                public void progress(int progress) {
                                    KrollCallback cb = TiHTTPClient.this.getCallback(TiHTTPClient.ON_SEND_STREAM);
                                    if (cb != null) {
                                        KrollDict data = new KrollDict();
                                        data.put((Object)"progress", (Object)((double)progress / ClientRunnable.this.totalLength));
                                        data.put((Object)"source", (Object)TiHTTPClient.this.proxy);
                                        cb.callAsync(data);
                                    }
                                }
                            });
                            e.setEntity((HttpEntity)progressEntity);
                            e.addHeader("Length", this.totalLength + "");
                        } else {
                            TiHTTPClient.this.handleURLEncodedData(form);
                        }
                    }
                    if (TiHTTPClient.this.timeout != -1) {
                        HttpConnectionParams.setConnectionTimeout((HttpParams)TiHTTPClient.this.request.getParams(), (int)TiHTTPClient.this.timeout);
                        HttpConnectionParams.setSoTimeout((HttpParams)TiHTTPClient.this.request.getParams(), (int)TiHTTPClient.this.timeout);
                    }
                    if (DBG) {
                        Log.d((String)TiHTTPClient.LCAT, (String)"Preparing to execute request");
                    }
                    result = null;
                    try {
                        result = (String)TiHTTPClient.this.client.execute(TiHTTPClient.this.host, TiHTTPClient.this.request, (ResponseHandler)TiHTTPClient.this.handler);
                    }
                    catch (IOException e) {
                        if (TiHTTPClient.this.aborted) break block22;
                        throw e;
                    }
                }
                if (result != null) {
                    Log.d((String)TiHTTPClient.LCAT, (String)("Have result back from request len=" + result.length()));
                }
                TiHTTPClient.this.connected = false;
                TiHTTPClient.this.setResponseText(result);
                TiHTTPClient.this.setReadyState(4);
            }
            catch (Throwable t) {
                Log.d((String)TiHTTPClient.LCAT, (String)"clearing the expired and idle connections");
                TiHTTPClient.this.client.getConnectionManager().closeExpiredConnections();
                TiHTTPClient.this.client.getConnectionManager().closeIdleConnections(0L, TimeUnit.NANOSECONDS);
                String msg = t.getMessage();
                if (msg == null && t.getCause() != null) {
                    msg = t.getCause().getMessage();
                }
                if (msg == null) {
                    msg = t.getClass().getName();
                }
                Log.e((String)TiHTTPClient.LCAT, (String)("HTTP Error (" + t.getClass().getName() + "): " + msg), (Throwable)t);
                TiHTTPClient.this.sendError(msg);
            }
        }
    }

    private class ProgressOutputStream
    extends FilterOutputStream {
        private ProgressListener listener;
        private int transferred;
        private int lastTransferred;

        public ProgressOutputStream(OutputStream delegate, ProgressListener listener) {
            super(delegate);
            this.transferred = 0;
            this.lastTransferred = 0;
            this.listener = listener;
        }

        private void fireProgress() {
            if (this.transferred - this.lastTransferred >= 512) {
                this.lastTransferred = this.transferred;
                this.listener.progress(this.transferred);
            }
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            ++this.transferred;
            this.fireProgress();
        }
    }

    private class ProgressEntity
    implements HttpEntity {
        private HttpEntity delegate;
        private ProgressListener listener;

        public ProgressEntity(HttpEntity delegate, ProgressListener listener) {
            this.delegate = delegate;
            this.listener = listener;
        }

        public void consumeContent() throws IOException {
            this.delegate.consumeContent();
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return this.delegate.getContent();
        }

        public Header getContentEncoding() {
            return this.delegate.getContentEncoding();
        }

        public long getContentLength() {
            return this.delegate.getContentLength();
        }

        public Header getContentType() {
            return this.delegate.getContentType();
        }

        public boolean isChunked() {
            return this.delegate.isChunked();
        }

        public boolean isRepeatable() {
            return this.delegate.isRepeatable();
        }

        public boolean isStreaming() {
            return this.delegate.isStreaming();
        }

        public void writeTo(OutputStream stream) throws IOException {
            ProgressOutputStream progressOut = new ProgressOutputStream(stream, this.listener);
            this.delegate.writeTo((OutputStream)progressOut);
        }
    }

    private static interface ProgressListener {
        public void progress(int var1);
    }

    class LocalResponseHandler
    implements ResponseHandler<String> {
        public WeakReference<TiHTTPClient> client;
        public InputStream is;
        public HttpEntity entity;

        public LocalResponseHandler(TiHTTPClient client) {
            this.client = new WeakReference<TiHTTPClient>(client);
        }

        public String handleResponse(HttpResponse response) throws HttpResponseException, IOException {
            TiHTTPClient.this.connected = true;
            String clientResponse = null;
            if (this.client != null) {
                StatusLine statusLine;
                TiHTTPClient c = (TiHTTPClient)this.client.get();
                if (c != null) {
                    c.response = response;
                    c.setReadyState(2);
                    c.setStatus(response.getStatusLine().getStatusCode());
                    c.setStatusText(response.getStatusLine().getReasonPhrase());
                    c.setReadyState(3);
                }
                if (DBG) {
                    try {
                        Log.w((String)TiHTTPClient.LCAT, (String)("Entity Type: " + response.getEntity().getClass()));
                        Log.w((String)TiHTTPClient.LCAT, (String)("Entity Content Type: " + response.getEntity().getContentType().getValue()));
                        Log.w((String)TiHTTPClient.LCAT, (String)("Entity isChunked: " + response.getEntity().isChunked()));
                        Log.w((String)TiHTTPClient.LCAT, (String)("Entity isStreaming: " + response.getEntity().isStreaming()));
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if ((statusLine = response.getStatusLine()).getStatusCode() >= 300) {
                    this.setResponseText(response.getEntity());
                    throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                }
                this.entity = response.getEntity();
                if (this.entity != null) {
                    if (this.entity.getContentType() != null) {
                        TiHTTPClient.this.contentType = this.entity.getContentType().getValue();
                    }
                    this.is = this.entity.getContent();
                    TiHTTPClient.this.charset = EntityUtils.getContentCharSet((HttpEntity)this.entity);
                } else {
                    this.is = null;
                }
                TiHTTPClient.this.responseData = null;
                if (this.is != null) {
                    long contentLength = this.entity.getContentLength();
                    if (DBG) {
                        Log.d((String)TiHTTPClient.LCAT, (String)("Content length: " + contentLength));
                    }
                    int count = 0;
                    long totalSize = 0L;
                    byte[] buf = new byte[4096];
                    if (DBG) {
                        Log.d((String)TiHTTPClient.LCAT, (String)("Available: " + this.is.available()));
                    }
                    if (this.entity != null) {
                        TiHTTPClient.this.charset = EntityUtils.getContentCharSet((HttpEntity)this.entity);
                    }
                    while ((count = this.is.read(buf)) != -1) {
                        totalSize += (long)count;
                        try {
                            this.handleEntityData(buf, count, totalSize, contentLength);
                        }
                        catch (IOException e) {
                            Log.e((String)TiHTTPClient.LCAT, (String)"Error handling entity data", (Throwable)e);
                            Context.throwAsScriptRuntimeEx((Throwable)e);
                        }
                    }
                    if (this.entity != null) {
                        try {
                            this.entity.consumeContent();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (totalSize > 0L) {
                        this.finishedReceivingEntityData(totalSize);
                    }
                }
            }
            return clientResponse;
        }

        private TiFile createFileResponseData(boolean dumpResponseOut) throws IOException {
            File outFile;
            TiApplication app = TiApplication.getInstance();
            if (app != null) {
                TiTempFileHelper helper = app.getTempFileHelper();
                outFile = helper.createTempFile("tihttp", "tmp");
            } else {
                outFile = File.createTempFile("tihttp", "tmp");
            }
            TiFile tiFile = new TiFile(TiHTTPClient.this.proxy.getTiContext(), outFile, outFile.getAbsolutePath(), false);
            if (dumpResponseOut) {
                ByteArrayOutputStream byteStream = (ByteArrayOutputStream)TiHTTPClient.this.responseOut;
                tiFile.write(TiBlob.blobFromData((TiContext)TiHTTPClient.this.proxy.getTiContext(), (byte[])byteStream.toByteArray()), false);
            }
            TiHTTPClient.this.responseOut = new FileOutputStream(outFile, dumpResponseOut);
            TiHTTPClient.this.responseData = TiBlob.blobFromFile((TiContext)TiHTTPClient.this.proxy.getTiContext(), (TiBaseFile)tiFile, (String)TiHTTPClient.this.contentType);
            return tiFile;
        }

        private void handleEntityData(byte[] data, int size, long totalSize, long contentLength) throws IOException {
            if (TiHTTPClient.this.responseOut == null) {
                if (contentLength > TiHTTPClient.this.maxBufferSize) {
                    this.createFileResponseData(false);
                } else {
                    long streamSize = contentLength > 0L ? contentLength : 512L;
                    TiHTTPClient.this.responseOut = new ByteArrayOutputStream((int)streamSize);
                }
            }
            if (totalSize > TiHTTPClient.this.maxBufferSize && TiHTTPClient.this.responseOut instanceof ByteArrayOutputStream) {
                this.createFileResponseData(true);
            }
            TiHTTPClient.this.responseOut.write(data, 0, size);
            KrollCallback onDataStreamCallback = TiHTTPClient.this.getCallback(TiHTTPClient.ON_DATA_STREAM);
            if (onDataStreamCallback != null) {
                KrollDict o = new KrollDict();
                o.put((Object)"totalCount", (Object)contentLength);
                o.put((Object)"totalSize", (Object)totalSize);
                o.put((Object)"size", (Object)size);
                byte[] blobData = new byte[size];
                System.arraycopy(data, 0, blobData, 0, size);
                TiBlob blob = TiBlob.blobFromData((TiContext)TiHTTPClient.this.proxy.getTiContext(), (byte[])blobData, (String)TiHTTPClient.this.contentType);
                o.put((Object)"blob", (Object)blob);
                o.put((Object)"progress", (Object)((double)totalSize / (double)contentLength));
                onDataStreamCallback.callAsync(o);
            }
        }

        private void finishedReceivingEntityData(long contentLength) throws IOException {
            if (TiHTTPClient.this.responseOut instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteStream = (ByteArrayOutputStream)TiHTTPClient.this.responseOut;
                TiHTTPClient.this.responseData = TiBlob.blobFromData((TiContext)TiHTTPClient.this.proxy.getTiContext(), (byte[])byteStream.toByteArray(), (String)TiHTTPClient.this.contentType);
            }
            TiHTTPClient.this.responseOut.close();
            TiHTTPClient.this.responseOut = null;
        }

        private void setResponseText(HttpEntity entity) throws IOException, ParseException {
            if (entity != null) {
                TiHTTPClient.this.responseText = EntityUtils.toString((HttpEntity)entity);
            }
        }
    }

    class RedirectHandler
    extends DefaultRedirectHandler {
        RedirectHandler() {
        }

        public URI getLocationURI(HttpResponse response, HttpContext context) throws ProtocolException {
            if (response == null) {
                throw new IllegalArgumentException("HTTP response may not be null");
            }
            Header locationHeader = response.getFirstHeader("location");
            if (locationHeader == null) {
                throw new ProtocolException("Received redirect response " + response.getStatusLine() + " but no location header");
            }
            String location = locationHeader.getValue().replaceAll(" ", "%20");
            response.setHeader("location", location);
            return super.getLocationURI(response, context);
        }
    }
}

